/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketPingAck
extends ZrtpPacketBase {
    private static final int ZRTP_PING_ACK_LENGTH = 6;
    private static final int VERSION_OFFSET = 12;
    private static final int LOCAL_EP_OFFSET = 16;
    private static final int REMOTE_EP_OFFSET = 24;
    private static final int PEER_SSRC_OFFSET = 32;
    private static final int PING_ACK_LENGTH = 40;

    public ZrtpPacketPingAck() {
        super(new byte[40]);
        this.setZrtpId();
        this.setVersion(ZrtpConstants.zrtpVersion_11);
        this.setLength(9);
        this.setMessageType(ZrtpConstants.PingAckMsg);
    }

    public ZrtpPacketPingAck(byte[] data) {
        super(data);
    }

    public final byte[] getRemoteEpHash() {
        return ZrtpUtils.readRegion(this.packetBuffer, 24, 8);
    }

    public final void setRemoteEpHash(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 24, 8);
    }

    public final byte[] getLocalEpHash() {
        return ZrtpUtils.readRegion(this.packetBuffer, 16, 8);
    }

    public final void setLocalEpHash(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 16, 8);
    }

    public final void setPeerSSRC(int data) {
        ZrtpUtils.int32ToArrayInPlace(data, this.packetBuffer, 32);
    }

    private void setVersion(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 4);
    }
}

