/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.element;

import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jxmpp.jid.Jid;

public class MamElements {
    public static final String NAMESPACE = "urn:xmpp:mam:1";

    public static class NeverJidListElement
    implements Element {
        private List<Jid> neverJids;

        public NeverJidListElement(List<Jid> neverJids) {
            this.neverJids = neverJids;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("never");
            for (Jid jid : this.neverJids) {
                xml.element("jid", (CharSequence)jid);
            }
            xml.closeElement("never");
            return xml;
        }
    }

    public static class AlwaysJidListElement
    implements Element {
        private final List<Jid> alwaysJids;

        AlwaysJidListElement(List<Jid> alwaysJids) {
            this.alwaysJids = alwaysJids;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("always");
            for (Jid jid : this.alwaysJids) {
                xml.element("jid", (CharSequence)jid);
            }
            xml.closeElement("always");
            return xml;
        }
    }

    public static class MamResultExtension
    implements ExtensionElement {
        public static final String ELEMENT = "result";
        private final String id;
        private final Forwarded forwarded;
        private String queryId;

        public MamResultExtension(String queryId, String id, Forwarded forwarded) {
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new IllegalArgumentException("id must not be null or empty");
            }
            if (forwarded == null) {
                throw new IllegalArgumentException("forwarded must no be null");
            }
            this.id = id;
            this.forwarded = forwarded;
            this.queryId = queryId;
        }

        public String getId() {
            return this.id;
        }

        public Forwarded getForwarded() {
            return this.forwarded;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public final String getNamespace() {
            return MamElements.NAMESPACE;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement((NamedElement)this);
            xml.xmlnsAttribute(MamElements.NAMESPACE);
            xml.optAttribute("queryid", this.getQueryId());
            xml.optAttribute("id", this.getId());
            xml.rightAngleBracket();
            xml.element((Element)this.getForwarded());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public static MamResultExtension from(Message message) {
            return (MamResultExtension)message.getExtension(ELEMENT, MamElements.NAMESPACE);
        }
    }
}

