/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.data.element;

import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IoTDataField
implements NamedElement {
    private final Type type;
    private final String name;
    private String valueString;

    protected IoTDataField(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final String getElementName() {
        return this.type.stringRepresentation;
    }

    public final XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
        xml.attribute("name", this.name).attribute("value", this.getValueString());
        xml.closeEmptyElement();
        return xml;
    }

    public final String getValueString() {
        if (this.valueString == null) {
            this.valueString = this.getValueInternal();
        }
        return this.valueString;
    }

    protected abstract String getValueInternal();

    public static class BooleanField
    extends IoTDataField {
        private final boolean value;

        public BooleanField(String name, boolean value) {
            super(Type.bool, name);
            this.value = value;
        }

        @Override
        protected String getValueInternal() {
            return Boolean.toString(this.value);
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static class IntField
    extends IoTDataField {
        private final int value;

        public IntField(String name, int value) {
            super(Type.integer, name);
            this.value = value;
        }

        @Override
        protected String getValueInternal() {
            return Integer.toString(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum Type {
        integer("int"),
        bool("boolean");

        private final String stringRepresentation;

        private Type(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }
    }
}

