/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_DISSALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Logger logger = Logger.getLogger(XMLUtils.class);

    public static String getAttribute(Node node, String name) {
        if (node == null) {
            return null;
        }
        Node attribute = node.getAttributes().getNamedItem(name);
        return attribute == null ? null : attribute.getNodeValue().trim();
    }

    public static String getText(Element parentNode) {
        Text text = XMLUtils.getTextNode(parentNode);
        return text == null ? null : text.getData();
    }

    public static void setText(Element parentNode, String data) {
        if (data == null) {
            return;
        }
        Text txt = XMLUtils.getTextNode(parentNode);
        if (txt != null) {
            txt.setData(data);
        } else {
            txt = parentNode.getOwnerDocument().createTextNode(data);
            parentNode.appendChild(txt);
        }
    }

    public static void setCData(Element element, String data) {
        if (data == null) {
            return;
        }
        CDATASection txt = XMLUtils.getCDataNode(element);
        if (txt != null) {
            txt.setData(data);
        } else {
            txt = element.getOwnerDocument().createCDATASection(data);
            element.appendChild(txt);
        }
    }

    public static String getCData(Element element) {
        CDATASection text = XMLUtils.getCDataNode(element);
        return text == null ? null : text.getData().trim();
    }

    public static CDATASection getCDataNode(Element element) {
        return (CDATASection)XMLUtils.getChildByType(element, (short)4);
    }

    public static Text getTextNode(Element element) {
        return (Text)XMLUtils.getChildByType(element, (short)3);
    }

    public static Node getChildByType(Element element, short nodeType) {
        if (element == null) {
            return null;
        }
        NodeList nodes = element.getChildNodes();
        if (nodes == null || nodes.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            String data;
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != nodeType || (type == 3 || type == 4) && ((data = ((Text)node).getData()) == null || data.trim().length() < 1)) continue;
            return node;
        }
        return null;
    }

    public static void writeXML(Document document, File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        XMLUtils.writeXML(document, new StreamResult(new OutputStreamWriter((OutputStream)fos, "UTF-8")), null, null);
        fos.close();
    }

    public static void writeXML(Document document, Writer writer) throws IOException {
        XMLUtils.writeXML(document, new StreamResult(writer), null, null);
        writer.close();
    }

    public static void writeXML(Document document, StreamResult streamResult, String doctypeSystem, String doctypePublic) throws IOException {
        try {
            DOMSource domSource = new DOMSource(document);
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Transformer serializer = tf.newTransformer();
            if (doctypeSystem != null) {
                serializer.setOutputProperty("doctype-system", doctypeSystem);
            }
            if (doctypePublic != null) {
                serializer.setOutputProperty("doctype-public", doctypePublic);
            }
            serializer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException ex) {
            logger.error((Object)"Error saving configuration file", (Throwable)ex);
            throw new IOException("Failed to write the configuration file: " + ex.getMessageAndLocation());
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)"Error saving configuration file", (Throwable)ex);
        }
    }

    public static void indentedWriteXML(Document doc, OutputStream out) {
        if (out != null) {
            try {
                OutputStreamWriter wri = new OutputStreamWriter(out, "UTF-8");
                XMLUtils.writeXML(doc, new StreamResult(wri), null, null);
                out.close();
            }
            catch (IOException exc) {
                throw new RuntimeException("Unable to write xml", exc);
            }
        }
    }

    public static void printChildElements(Element root, PrintStream out, boolean recurse, String prefix) {
        Node node;
        out.print(prefix + "<" + root.getNodeName());
        NamedNodeMap attrs = root.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            node = attrs.item(i);
            out.print(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
        }
        out.println(">");
        String data = XMLUtils.getText(root);
        if (data != null && data.trim().length() > 0) {
            out.println(prefix + "\t" + data);
        }
        if ((data = XMLUtils.getCData(root)) != null && data.trim().length() > 0) {
            out.println(prefix + "\t<![CDATA[" + data + "]]>");
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (recurse) {
                XMLUtils.printChildElements((Element)node, out, recurse, prefix + "\t");
                continue;
            }
            out.println(prefix + node.getNodeName());
        }
        out.println(prefix + "</" + root.getNodeName() + ">");
    }

    public static Element findChild(Element parent, String tagName) {
        if (parent == null || tagName == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + parent + "; tagName = " + tagName);
        }
        NodeList nodes = parent.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(tagName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> findChildren(Element parent, String tagName) {
        if (parent == null || tagName == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + parent + "; tagName = " + tagName);
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals(tagName)) continue;
            result.add(element);
        }
        return result;
    }

    public static Element locateElement(Element root, String tagName, String keyAttributeName, String keyAttributeValue) {
        NodeList nodes = root.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            String attr;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (node.getNodeName().equals(tagName) && (attr = element.getAttribute(keyAttributeName)) != null && attr.equals(keyAttributeValue)) {
                return element;
            }
            Element child = XMLUtils.locateElement(element, tagName, keyAttributeName, keyAttributeValue);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static List<Element> locateElements(Element root, String tagName, String keyAttributeName, String keyAttributeValue) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodes = root.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            List<Element> childs;
            Element element;
            String attr;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(tagName) && (attr = (element = (Element)node).getAttribute(keyAttributeName)) != null && attr.equals(keyAttributeValue)) {
                result.add(element);
            }
            if ((childs = XMLUtils.locateElements((Element)node, tagName, keyAttributeName, keyAttributeValue)) == null) continue;
            result.addAll(childs);
        }
        return result;
    }

    public static boolean isStandartXmlNamespace(String namespace) {
        namespace = XMLUtils.normalizeNamespace(namespace);
        return XMLUtils.normalizeNamespace("http://www.w3.org/XML/1998/namespace").equals(namespace) || XMLUtils.normalizeNamespace("http://www.w3.org/2000/xmlns/").equals(namespace) || XMLUtils.normalizeNamespace("http://www.w3.org/2001/XMLSchema").equals(namespace) || XMLUtils.normalizeNamespace("http://www.w3.org/2001/XMLSchema-instance").equals(namespace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNamespaceUri(Node node) {
        String prefix = node.getPrefix();
        String namespaceUri = node.getNamespaceURI();
        if (!StringUtils.isNullOrEmpty((String)namespaceUri)) {
            return XMLUtils.normalizeNamespace(namespaceUri);
        }
        if ("xmlns".equals(node.getNodeName()) || "xmlns".equals(prefix)) {
            return XMLUtils.normalizeNamespace("http://www.w3.org/2000/xmlns/");
        }
        Element rootElement = node.getOwnerDocument().getDocumentElement();
        Node parentNode = null;
        while (parentNode != rootElement) {
            if (parentNode == null) {
                if (node.getNodeType() == 2) {
                    parentNode = ((Attr)node).getOwnerElement();
                    if (StringUtils.isNullOrEmpty((String)prefix)) {
                        prefix = parentNode.getPrefix();
                    }
                } else {
                    if (node.getNodeType() != 1) return null;
                    parentNode = node.getParentNode();
                }
            } else {
                parentNode = parentNode.getParentNode();
            }
            String parentPrefix = parentNode.getPrefix();
            String parentNamespaceUri = parentNode.getNamespaceURI();
            if (StringUtils.isNullOrEmpty((String)prefix)) {
                Node xmlnsAttribute = parentNode.getAttributes().getNamedItem("xmlns");
                if (xmlnsAttribute == null) continue;
                return ((Attr)xmlnsAttribute).getValue();
            }
            if (!Objects.equals(prefix, parentPrefix) || StringUtils.isNullOrEmpty((String)parentNamespaceUri)) continue;
            return XMLUtils.normalizeNamespace(parentNamespaceUri);
        }
        if (!"xml".equals(prefix)) return null;
        return XMLUtils.normalizeNamespace("http://www.w3.org/XML/1998/namespace");
    }

    private static String normalizeNamespace(String namespace) {
        if (namespace.endsWith("/")) {
            return namespace.substring(0, namespace.length() - 1);
        }
        return namespace;
    }

    public static boolean hasChildElements(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Document createDocument() throws Exception {
        return XMLUtils.createDocument(null);
    }

    public static Document createDocument(String xml, boolean allowExternalEntities) throws Exception {
        DocumentBuilderFactory builderFactory = XMLUtils.newDocumentBuilderFactory(allowExternalEntities);
        builderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        if (!StringUtils.isNullOrEmpty((String)xml)) {
            InputStream input = StringUtils.fromString((String)xml);
            return documentBuilder.parse(input);
        }
        return documentBuilder.newDocument();
    }

    public static Document createDocument(String xml) throws Exception {
        return XMLUtils.createDocument(xml, false);
    }

    public static String createXml(Document document) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return stringWriter.toString();
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() throws ParserConfigurationException {
        return XMLUtils.newDocumentBuilderFactory(false);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(boolean allowExternalEntities) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (!allowExternalEntities) {
            XMLUtils.disableExternalEntities(factory);
        }
        return factory;
    }

    public static void disableExternalEntities(DocumentBuilderFactory factory) throws ParserConfigurationException {
        try {
            factory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        }
        catch (ParserConfigurationException pce) {
            if (OSUtils.IS_ANDROID) {
                logger.warn((Object)"Failed to set feature: http://xml.org/sax/features/external-general-entities");
            }
            throw pce;
        }
        try {
            factory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (ParserConfigurationException pce) {
            if (OSUtils.IS_ANDROID) {
                logger.warn((Object)"Failed to set feature: http://xml.org/sax/features/external-parameter-entities");
            }
            throw pce;
        }
        try {
            factory.setFeature(FEATURE_DISSALLOW_DOCTYPE, true);
        }
        catch (ParserConfigurationException pce) {
            if (OSUtils.IS_ANDROID) {
                logger.warn((Object)"Failed to set feature: http://apache.org/xml/features/disallow-doctype-decl");
            }
            throw pce;
        }
    }
}

