/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.function;

import java.util.function.Function;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.rtcp.RTCPSenderInfoUtils;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.function.TimestampTranslation;
import org.jitsi.utils.ByteArrayBuffer;

public class TimestampPacketTranslation<T extends ByteArrayBuffer>
implements Function<T, T> {
    private final TimestampTranslation tsTranslation;

    public TimestampPacketTranslation(long tsDelta) {
        this.tsTranslation = new TimestampTranslation(tsDelta);
    }

    @Override
    public T apply(T pktIn) {
        if (RTPPacketPredicate.INSTANCE.test((ByteArrayBuffer)pktIn)) {
            long srcTs = RawPacket.getTimestamp(pktIn);
            long dstTs = this.tsTranslation.apply(srcTs);
            if (dstTs != srcTs) {
                RawPacket.setTimestamp(pktIn, dstTs);
            }
            return pktIn;
        }
        if (RTCPPacketPredicate.INSTANCE.test((ByteArrayBuffer)pktIn) && RTCPUtils.getPacketType(pktIn) == 200) {
            long dstTs;
            long srcTs = RTCPSenderInfoUtils.getTimestamp(pktIn);
            if (srcTs != (dstTs = this.tsTranslation.apply(srcTs).longValue())) {
                RTCPSenderInfoUtils.setTimestamp(pktIn, (int)dstTs);
            }
            return pktIn;
        }
        return pktIn;
    }
}

