/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.util.HashSet;
import java.util.Set;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.event.SrtpListener;

public abstract class AbstractSrtpControl<T extends SrtpControl.TransformEngine>
implements SrtpControl {
    private final SrtpControlType srtpControlType;
    private SrtpListener srtpListener;
    protected T transformEngine;
    private final Set<Object> users = new HashSet<Object>();

    protected AbstractSrtpControl(SrtpControlType srtpControlType) {
        if (srtpControlType == null) {
            throw new NullPointerException("srtpControlType");
        }
        this.srtpControlType = srtpControlType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(Object user) {
        Set<Object> set = this.users;
        synchronized (set) {
            if (this.users.remove(user) && this.users.isEmpty()) {
                this.doCleanup();
            }
        }
    }

    protected abstract T createTransformEngine();

    protected void doCleanup() {
        if (this.transformEngine != null) {
            this.transformEngine.cleanup();
            this.transformEngine = null;
        }
    }

    @Override
    public SrtpControlType getSrtpControlType() {
        return this.srtpControlType;
    }

    @Override
    public SrtpListener getSrtpListener() {
        return this.srtpListener;
    }

    public T getTransformEngine() {
        if (this.transformEngine == null) {
            this.transformEngine = this.createTransformEngine();
        }
        return this.transformEngine;
    }

    @Override
    public void setMasterSession(boolean masterSession) {
    }

    @Override
    public void setMultistream(SrtpControl master) {
    }

    @Override
    public void setSrtpListener(SrtpListener srtpListener) {
        this.srtpListener = srtpListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUser(Object user) {
        Set<Object> set = this.users;
        synchronized (set) {
            this.users.add(user);
        }
    }
}

