/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.RetransmissionRequesterDelegate;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.RetransmissionRequester;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.TimeProvider;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging.Logger;

public class RetransmissionRequesterImpl
extends SinglePacketTransformerAdapter
implements TransformEngine,
RetransmissionRequester {
    private static final Logger logger = Logger.getLogger(RetransmissionRequesterImpl.class);
    private boolean enabled = true;
    private boolean closed = false;
    private final RetransmissionRequesterDelegate retransmissionRequesterDelegate;
    private final MediaStream stream;
    private static RecurringRunnableExecutor recurringRunnableExecutor = new RecurringRunnableExecutor(RetransmissionRequesterImpl.class.getSimpleName());

    public RetransmissionRequesterImpl(MediaStream stream) {
        this.stream = stream;
        this.retransmissionRequesterDelegate = new RetransmissionRequesterDelegate(stream, new TimeProvider());
        recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)this.retransmissionRequesterDelegate);
        this.retransmissionRequesterDelegate.setWorkReadyCallback(new Runnable(){

            @Override
            public void run() {
                recurringRunnableExecutor.startOrNotifyThread();
            }
        });
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (this.enabled && !this.closed) {
            int seq;
            Long ssrc;
            MediaFormat format = this.stream.getFormat(pkt.getPayloadType());
            if (format == null) {
                ssrc = null;
                seq = -1;
                logger.warn((Object)("format_not_found,stream_hash=" + this.stream.hashCode()));
            } else if ("rtx".equalsIgnoreCase(format.getEncoding())) {
                MediaStreamTrackReceiver receiver = this.stream.getMediaStreamTrackReceiver();
                RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(pkt);
                if (encoding != null) {
                    ssrc = encoding.getPrimarySSRC();
                    seq = pkt.getOriginalSequenceNumber();
                } else {
                    ssrc = null;
                    seq = -1;
                    logger.warn((Object)("encoding_not_found,stream_hash=" + this.stream.hashCode()));
                }
            } else {
                ssrc = pkt.getSSRCAsLong();
                seq = pkt.getSequenceNumber();
            }
            if (ssrc != null) {
                this.retransmissionRequesterDelegate.packetReceived(ssrc, seq);
            }
        }
        return pkt;
    }

    @Override
    public void close() {
        this.closed = true;
        recurringRunnableExecutor.deRegisterRecurringRunnable((RecurringRunnable)this.retransmissionRequesterDelegate);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public void enable(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public void setSenderSsrc(long ssrc) {
        this.retransmissionRequesterDelegate.setSenderSsrc(ssrc);
    }
}

