/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.TimeProvider;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.logging.Logger;

public class RetransmissionRequesterDelegate
implements RecurringRunnable {
    public static final int MAX_MISSING = 100;
    public static final int MAX_REQUESTS = 10;
    public static final int RE_REQUEST_AFTER_MILLIS = 150;
    public static final long WAKEUP_INTERVAL_MILLIS = 1000L;
    private static final Logger logger = Logger.getLogger(RetransmissionRequesterDelegate.class);
    private final Map<Long, Requester> requesters = new HashMap<Long, Requester>();
    private final MediaStream stream;
    private long senderSsrc = -1L;
    protected final TimeProvider timeProvider;
    protected Runnable workReadyCallback = null;

    public RetransmissionRequesterDelegate(MediaStream stream, TimeProvider timeProvider) {
        this.stream = stream;
        this.timeProvider = timeProvider;
    }

    public void packetReceived(long ssrc, int seqNum) {
        Requester requester = this.getOrCreateRequester(ssrc);
        if (requester.received(seqNum) && this.workReadyCallback != null) {
            this.workReadyCallback.run();
        }
    }

    public long getTimeUntilNextRun() {
        long now = this.timeProvider.currentTimeMillis();
        Requester nextDueRequester = this.getNextDueRequester();
        if (nextDueRequester == null) {
            return 1000L;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.hashCode() + ": Next nack is scheduled for ssrc " + nextDueRequester.ssrc + " at " + Math.max(nextDueRequester.nextRequestAt, 0L) + ".  (current time is " + now + ")"));
        }
        return Math.max(nextDueRequester.nextRequestAt - now, 0L);
    }

    public void setWorkReadyCallback(Runnable workReadyCallback) {
        this.workReadyCallback = workReadyCallback;
    }

    public void run() {
        long now = this.timeProvider.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.hashCode() + " running at " + now));
        }
        List<Requester> dueRequesters = this.getDueRequesters(now);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.hashCode() + " has " + dueRequesters.size() + " due requesters"));
        }
        if (!dueRequesters.isEmpty()) {
            List<NACKPacket> nackPackets = this.createNackPackets(now, dueRequesters);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.hashCode() + " injecting " + nackPackets.size() + " nack packets"));
            }
            if (!nackPackets.isEmpty()) {
                this.injectNackPackets(nackPackets);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requester getOrCreateRequester(long ssrc) {
        Requester requester;
        Map<Long, Requester> map = this.requesters;
        synchronized (map) {
            requester = this.requesters.get(ssrc);
            if (requester == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new Requester for SSRC " + ssrc));
                }
                requester = new Requester(ssrc);
                this.requesters.put(ssrc, requester);
            }
        }
        return requester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requester getNextDueRequester() {
        Requester nextDueRequester = null;
        Map<Long, Requester> map = this.requesters;
        synchronized (map) {
            for (Requester requester : this.requesters.values()) {
                if (requester.nextRequestAt == -1L || nextDueRequester != null && requester.nextRequestAt >= nextDueRequester.nextRequestAt) continue;
                nextDueRequester = requester;
            }
        }
        return nextDueRequester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Requester> getDueRequesters(long currentTime) {
        ArrayList<Requester> dueRequesters = new ArrayList<Requester>();
        Map<Long, Requester> map = this.requesters;
        synchronized (map) {
            for (Requester requester : this.requesters.values()) {
                if (!requester.isDue(currentTime)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this.hashCode() + " requester for ssrc " + requester.ssrc + " has work due at " + requester.nextRequestAt + " (now = " + currentTime + ") and is missing packets: " + requester.getMissingSeqNums()));
                }
                dueRequesters.add(requester);
            }
        }
        return dueRequesters;
    }

    private void injectNackPackets(List<NACKPacket> nackPackets) {
        for (NACKPacket nackPacket : nackPackets) {
            try {
                RawPacket packet;
                try {
                    packet = nackPacket.toRawPacket();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to create a NACK packet: " + ioe));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Sending a NACK: " + (Object)((Object)nackPacket)));
                }
                this.stream.injectPacket(packet, false, null);
            }
            catch (TransmissionFailedException e) {
                logger.warn((Object)"Failed to inject packet in MediaStream: ", e.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NACKPacket> createNackPackets(long now, List<Requester> dueRequesters) {
        HashMap<Long, Set> packetsToRequest = new HashMap<Long, Set>();
        Iterator<Requester> iterator = dueRequesters.iterator();
        while (iterator.hasNext()) {
            Requester dueRequester;
            Requester requester = dueRequester = iterator.next();
            synchronized (requester) {
                Set missingPackets = dueRequester.getMissingSeqNums();
                if (!missingPackets.isEmpty()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this.hashCode() + " Sending nack with packets " + missingPackets + " for ssrc " + dueRequester.ssrc));
                    }
                    packetsToRequest.put(dueRequester.ssrc, missingPackets);
                    dueRequester.notifyNackCreated(now, missingPackets);
                }
            }
        }
        ArrayList<NACKPacket> nackPackets = new ArrayList<NACKPacket>();
        for (Map.Entry entry : packetsToRequest.entrySet()) {
            long sourceSsrc = (Long)entry.getKey();
            Set missingPackets = (Set)entry.getValue();
            NACKPacket nack = new NACKPacket(this.senderSsrc, sourceSsrc, missingPackets);
            nackPackets.add(nack);
        }
        return nackPackets;
    }

    public void setSenderSsrc(long ssrc) {
        this.senderSsrc = ssrc;
    }

    private static class Request {
        final int seq;
        long firstRequestSentAt = -1L;
        int timesRequested = 0;

        Request(int seq) {
            this.seq = seq;
        }
    }

    private class Requester {
        private final long ssrc;
        private int lastReceivedSeq = -1;
        private long nextRequestAt = -1L;
        private final Map<Integer, Request> requests = new HashMap<Integer, Request>();

        private Requester(long ssrc) {
            this.ssrc = ssrc;
        }

        public boolean isDue(long currentTime) {
            return this.nextRequestAt != -1L && this.nextRequestAt <= currentTime;
        }

        private synchronized boolean received(int seq) {
            if (this.lastReceivedSeq == -1) {
                this.lastReceivedSeq = seq;
                return false;
            }
            int diff = RTPUtils.getSequenceNumberDelta(seq, this.lastReceivedSeq);
            if (diff <= 0) {
                long rtt;
                Request r = this.requests.remove(seq);
                if (this.requests.isEmpty()) {
                    this.nextRequestAt = -1L;
                }
                if (r != null && logger.isDebugEnabled() && (rtt = RetransmissionRequesterDelegate.this.stream.getMediaStreamStats().getSendStats().getRtt()) > 0L) {
                    long firstRequestSentAt = r.firstRequestSentAt;
                    long delta = firstRequestSentAt > 0L ? RetransmissionRequesterDelegate.this.timeProvider.currentTimeMillis() - r.firstRequestSentAt : 0L;
                    logger.debug(Logger.Category.STATISTICS, "retr_received,stream=" + RetransmissionRequesterDelegate.this.stream.hashCode() + " delay=" + delta + ",rtt=" + rtt);
                }
            } else if (diff == 1) {
                this.lastReceivedSeq = seq;
            } else {
                if (diff <= 100) {
                    int missing = (this.lastReceivedSeq + 1) % 65536;
                    while (missing != seq) {
                        Request request = new Request(missing);
                        this.requests.put(missing, request);
                        missing = (missing + 1) % 65536;
                    }
                    this.lastReceivedSeq = seq;
                    this.nextRequestAt = 0L;
                    return true;
                }
                this.lastReceivedSeq = seq;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resetting retransmission requester state. SSRC: " + this.ssrc + ", last received: " + this.lastReceivedSeq + ", current: " + seq + ". Removing " + this.requests.size() + " unsatisfied requests."));
                }
                this.requests.clear();
                this.nextRequestAt = -1L;
            }
            return false;
        }

        @NotNull
        private synchronized Set<Integer> getMissingSeqNums() {
            return new HashSet<Integer>(this.requests.keySet());
        }

        public synchronized void notifyNackCreated(long time, Collection<Integer> sequenceNumbers) {
            for (Integer seqNum : sequenceNumbers) {
                Request request = this.requests.get(seqNum);
                ++request.timesRequested;
                if (request.timesRequested == 10) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Generated the last NACK for SSRC=" + this.ssrc + " seq=" + request.seq + ". Time since the first request: " + (time - request.firstRequestSentAt)));
                    }
                    this.requests.remove(seqNum);
                    continue;
                }
                if (request.timesRequested != 1) continue;
                request.firstRequestSentAt = time;
            }
            this.nextRequestAt = this.requests.size() > 0 ? time + 150L : -1L;
        }
    }
}

