/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.ArrayUtils;

public class MediaStreamTrackReceiver
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final MediaStreamTrackDesc[] NO_TRACKS = new MediaStreamTrackDesc[0];
    private final MediaStreamImpl stream;
    private MediaStreamTrackDesc[] tracks = NO_TRACKS;

    public MediaStreamTrackReceiver(MediaStreamImpl stream) {
        super(RTPPacketPredicate.INSTANCE);
        this.stream = stream;
    }

    public RTPEncodingDesc findRTPEncodingDesc(RawPacket pkt) {
        Object[] localTracks = this.tracks;
        if (ArrayUtils.isNullOrEmpty((Object[])localTracks)) {
            return null;
        }
        for (Object track : localTracks) {
            RTPEncodingDesc encoding = ((MediaStreamTrackDesc)track).findRTPEncodingDesc(pkt);
            if (encoding == null) continue;
            return encoding;
        }
        return null;
    }

    public RTPEncodingDesc findRTPEncodingDesc(long ssrc) {
        Object[] localTracks = this.tracks;
        if (ArrayUtils.isNullOrEmpty((Object[])localTracks)) {
            return null;
        }
        for (Object track : localTracks) {
            RTPEncodingDesc encoding = ((MediaStreamTrackDesc)track).findRTPEncodingDesc(ssrc);
            if (encoding == null) continue;
            return encoding;
        }
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    public MediaStreamTrackDesc[] getMediaStreamTracks() {
        return this.tracks == null ? NO_TRACKS : this.tracks;
    }

    public boolean setMediaStreamTracks(MediaStreamTrackDesc[] newTracks) {
        MediaStreamTrackDesc[] oldTracks;
        int oldTracksLen;
        if (newTracks == null) {
            newTracks = NO_TRACKS;
        }
        int n = oldTracksLen = (oldTracks = this.tracks) == null ? 0 : oldTracks.length;
        if (oldTracksLen == 0 || newTracks.length == 0) {
            this.tracks = newTracks;
            return oldTracksLen != newTracks.length;
        }
        int cntMatched = 0;
        MediaStreamTrackDesc[] mergedTracks = new MediaStreamTrackDesc[newTracks.length];
        for (int i = 0; i < newTracks.length; ++i) {
            RTPEncodingDesc newEncoding = newTracks[i].getRTPEncodings()[0];
            for (int j = 0; j < oldTracks.length; ++j) {
                if (oldTracks[j] == null || !oldTracks[j].matches(newEncoding.getPrimarySSRC())) continue;
                mergedTracks[i] = oldTracks[j];
                ++cntMatched;
                break;
            }
            if (mergedTracks[i] != null) continue;
            mergedTracks[i] = newTracks[i];
        }
        this.tracks = mergedTracks;
        return oldTracksLen != newTracks.length || cntMatched != oldTracks.length;
    }

    public MediaStreamImpl getStream() {
        return this.stream;
    }

    public MediaStreamTrackDesc findMediaStreamTrackDesc(long ssrc) {
        Object[] localTracks = this.tracks;
        if (ArrayUtils.isNullOrEmpty((Object[])localTracks)) {
            return null;
        }
        for (Object track : localTracks) {
            if (!((MediaStreamTrackDesc)track).matches(ssrc)) continue;
            return track;
        }
        return null;
    }
}

