/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;

public class MediaPresenceExtension
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://estos.de/ns/mjs";
    public static final String ELEMENT_NAME = "media";

    public MediaPresenceExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public static void registerExtensions() {
        ProviderManager.addExtensionProvider((String)ELEMENT_NAME, (String)NAMESPACE, new DefaultPacketExtensionProvider<MediaPresenceExtension>(MediaPresenceExtension.class));
        ProviderManager.addExtensionProvider((String)"source", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<Source>(Source.class));
    }

    public void addSource(String type, String ssrc, String direction) {
        Source s = new Source();
        s.setMediaType(type);
        s.setSSRC(ssrc);
        s.setDirection(direction);
        this.addChildExtension(s);
    }

    public static class Source
    extends AbstractPacketExtension {
        public static final String ELEMENT_NAME = "source";
        public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:ssma:0";
        public static final String MEDIA_TYPE_ATTR_NAME = "type";
        public static final String SOURCE_ATTR_NAME = "ssrc";
        public static final String DIRECTION_ATTR_NAME = "direction";

        public Source() {
            super(NAMESPACE, ELEMENT_NAME);
            this.setDirection("sendrecv");
        }

        public String getDirection() {
            return this.getAttributeAsString(DIRECTION_ATTR_NAME);
        }

        public String getSSRC() {
            return this.getAttributeAsString(SOURCE_ATTR_NAME);
        }

        public void setMediaType(String mediaType) {
            this.setAttribute(MEDIA_TYPE_ATTR_NAME, mediaType);
        }

        public void setDirection(String direction) {
            this.setAttribute(DIRECTION_ATTR_NAME, direction);
        }

        public void setSSRC(String ssrc) {
            this.setAttribute(SOURCE_ATTR_NAME, ssrc);
        }

        public String getMediaType() {
            return this.getAttributeAsString(MEDIA_TYPE_ATTR_NAME);
        }
    }
}

