/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.condesc.CallIdExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CoinPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CryptoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.EncryptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.GroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.InputEvtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.MuteSessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RawUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ReasonProvider;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SctpMapExtensionProvider;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoType;
import org.jitsi.xmpp.extensions.jingle.TransferPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferredPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ZrtpHashPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.BundlePacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;

public class JingleIQProvider
extends IQProvider<JingleIQ> {
    public JingleIQProvider() {
        ProviderManager.addExtensionProvider((String)"description", (String)"urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<RtpDescriptionPacketExtension>(RtpDescriptionPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"payload-type", (String)"urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"parameter", (String)"urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtp-hdrext", (String)"urn:xmpp:jingle:apps:rtp:rtp-hdrext:0", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"sctpmap", (String)"urn:xmpp:jingle:transports:dtls-sctp:1", (Object)((Object)new SctpMapExtensionProvider()));
        ProviderManager.addExtensionProvider((String)"encryption", (String)"urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<EncryptionPacketExtension>(EncryptionPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"zrtp-hash", (String)"urn:xmpp:jingle:apps:rtp:zrtp:1", new DefaultPacketExtensionProvider<ZrtpHashPacketExtension>(ZrtpHashPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"crypto", (String)"urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<CryptoPacketExtension>(CryptoPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"bundle", (String)"http://estos.de/ns/bundle", new DefaultPacketExtensionProvider<BundlePacketExtension>(BundlePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"group", (String)"urn:xmpp:jingle:apps:grouping:0", new DefaultPacketExtensionProvider<GroupPacketExtension>(GroupPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"transport", (String)"urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceUdpTransportPacketExtension>(IceUdpTransportPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"transport", (String)"urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<RawUdpTransportPacketExtension>(RawUdpTransportPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"candidate", (String)"urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"candidate", (String)"urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"remote-candidate", (String)"urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RemoteCandidatePacketExtension>(RemoteCandidatePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"inputevt", (String)"http://jitsi.org/protocol/inputevt", new DefaultPacketExtensionProvider<InputEvtPacketExtension>(InputEvtPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"conference-info", (String)"urn:xmpp:coin:1", new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"fingerprint", (String)"urn:xmpp:jingle:apps:dtls:0", new DefaultPacketExtensionProvider<DtlsFingerprintPacketExtension>(DtlsFingerprintPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"transfer", (String)"urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"transferred", (String)"urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferredPacketExtension>(TransferredPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"callid", (String)"http://jitsi.org/protocol/condesc", new DefaultPacketExtensionProvider<CallIdExtension>(CallIdExtension.class));
        ProviderManager.addExtensionProvider((String)"rtcp-fb", (String)"urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtcp-mux", (String)"urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RtcpmuxPacketExtension>(RtcpmuxPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"web-socket", (String)"http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<WebSocketPacketExtension>(WebSocketPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"ssrc-info", (String)"http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
    }

    public JingleIQ parse(XmlPullParser parser, int depth) throws Exception {
        JingleAction action = JingleAction.parseString(parser.getAttributeValue("", "action"));
        String initiator = parser.getAttributeValue("", "initiator");
        String responder = parser.getAttributeValue("", "responder");
        String sid = parser.getAttributeValue("", "sid");
        JingleIQ jingleIQ = new JingleIQ(action, sid);
        if (initiator != null) {
            Jid initiatorJid = JidCreate.from((String)initiator);
            jingleIQ.setInitiator(initiatorJid);
        }
        if (responder != null) {
            Jid responderJid = JidCreate.from((String)responder);
            jingleIQ.setResponder(responderJid);
        }
        boolean done = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> contentProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        ReasonProvider reasonProvider = new ReasonProvider();
        DefaultPacketExtensionProvider<TransferPacketExtension> transferProvider = new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class);
        DefaultPacketExtensionProvider<CoinPacketExtension> coinProvider = new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class);
        DefaultPacketExtensionProvider<CallIdExtension> callidProvider = new DefaultPacketExtensionProvider<CallIdExtension>(CallIdExtension.class);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("content")) {
                    ContentPacketExtension content = (ContentPacketExtension)contentProvider.parse(parser);
                    jingleIQ.addContent(content);
                } else if (elementName.equals("reason")) {
                    ReasonPacketExtension reason = (ReasonPacketExtension)reasonProvider.parse(parser);
                    jingleIQ.setReason(reason);
                } else if (elementName.equals("transfer") && namespace.equals("urn:xmpp:jingle:transfer:0")) {
                    jingleIQ.addExtension((ExtensionElement)transferProvider.parse(parser));
                } else if (elementName.equals("conference-info")) {
                    jingleIQ.addExtension((ExtensionElement)coinProvider.parse(parser));
                } else if (elementName.equals("callid")) {
                    jingleIQ.addExtension((ExtensionElement)callidProvider.parse(parser));
                } else if (elementName.equals("group")) {
                    jingleIQ.addExtension(GroupPacketExtension.parseExtension(parser));
                } else if (namespace.equals("urn:xmpp:jingle:apps:rtp:info:1")) {
                    SessionInfoType type = SessionInfoType.valueOf(elementName);
                    if (type == SessionInfoType.mute || type == SessionInfoType.unmute) {
                        String name = parser.getAttributeValue("", "name");
                        jingleIQ.setSessionInfo(new MuteSessionInfoPacketExtension(type == SessionInfoType.mute, name));
                    } else {
                        jingleIQ.setSessionInfo(new SessionInfoPacketExtension(type));
                    }
                } else {
                    PacketParserUtils.addExtensionElement((Stanza)jingleIQ, (XmlPullParser)parser);
                }
            }
            if (eventType != 3 || !parser.getName().equals("jingle")) continue;
            done = true;
        }
        return jingleIQ;
    }
}

