/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class LogContext {
    public static LogContext EMPTY = new LogContext(Collections.emptyMap());
    public static String CONTEXT_START_TOKEN = "[";
    public static String CONTEXT_END_TOKEN = "]";
    protected final Map<String, String> context;
    protected final String formattedContext;

    public LogContext(Map<String, String> context) {
        this.context = context;
        this.formattedContext = this.formatContext(context);
    }

    protected String formatContext(Map<String, String> context) {
        if (context.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CONTEXT_START_TOKEN);
        String data = context.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" "));
        sb.append(data);
        sb.append(CONTEXT_END_TOKEN);
        return sb.toString();
    }

    public LogContext createSubContext(Map<String, String> childContextData) {
        HashMap<String, String> resultingContext = new HashMap<String, String>(this.context);
        resultingContext.putAll(childContextData);
        return new LogContext(resultingContext);
    }

    public String toString() {
        return this.formattedContext;
    }
}

