/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiagnosticContext
extends ConcurrentHashMap<String, Object> {
    Clock clock;

    public DiagnosticContext() {
        this.clock = Clock.systemUTC();
    }

    public DiagnosticContext(Clock clock) {
        this.clock = clock;
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName) {
        return this.makeTimeSeriesPoint(timeSeriesName, this.clock.instant());
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, long tsMs) {
        return new TimeSeriesPoint(this).addField("series", timeSeriesName).addField("time", tsMs);
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, Instant ts) {
        Double tsMs = (double)ts.getEpochSecond() * 1000.0 + (double)ts.getNano() * 1.0E-6;
        return new TimeSeriesPoint(this).addField("series", timeSeriesName).addField("time", tsMs);
    }

    public static class TimeSeriesPoint
    extends HashMap<String, Object> {
        public TimeSeriesPoint(Map<String, Object> m) {
            super(m);
        }

        public TimeSeriesPoint addField(String key, Object value) {
            this.put(key, value);
            return this;
        }
    }
}

