/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.debugger;

import java.lang.reflect.Field;
import java.net.Socket;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;

public class SmackPacketDebugger {
    private XMPPConnection connection = null;
    private byte[] localAddress;
    private byte[] remoteAddress;
    private PacketLoggingService packetLogging = null;
    public final Inbound inbound = new Inbound();
    public final Outbound outbound = new Outbound();

    public SmackPacketDebugger() {
        this.packetLogging = JabberActivator.getPacketLogging();
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    private Message cloneAnonyMessage(Stanza packet) {
        Message oldMsg = (Message)packet;
        if (oldMsg.getBody() == null && oldMsg.getBodies().size() == 0) {
            return oldMsg;
        }
        Message newMsg = new Message();
        newMsg.setStanzaId(packet.getStanzaId());
        newMsg.setTo(packet.getTo());
        newMsg.setFrom(packet.getFrom());
        for (ExtensionElement pex : packet.getExtensions()) {
            newMsg.addExtension(pex);
        }
        newMsg.setError(packet.getError());
        newMsg.setType(oldMsg.getType());
        newMsg.setThread(oldMsg.getThread());
        newMsg.setLanguage(oldMsg.getLanguage());
        for (Message.Subject sub : oldMsg.getSubjects()) {
            if (sub.getSubject() != null) {
                newMsg.addSubject(sub.getLanguage(), new String(new char[sub.getSubject().length()]).replace('\u0000', '.'));
                continue;
            }
            newMsg.addSubject(sub.getLanguage(), sub.getSubject());
        }
        for (Message.Body b : oldMsg.getBodies()) {
            if (b.getMessage() != null) {
                newMsg.addBody(b.getLanguage(), new String(new char[b.getMessage().length()]).replace('\u0000', '.'));
                continue;
            }
            newMsg.addSubject(b.getLanguage(), b.getMessage());
        }
        return newMsg;
    }

    private Socket getSocket() {
        if (this.connection == null) {
            return null;
        }
        try {
            Field socket = this.connection.getClass().getField("socket");
            socket.setAccessible(true);
            return (Socket)socket.get(this.connection);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    static /* synthetic */ byte[] access$202(SmackPacketDebugger x0, byte[] x1) {
        x0.remoteAddress = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(SmackPacketDebugger x0, byte[] x1) {
        x0.localAddress = x1;
        return x1;
    }

    public class Inbound
    implements StanzaListener {
        public void processStanza(Stanza packet) {
            try {
                if (SmackPacketDebugger.this.packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.JABBER) && packet != null) {
                    int port;
                    int localPort = 0;
                    int remotePort = 5222;
                    Socket socket = SmackPacketDebugger.this.getSocket();
                    if (socket != null) {
                        localPort = socket.getLocalPort();
                    }
                    if (SmackPacketDebugger.this.connection != null && (port = SmackPacketDebugger.this.connection.getPort()) > 0) {
                        remotePort = port;
                    }
                    byte[] packetBytes = packet instanceof Message ? SmackPacketDebugger.this.cloneAnonyMessage(packet).toXML().toString().getBytes("UTF-8") : packet.toXML().toString().getBytes("UTF-8");
                    SmackPacketDebugger.this.packetLogging.logPacket(PacketLoggingService.ProtocolName.JABBER, SmackPacketDebugger.this.remoteAddress, remotePort, SmackPacketDebugger.this.localAddress, localPort, PacketLoggingService.TransportName.TCP, false, packetBytes);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class Outbound
    implements StanzaListener {
        public void processStanza(Stanza packet) {
            try {
                if (SmackPacketDebugger.this.packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.JABBER) && packet != null) {
                    int port;
                    Socket socket = SmackPacketDebugger.this.getSocket();
                    if (SmackPacketDebugger.this.remoteAddress == null) {
                        if (socket != null) {
                            SmackPacketDebugger.access$202(SmackPacketDebugger.this, socket.getInetAddress().getAddress());
                            SmackPacketDebugger.access$302(SmackPacketDebugger.this, socket.getLocalAddress().getAddress());
                        } else {
                            SmackPacketDebugger.access$202(SmackPacketDebugger.this, new byte[4]);
                            SmackPacketDebugger.access$302(SmackPacketDebugger.this, new byte[4]);
                        }
                    }
                    int localPort = 0;
                    int remotePort = 5222;
                    if (socket != null) {
                        localPort = socket.getLocalPort();
                    }
                    if (SmackPacketDebugger.this.connection != null && (port = SmackPacketDebugger.this.connection.getPort()) > 0) {
                        remotePort = port;
                    }
                    byte[] packetBytes = packet instanceof Message ? SmackPacketDebugger.this.cloneAnonyMessage(packet).toXML().toString().getBytes("UTF-8") : packet.toXML().toString().getBytes("UTF-8");
                    SmackPacketDebugger.this.packetLogging.logPacket(PacketLoggingService.ProtocolName.JABBER, SmackPacketDebugger.this.localAddress, localPort, SmackPacketDebugger.this.remoteAddress, remotePort, PacketLoggingService.TransportName.TCP, true, packetBytes);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

