/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.caps;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.java.sip.communicator.impl.protocol.jabber.caps.CapsVerListener;
import net.java.sip.communicator.impl.protocol.jabber.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.osgi.framework.BundleContext;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EntityCapsManager {
    private static final Logger logger = Logger.getLogger(EntityCapsManager.class);
    private static BundleContext bundleContext;
    private static ConfigurationService configService;
    private static final String CAPS_PROPERTY_NAME_PREFIX = "net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager.CAPS.";
    private static final UserCapsNodeListener[] NO_USER_CAPS_NODE_LISTENERS;
    private static String entityNode;
    private static final Map<Caps, DiscoverInfo> caps2discoverInfo;
    private final Map<Jid, Caps> userCaps = new ConcurrentHashMap<Jid, Caps>();
    private final Set<CapsVerListener> capsVerListeners = new CopyOnWriteArraySet<CapsVerListener>();
    private String currentCapsVersion = null;
    private final List<UserCapsNodeListener> userCapsNodeListeners = new LinkedList<UserCapsNodeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiscoverInfoByCaps(Caps caps, DiscoverInfo info) {
        EntityCapsManager.cleanupDiscoverInfo(info);
        info.setNode(caps.getNodeVer());
        Map<Caps, DiscoverInfo> map = caps2discoverInfo;
        synchronized (map) {
            String xml;
            DiscoverInfo oldInfo = caps2discoverInfo.put(caps, info);
            if (!(oldInfo != null && oldInfo.equals(info) || (xml = info.getChildElementXML().toString()) == null || xml.length() == 0)) {
                EntityCapsManager.getConfigService().setProperty(EntityCapsManager.getCapsPropertyName(caps), (Object)xml);
            }
        }
    }

    private static String getCapsPropertyName(Caps caps) {
        return CAPS_PROPERTY_NAME_PREFIX + caps.node + '#' + caps.hash + '#' + caps.ver;
    }

    private static ConfigurationService getConfigService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            configService = null;
        }
        EntityCapsManager.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserCapsNode(Jid user, String node, String hash, String ver, boolean online) {
        if (user != null && node != null && hash != null && ver != null) {
            UserCapsNodeListener[] listeners;
            Caps caps = this.userCaps.get(user);
            if (caps != null && caps.node.equals(node) && caps.hash.equals(hash) && caps.ver.equals(ver)) {
                return;
            }
            caps = new Caps(node, hash, ver);
            this.userCaps.put(user, caps);
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                for (UserCapsNodeListener listener : listeners) {
                    listener.userCapsNodeAdded(user, this.getFullJidsByBareJid((Jid)user.asBareJid()), nodeVer, online);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<UserCapsNodeListener> list = this.userCapsNodeListeners;
        synchronized (list) {
            if (!this.userCapsNodeListeners.contains(listener)) {
                this.userCapsNodeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactCapsNode(Contact contact) {
        Caps caps = null;
        Jid lastRemovedJid = null;
        BareJid bareJid = null;
        try {
            bareJid = JidCreate.bareFrom((String)contact.getAddress());
        }
        catch (XmppStringprepException e) {
            logger.error((Object)("Contact address " + contact.getAddress() + " is not a valid JID"), (Throwable)e);
        }
        Iterator<Jid> iter = this.userCaps.keySet().iterator();
        while (iter.hasNext()) {
            Jid jid = iter.next();
            if (!jid.equals(contact.getAddress())) continue;
            caps = this.userCaps.get(jid);
            lastRemovedJid = jid;
            iter.remove();
        }
        if (caps != null) {
            UserCapsNodeListener[] listeners;
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                for (UserCapsNodeListener listener : listeners) {
                    listener.userCapsNodeRemoved(lastRemovedJid, this.getFullJidsByBareJid((Jid)bareJid), nodeVer, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserCapsNode(Jid user) {
        if (user == null) {
            return;
        }
        Caps caps = this.userCaps.remove(user);
        BareJid bareJid = user.asBareJid();
        if (caps != null) {
            UserCapsNodeListener[] listeners;
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                for (UserCapsNodeListener listener : listeners) {
                    listener.userCapsNodeRemoved(user, this.getFullJidsByBareJid((Jid)bareJid), nodeVer, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener != null) {
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                this.userCapsNodeListeners.remove(listener);
            }
        }
    }

    public Caps getCapsByUser(Jid user) {
        return this.userCaps.get(user);
    }

    public List<Jid> getFullJidsByBareJid(Jid bareJid) {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        for (Jid jid : this.userCaps.keySet()) {
            if (!bareJid.equals((CharSequence)jid.asBareJid())) continue;
            jids.add(jid);
        }
        return jids;
    }

    public DiscoverInfo getDiscoverInfoByUser(Jid user) {
        Caps caps = this.userCaps.get(user);
        return caps == null ? null : EntityCapsManager.getDiscoverInfoByCaps(caps);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getNode() {
        return entityNode;
    }

    public void setNode(String node) {
        entityNode = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscoverInfo getDiscoverInfoByCaps(Caps caps) {
        Map<Caps, DiscoverInfo> map = caps2discoverInfo;
        synchronized (map) {
            IQProvider discoverInfoProvider;
            String capsPropertyName;
            ConfigurationService configurationService;
            String xml;
            DiscoverInfo discoverInfo = caps2discoverInfo.get(caps);
            if (discoverInfo == null && (xml = (configurationService = EntityCapsManager.getConfigService()).getString(capsPropertyName = EntityCapsManager.getCapsPropertyName(caps))) != null && xml.length() != 0 && (discoverInfoProvider = ProviderManager.getIQProvider((String)"query", (String)"http://jabber.org/protocol/disco#info")) != null) {
                MXParser parser = new MXParser();
                try {
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new StringReader(xml));
                    parser.next();
                }
                catch (XmlPullParserException xppex) {
                    parser = null;
                }
                catch (IOException ioex) {
                    parser = null;
                }
                if (parser != null) {
                    try {
                        discoverInfo = (DiscoverInfo)discoverInfoProvider.parse((XmlPullParser)parser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (discoverInfo != null) {
                        if (caps.isValid(discoverInfo)) {
                            caps2discoverInfo.put(caps, discoverInfo);
                        } else {
                            logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
                            configurationService.removeProperty(capsPropertyName);
                        }
                    }
                }
            }
            return discoverInfo;
        }
    }

    private static void cleanupDiscoverInfo(DiscoverInfo info) {
        info.setFrom((Jid)null);
        info.setTo((Jid)null);
        info.setStanzaId(null);
    }

    public void addPacketListener(XMPPConnection connection) {
        StanzaTypeFilter filter = new StanzaTypeFilter(Presence.class);
        connection.addPacketListener((StanzaListener)new CapsPacketListener(), (StanzaFilter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapsVerListener(CapsVerListener listener) {
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            if (this.capsVerListeners.contains(listener)) {
                return;
            }
            this.capsVerListeners.add(listener);
            if (this.currentCapsVersion != null) {
                listener.capsVerUpdated(this.currentCapsVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCapsVerListener(CapsVerListener listener) {
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            this.capsVerListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCapsVerChanged() {
        ArrayList<CapsVerListener> listenersCopy = null;
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<CapsVerListener>(this.capsVerListeners);
        }
        for (CapsVerListener listener : listenersCopy) {
            listener.capsVerUpdated(this.currentCapsVersion);
        }
    }

    private static String capsToHash(String hashAlgorithm, String capsString) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            byte[] digest = md.digest(capsString.getBytes());
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)("Unsupported XEP-0115: Entity Capabilities hash algorithm: " + hashAlgorithm));
            return null;
        }
    }

    private static void formFieldValuesToCaps(Iterator<String> ffValuesIter, StringBuilder capsBldr) {
        TreeSet<String> fvs = new TreeSet<String>();
        while (ffValuesIter.hasNext()) {
            fvs.add(ffValuesIter.next());
        }
        for (String fv : fvs) {
            capsBldr.append(fv).append('<');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static String calculateEntityCapsString(DiscoverInfo discoverInfo) {
        StringBuilder bldr = new StringBuilder();
        Iterator identities = discoverInfo.getIdentities().iterator();
        TreeSet<DiscoverInfo.Identity> is = new TreeSet<DiscoverInfo.Identity>(new Comparator<DiscoverInfo.Identity>(){

            @Override
            public int compare(DiscoverInfo.Identity i1, DiscoverInfo.Identity i2) {
                int category = i1.getCategory().compareTo(i2.getCategory());
                if (category != 0) {
                    return category;
                }
                int type = i1.getType().compareTo(i2.getType());
                if (type != 0) {
                    return type;
                }
                return type;
            }
        });
        if (identities != null) {
            while (identities.hasNext()) {
                is.add((DiscoverInfo.Identity)identities.next());
            }
        }
        for (DiscoverInfo.Identity identity : is) {
            bldr.append(identity.getCategory()).append('/').append(identity.getType()).append("//").append(identity.getName()).append('<');
        }
        List features = discoverInfo.getFeatures();
        TreeSet<String> fs = new TreeSet<String>();
        if (features != null) {
            for (DiscoverInfo.Feature feature : features) {
                fs.add(feature.getVar());
            }
        }
        for (String string : fs) {
            bldr.append(string).append('<');
        }
        DataForm extendedInfo = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        if (extendedInfo != null) {
            DataForm dataForm = extendedInfo;
            synchronized (dataForm) {
                void var5_11;
                TreeSet<FormField> fs2 = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField f1, FormField f2) {
                        return f1.getVariable().compareTo(f2.getVariable());
                    }
                });
                Object var5_10 = null;
                for (FormField f : extendedInfo.getFields()) {
                    if (!f.getVariable().equals("FORM_TYPE")) {
                        fs2.add(f);
                        continue;
                    }
                    FormField formField = f;
                }
                if (var5_11 != null) {
                    EntityCapsManager.formFieldValuesToCaps(var5_11.getValues().iterator(), bldr);
                }
                for (FormField f : fs2) {
                    bldr.append(f.getVariable()).append('<');
                    EntityCapsManager.formFieldValuesToCaps(f.getValues().iterator(), bldr);
                }
            }
        }
        return bldr.toString();
    }

    public void calculateEntityCapsVersion(DiscoverInfo discoverInfo) {
        this.setCurrentCapsVersion(discoverInfo, EntityCapsManager.capsToHash("sha-1", EntityCapsManager.calculateEntityCapsString(discoverInfo)));
    }

    public void setCurrentCapsVersion(DiscoverInfo discoverInfo, String capsVersion) {
        Caps caps = new Caps(this.getNode(), "sha-1", capsVersion);
        discoverInfo.setNode(caps.getNodeVer());
        if (!caps.isValid(discoverInfo)) {
            throw new IllegalArgumentException("The specified discoverInfo must be valid with respect to the specified capsVersion");
        }
        this.currentCapsVersion = capsVersion;
        EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
        this.fireCapsVerChanged();
    }

    static {
        NO_USER_CAPS_NODE_LISTENERS = new UserCapsNodeListener[0];
        entityNode = OSUtils.IS_ANDROID ? "http://android.jitsi.org" : "http://jitsi.org";
        caps2discoverInfo = new ConcurrentHashMap<Caps, DiscoverInfo>();
    }

    public static class Caps {
        public final String hash;
        public final String node;
        private final String nodeVer;
        public final String ver;

        public Caps(String node, String hash, String ver) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            if (hash == null) {
                throw new NullPointerException("hash");
            }
            if (ver == null) {
                throw new NullPointerException("ver");
            }
            this.node = node;
            this.hash = hash;
            this.ver = ver;
            this.nodeVer = this.node + '#' + this.ver;
        }

        public final String getNodeVer() {
            return this.nodeVer;
        }

        public boolean isValid(DiscoverInfo discoverInfo) {
            if (discoverInfo != null) {
                if (discoverInfo.getNode() == null) {
                    discoverInfo.setNode(this.getNodeVer());
                }
                if (this.getNodeVer().equals(discoverInfo.getNode()) && !this.hash.equals("") && this.ver.equals(EntityCapsManager.capsToHash(this.hash, EntityCapsManager.calculateEntityCapsString(discoverInfo)))) {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Caps caps = (Caps)o;
            if (!this.hash.equals(caps.hash)) {
                return false;
            }
            if (!this.node.equals(caps.node)) {
                return false;
            }
            return this.ver.equals(caps.ver);
        }

        public int hashCode() {
            int result = this.hash.hashCode();
            result = 31 * result + this.node.hashCode();
            result = 31 * result + this.ver.hashCode();
            return result;
        }
    }

    private class CapsPacketListener
    implements StanzaListener {
        private CapsPacketListener() {
        }

        public void processStanza(Stanza packet) {
            boolean online = packet instanceof Presence && ((Presence)packet).isAvailable();
            CapsExtension ext = (CapsExtension)packet.getExtension("c", "http://jabber.org/protocol/caps");
            if (ext != null && online) {
                String hash = ext.getHash();
                if (hash == null) {
                    hash = "";
                }
                EntityCapsManager.this.addUserCapsNode(packet.getFrom(), ext.getNode(), hash, ext.getVer(), online);
            } else if (!online) {
                EntityCapsManager.this.removeUserCapsNode(packet.getFrom());
            }
        }
    }
}

