/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetContactCapabilitiesJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.caps.EntityCapsManager;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jxmpp.jid.Jid;

public class ScServiceDiscoveryManager
implements StanzaListener,
NodeInformationProvider {
    private static final Logger logger = Logger.getLogger(ScServiceDiscoveryManager.class);
    private final boolean cacheNonCaps;
    private final Map<Jid, DiscoverInfo> nonCapsCache = new ConcurrentHashMap<Jid, DiscoverInfo>();
    private final EntityCapsManager capsManager;
    private final ServiceDiscoveryManager discoveryManager;
    private final ProtocolProviderService parentProvider;
    private XMPPConnection connection;
    private final List<String> features;
    private final List<String> unmodifiableFeatures;
    private final List<DiscoverInfo.Identity> identities;
    private final List<String> extCapabilities = new ArrayList<String>();
    private DiscoveryInfoRetriever retriever = new DiscoveryInfoRetriever();

    public ScServiceDiscoveryManager(ProtocolProviderService parentProvider, XMPPConnection connection, String[] featuresToRemove, String[] featuresToAdd, boolean cacheNonCaps) {
        this.parentProvider = parentProvider;
        this.connection = connection;
        this.discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        this.features = new ArrayList<String>();
        this.unmodifiableFeatures = Collections.unmodifiableList(this.features);
        this.identities = new ArrayList<DiscoverInfo.Identity>();
        this.cacheNonCaps = cacheNonCaps;
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", this.discoveryManager.getIdentityName(), this.discoveryManager.getIdentityType());
        this.identities.add(identity);
        this.discoveryManager.addFeature("http://jabber.org/protocol/caps");
        if (featuresToRemove != null) {
            for (String featureToRemove : featuresToRemove) {
                this.discoveryManager.removeFeature(featureToRemove);
            }
        }
        if (featuresToAdd != null) {
            for (String featureToAdd : featuresToAdd) {
                if (this.discoveryManager.includesFeature(featureToAdd)) continue;
                this.discoveryManager.addFeature(featureToAdd);
            }
        }
        this.capsManager = new EntityCapsManager();
        this.capsManager.addPacketListener(connection);
        this.initFeatures();
        this.updateEntityCapsVersion();
        connection.addPacketInterceptor((StanzaListener)this, (StanzaFilter)new StanzaTypeFilter(Presence.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.add(feature);
            this.discoveryManager.addFeature(feature);
        }
        this.updateEntityCapsVersion();
    }

    private void updateEntityCapsVersion() {
        if (this.connection != null) {
            this.capsManager.calculateEntityCapsVersion(this.getOwnDiscoverInfo());
        }
    }

    public List<String> getFeatures() {
        return this.unmodifiableFeatures;
    }

    public DiscoverInfo getOwnDiscoverInfo() {
        DiscoverInfo di = new DiscoverInfo();
        di.setType(IQ.Type.result);
        di.setNode(this.capsManager.getNode() + "#" + this.capsManager.getCapsVersion());
        this.addDiscoverInfoTo(di);
        return di;
    }

    private void addDiscoverInfoTo(DiscoverInfo response) {
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", this.discoveryManager.getIdentityName(), this.discoveryManager.getIdentityType());
        response.addIdentity(identity);
        if (!response.containsFeature((CharSequence)"http://jabber.org/protocol/caps")) {
            response.addFeature("http://jabber.org/protocol/caps");
        }
        for (String feature : this.unmodifiableFeatures) {
            if (response.containsFeature((CharSequence)feature)) continue;
            response.addFeature(feature);
        }
    }

    public boolean includesFeature(String feature) {
        return this.discoveryManager.includesFeature(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.remove(feature);
            this.discoveryManager.removeFeature(feature);
        }
        this.updateEntityCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtFeature(String ext) {
        List<String> list = this.extCapabilities;
        synchronized (list) {
            this.extCapabilities.add(ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtFeature(String ext) {
        List<String> list = this.extCapabilities;
        synchronized (list) {
            this.extCapabilities.remove(ext);
        }
    }

    public synchronized String getExtFeatures() {
        StringBuilder bldr = new StringBuilder("");
        for (String e : this.extCapabilities) {
            bldr.append(e);
            bldr.append(" ");
        }
        return bldr.toString();
    }

    public void processStanza(Stanza packet) {
        if (packet instanceof Presence) {
            CapsExtension caps = new CapsExtension(this.capsManager.getNode(), this.capsManager.getCapsVersion(), "sha-1");
            this.discoveryManager.setNodeInformationProvider(caps.getNode() + "#" + caps.getVer(), (NodeInformationProvider)this);
            ExtensionElement oldCaps = packet.getExtension("c", "http://jabber.org/protocol/caps");
            if (oldCaps != null) {
                packet.removeExtension(oldCaps);
            }
            packet.addExtension((ExtensionElement)caps);
        }
    }

    public List<DiscoverItems.Item> getNodeItems() {
        return null;
    }

    public List<String> getNodeFeatures() {
        return this.getFeatures();
    }

    public List<DiscoverInfo.Identity> getNodeIdentities() {
        return this.identities;
    }

    public List<ExtensionElement> getNodePacketExtensions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFeatures() {
        List<String> list = this.features;
        synchronized (list) {
            for (String feature : this.discoveryManager.getFeatures()) {
                this.features.add(feature);
            }
        }
    }

    public DiscoverInfo discoverInfo(Jid entityID) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        DiscoverInfo discoverInfo = this.capsManager.getDiscoverInfoByUser(entityID);
        EntityCapsManager.Caps caps = this.capsManager.getCapsByUser(entityID);
        if (discoverInfo != null && caps.isValid(discoverInfo)) {
            return discoverInfo;
        }
        if (this.cacheNonCaps && (caps == null || !caps.isValid(discoverInfo)) && (discoverInfo = this.nonCapsCache.get(entityID)) != null) {
            return discoverInfo;
        }
        discoverInfo = this.discoveryManager.discoverInfo(entityID, caps == null ? null : caps.getNodeVer());
        if (caps != null && !caps.isValid(discoverInfo)) {
            if (!caps.hash.equals("")) {
                logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
            }
            caps = null;
        }
        if (caps == null) {
            if (this.cacheNonCaps) {
                this.nonCapsCache.put(entityID, discoverInfo);
            }
        } else {
            EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
        }
        return discoverInfo;
    }

    public DiscoverInfo discoverInfoNonBlocking(Jid entityID) throws XMPPException {
        DiscoverInfo discoverInfo = this.capsManager.getDiscoverInfoByUser(entityID);
        EntityCapsManager.Caps caps = this.capsManager.getCapsByUser(entityID);
        if (discoverInfo != null && caps.isValid(discoverInfo)) {
            return discoverInfo;
        }
        if (this.cacheNonCaps && (caps == null || !caps.isValid(discoverInfo)) && (discoverInfo = this.nonCapsCache.get(entityID)) != null) {
            return discoverInfo;
        }
        this.retriever.addEntityForRetrieve(entityID, caps);
        return null;
    }

    public DiscoverItems discoverItems(Jid entityID) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.discoveryManager.discoverItems(entityID);
    }

    public DiscoverItems discoverItems(Jid entityID, String node) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.discoveryManager.discoverItems(entityID, node);
    }

    public boolean supportsFeature(Jid jid, String feature) {
        DiscoverInfo info;
        try {
            info = this.discoverInfo(jid);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            logger.info((Object)("failed to retrieve disco info for " + jid + " feature " + feature), ex);
            return false;
        }
        return info != null && info.containsFeature((CharSequence)feature);
    }

    public EntityCapsManager getCapsManager() {
        return this.capsManager;
    }

    public void stop() {
        if (this.retriever != null) {
            this.retriever.stop();
        }
        this.discoveryManager.removeNodeInformationProvider(this.capsManager.getNode() + "#" + this.capsManager.getCapsVersion());
        this.connection = null;
    }

    private class DiscoveryInfoRetriever
    implements Runnable {
        private boolean stopped = true;
        private Thread retrieverThread = null;
        private final Map<Jid, EntityCapsManager.Caps> entities = new HashMap<Jid, EntityCapsManager.Caps>();
        private OperationSetContactCapabilitiesJabberImpl capabilitiesOpSet;

        private DiscoveryInfoRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.stopped = false;
                while (!this.stopped) {
                    Map.Entry<Jid, EntityCapsManager.Caps> entityToProcess = null;
                    Map<Jid, EntityCapsManager.Caps> map = this.entities;
                    synchronized (map) {
                        Iterator<Map.Entry<Jid, EntityCapsManager.Caps>> iter;
                        if (this.entities.size() == 0) {
                            try {
                                this.entities.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if ((iter = this.entities.entrySet().iterator()).hasNext()) {
                            entityToProcess = iter.next();
                            iter.remove();
                        }
                    }
                    if (entityToProcess != null) {
                        this.requestDiscoveryInfo(entityToProcess.getKey(), entityToProcess.getValue());
                    }
                    entityToProcess = null;
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error requesting discovery info, thread ended unexpectedly", t);
            }
        }

        private void requestDiscoveryInfo(Jid entityID, EntityCapsManager.Caps caps) {
            block8: {
                try {
                    DiscoverInfo discoverInfo = ScServiceDiscoveryManager.this.discoveryManager.discoverInfo(entityID, caps == null ? null : caps.getNodeVer());
                    if (caps != null && !caps.isValid(discoverInfo)) {
                        if (!caps.hash.equals("")) {
                            logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
                        }
                        caps = null;
                    }
                    boolean fireEvent = false;
                    if (caps == null) {
                        if (ScServiceDiscoveryManager.this.cacheNonCaps) {
                            ScServiceDiscoveryManager.this.nonCapsCache.put(entityID, discoverInfo);
                            fireEvent = true;
                        }
                    } else {
                        EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
                        fireEvent = true;
                    }
                    if (fireEvent && this.capabilitiesOpSet != null) {
                        this.capabilitiesOpSet.fireContactCapabilitiesChanged(entityID.asBareJid(), ScServiceDiscoveryManager.this.capsManager.getFullJidsByBareJid((Jid)entityID.asBareJid()));
                    }
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
                    if (!logger.isTraceEnabled()) break block8;
                    logger.error((Object)("Error requesting discover info for " + entityID), ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntityForRetrieve(Jid entityID, EntityCapsManager.Caps caps) {
            Map<Jid, EntityCapsManager.Caps> map = this.entities;
            synchronized (map) {
                if (!this.entities.containsKey(entityID)) {
                    this.entities.put(entityID, caps);
                    this.entities.notifyAll();
                    if (this.retrieverThread == null) {
                        this.start();
                    }
                }
            }
        }

        private void start() {
            this.capabilitiesOpSet = (OperationSetContactCapabilitiesJabberImpl)ScServiceDiscoveryManager.this.parentProvider.getOperationSet(OperationSetContactCapabilities.class);
            this.retrieverThread = new Thread((Runnable)this, ScServiceDiscoveryManager.class.getName());
            this.retrieverThread.setDaemon(true);
            this.retrieverThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Map<Jid, EntityCapsManager.Caps> map = this.entities;
            synchronized (map) {
                this.stopped = true;
                this.entities.notifyAll();
                this.retrieverThread = null;
            }
        }
    }
}

