/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class RootContactGroupJabberImpl
extends AbstractContactGroupJabberImpl {
    private String ROOT_CONTACT_GROUP_NAME = "ContactListRoot";
    private List<ContactGroup> subGroups = new LinkedList<ContactGroup>();
    private boolean isResolved = false;
    private Map<Jid, Contact> contacts = new Hashtable<Jid, Contact>();
    private final ProtocolProviderServiceJabberImpl protocolProvider;

    RootContactGroupJabberImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public boolean canContainSubgroups() {
        return true;
    }

    public String getGroupName() {
        return this.ROOT_CONTACT_GROUP_NAME;
    }

    void removeContact(ContactJabberImpl contact) {
        this.contacts.remove(contact.getAddress().toLowerCase());
    }

    @Override
    public void addContact(ContactJabberImpl contact) {
        this.contacts.put(contact.getAddressAsJid(), (Contact)contact);
    }

    void addSubGroup(ContactGroupJabberImpl group) {
        this.subGroups.add(group);
    }

    void removeSubGroup(ContactGroupJabberImpl group) {
        this.removeSubGroup(this.subGroups.indexOf(group));
    }

    void removeSubGroup(int index) {
        this.subGroups.remove(index);
    }

    public int countSubgroups() {
        return this.subGroups.size();
    }

    public ContactGroup getParentContactGroup() {
        return null;
    }

    public ContactGroup getGroup(int index) {
        return this.subGroups.get(index);
    }

    public ContactGroup getGroup(String groupName) {
        Iterator<ContactGroup> subgroups = this.subgroups();
        while (subgroups.hasNext()) {
            ContactGroup grp = subgroups.next();
            if (!grp.getGroupName().equals(groupName)) continue;
            return grp;
        }
        return null;
    }

    public Contact getContact(String id) {
        try {
            return this.findContact(JidCreate.from((String)id));
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    ContactJabberImpl findContact(Jid id) {
        if (id == null) {
            return null;
        }
        return (ContactJabberImpl)this.contacts.get(id);
    }

    public Iterator<ContactGroup> subgroups() {
        return new ArrayList<ContactGroup>(this.subGroups).iterator();
    }

    public int countContacts() {
        return this.contacts.size();
    }

    public Iterator<Contact> contacts() {
        return this.contacts.values().iterator();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getGroupName());
        buff.append(".subGroups=" + this.countSubgroups() + ":\n");
        Iterator<ContactGroup> subGroups = this.subgroups();
        while (subGroups.hasNext()) {
            ContactGroup group = subGroups.next();
            buff.append(group.toString());
            if (!subGroups.hasNext()) continue;
            buff.append("\n");
        }
        buff.append(".rootContacts=" + this.countContacts() + ":\n");
        Iterator<Contact> contactsIter = this.contacts();
        while (contactsIter.hasNext()) {
            buff.append(contactsIter.next());
            if (!contactsIter.hasNext()) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public String getUID() {
        return this.getGroupName();
    }
}

