/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.MobileIndicator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.RootContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.Logger;
import org.jitsi.xmpp.extensions.vcardavatar.VCardTempXUpdateInterceptor;
import org.jitsi.xmpp.extensions.vcardavatar.VCardTempXUpdatePresenceExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jivesoftware.smackx.vcardtemp.VCardManager;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetPersistentPresenceJabberImpl
extends AbstractOperationSetPersistentPresence<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetPersistentPresenceJabberImpl.class);
    private String currentStatusMessage = "";
    private PresenceStatus currentStatus = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline");
    private static Map<String, Presence.Mode> scToJabberModesMappings = new Hashtable<String, Presence.Mode>();
    private static Map<String, Integer> statusToPriorityMappings;
    private final ServerStoredContactListJabberImpl ssContactList;
    private JabberSubscriptionListener subscribtionPacketListener = null;
    private int resourcePriorityAvailable = 30;
    private ContactChangesListener contactChangesListener = null;
    private VCardTempXUpdatePresenceExtension vCardTempXUpdatePresenceExtension = null;
    private final MobileIndicator mobileIndicator;
    private Presence currentPresence = null;
    private ContactJabberImpl localContact = null;

    public OperationSetPersistentPresenceJabberImpl(ProtocolProviderServiceJabberImpl provider, InfoRetreiver infoRetreiver) {
        super((ProtocolProviderService)provider);
        this.initializePriorities();
        this.ssContactList = new ServerStoredContactListJabberImpl(this, provider, infoRetreiver);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).addRegistrationStateChangeListener(new RegistrationStateListener());
        this.mobileIndicator = new MobileIndicator((ProtocolProviderServiceJabberImpl)this.parentProvider, this.ssContactList);
    }

    public void addServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.addGroupListener(listener);
    }

    public void createServerStoredContactGroup(ContactGroup parent, String groupName) throws OperationFailedException {
        this.assertConnected();
        if (!parent.canContainSubgroups()) {
            throw new IllegalArgumentException("The specified contact group cannot contain child groups. Group:" + parent);
        }
        this.ssContactList.createGroup(groupName);
    }

    public synchronized ContactJabberImpl createVolatileContact(Jid id) {
        return this.createVolatileContact(id, null);
    }

    public synchronized ContactJabberImpl createVolatileContact(Jid id, String displayName) {
        return this.createVolatileContact(id, false, displayName);
    }

    public synchronized ContactJabberImpl createVolatileContact(Jid id, boolean isPrivateMessagingContact) {
        return this.createVolatileContact(id, isPrivateMessagingContact, null);
    }

    public synchronized ContactJabberImpl createVolatileContact(Jid id, boolean isPrivateMessagingContact, String displayName) {
        ContactGroupJabberImpl notInContactListGroup = this.ssContactList.getNonPersistentGroup();
        ContactJabberImpl sourceContact = null;
        if (notInContactListGroup != null) {
            sourceContact = notInContactListGroup.findContact((Jid)id.asBareJid());
        }
        if (sourceContact != null) {
            return sourceContact;
        }
        sourceContact = this.ssContactList.createVolatileContact(id, isPrivateMessagingContact, displayName);
        if (isPrivateMessagingContact && id.hasResource()) {
            this.updateResources(sourceContact, false);
        }
        return sourceContact;
    }

    public Contact createUnresolvedContact(String address, String persistentData, ContactGroup parentGroup) {
        if (!(parentGroup instanceof ContactGroupJabberImpl) && !(parentGroup instanceof RootContactGroupJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact group (group=" + parentGroup + ")");
        }
        try {
            return this.ssContactList.createUnresolvedContact(parentGroup, JidCreate.from((String)address));
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("Invalid JID", e);
        }
    }

    public Contact createUnresolvedContact(String address, String persistentData) {
        return this.createUnresolvedContact(address, persistentData, this.getServerStoredContactListRoot());
    }

    public ContactGroup createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        return this.ssContactList.createUnresolvedContactGroup(groupUID);
    }

    public Contact findContactByID(String contactID) {
        try {
            return this.ssContactList.findContactById(JidCreate.from((String)contactID));
        }
        catch (XmppStringprepException e) {
            logger.error((Object)("Could not parse contact into Jid: " + contactID), (Throwable)e);
            return null;
        }
    }

    public Contact findContactByID(Jid contactId) {
        return this.ssContactList.findContactById(contactId);
    }

    public String getCurrentStatusMessage() {
        return this.currentStatusMessage;
    }

    public Contact getLocalContact() {
        BareJid id;
        if (this.localContact != null) {
            return this.localContact;
        }
        try {
            id = JidCreate.from((String)((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getUserID()).asBareJid();
        }
        catch (XmppStringprepException e) {
            return null;
        }
        this.localContact = new ContactJabberImpl(null, this.ssContactList, false, true);
        this.localContact.setLocal(true);
        this.localContact.updatePresenceStatus(this.currentStatus);
        this.localContact.setJid(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
        Map<FullJid, ContactResourceJabberImpl> rs = this.localContact.getResourcesMap();
        if (this.currentPresence != null) {
            rs.put(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID().asFullJidIfPossible(), this.createResource(this.currentPresence, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID().asFullJidIfPossible(), (Contact)this.localContact));
        }
        for (Presence p : this.ssContactList.getPresences(id)) {
            FullJid fullJid = p.getFrom().asFullJidIfPossible();
            rs.put(fullJid, this.createResource(p, p.getFrom().asFullJidIfPossible(), (Contact)this.localContact));
        }
        StanzaTypeFilter presenceFilter = new StanzaTypeFilter(Presence.class);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza packet) {
                Presence presence = (Presence)packet;
                Jid from = presence.getFrom();
                if (from == null || !from.asBareJid().equals((CharSequence)id)) {
                    return;
                }
                OperationSetPersistentPresenceJabberImpl.this.updateResource(OperationSetPersistentPresenceJabberImpl.this.localContact, null, presence);
            }
        }, (StanzaFilter)presenceFilter);
        return this.localContact;
    }

    private ContactResourceJabberImpl createResource(Presence presence, FullJid fullJid, Contact contact) {
        return new ContactResourceJabberImpl(fullJid, contact, OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider), presence.getPriority(), this.mobileIndicator.isMobileResource((Jid)fullJid));
    }

    private void clearLocalContactResources() {
        if (this.localContact != null) {
            this.removeResource(this.localContact, this.localContact.getAddressAsJid().asFullJidIfPossible());
        }
        this.currentPresence = null;
        this.localContact = null;
    }

    public PresenceStatus getPresenceStatus() {
        return this.currentStatus;
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.ssContactList.getRootGroup();
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getSupportedStatusSet();
    }

    public boolean isPrivateMessagingContact(Jid contactAddress) {
        return this.ssContactList.isPrivateMessagingContact(contactAddress);
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) throws OperationFailedException {
        this.assertConnected();
        if (!(contactToMove instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not an jabber contact." + contactToMove);
        }
        if (!(newParent instanceof AbstractContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group." + newParent);
        }
        this.ssContactList.moveContact((ContactJabberImpl)contactToMove, (AbstractContactGroupJabberImpl)newParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishPresenceStatus(PresenceStatus status, String statusMessage) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        JabberStatusEnum jabberStatusEnum = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum();
        boolean isValidStatus = false;
        Object supportedStatusIter = jabberStatusEnum.getSupportedStatusSet();
        while (supportedStatusIter.hasNext()) {
            if (!((PresenceStatus)supportedStatusIter.next()).equals((Object)status)) continue;
            isValidStatus = true;
            break;
        }
        if (!isValidStatus) {
            throw new IllegalArgumentException(status + " is not a valid Jabber status");
        }
        supportedStatusIter = this.ssContactList.getRosterInitLock();
        synchronized (supportedStatusIter) {
            if (!this.ssContactList.isRosterInitialized()) {
                this.ssContactList.setInitialStatus(status);
                this.ssContactList.setInitialStatusMessage(statusMessage);
                return;
            }
        }
        if (status.equals((Object)jabberStatusEnum.getStatus("Offline"))) {
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).unregister();
            this.clearLocalContactResources();
        } else {
            Presence presence;
            this.currentPresence = presence = new Presence(Presence.Type.available);
            presence.setMode(OperationSetPersistentPresenceJabberImpl.presenceStatusToJabberMode(status));
            presence.setPriority(this.getPriorityForPresenceStatus(status.getStatusName()));
            if (status.equals((Object)jabberStatusEnum.getStatus("On the phone"))) {
                presence.setStatus("On the phone");
            } else if (status.equals((Object)jabberStatusEnum.getStatus("In a meeting"))) {
                presence.setStatus("In a meeting");
            } else {
                presence.setStatus(statusMessage);
            }
            try {
                ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendStanza((Stanza)presence);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new OperationFailedException("Could not send new presense status", 1, e);
            }
            if (this.localContact != null) {
                this.updateResource(this.localContact, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID().asFullJidIfPossible(), presence);
            }
        }
        this.fireProviderStatusChangeEvent(this.currentStatus, status);
        String oldStatusMessage = this.getCurrentStatusMessage();
        if (!Objects.equals(oldStatusMessage, statusMessage)) {
            this.currentStatusMessage = statusMessage;
            this.fireProviderStatusMessageChangeEvent(oldStatusMessage, this.getCurrentStatusMessage());
        }
    }

    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        BareJid contactJid;
        try {
            contactJid = JidCreate.bareFrom((String)contactIdentifier);
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException("Contact is not a valid JID", 1, (Throwable)e);
        }
        this.assertConnected();
        XMPPConnection xmppConnection = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection();
        if (xmppConnection == null) {
            throw new IllegalArgumentException("The provider/account must be signed on in order to query the status of a contact in its roster");
        }
        Roster r = Roster.getInstanceFor((XMPPConnection)xmppConnection);
        Presence presence = r.getPresence(contactJid);
        return OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider);
    }

    public void removeServerStoredContactGroup(ContactGroup group) throws OperationFailedException {
        this.assertConnected();
        if (!(group instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group: " + group);
        }
        this.ssContactList.removeGroup((ContactGroupJabberImpl)group);
    }

    public void removeServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.removeGroupListener(listener);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        this.assertConnected();
        if (!(group instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group: " + group);
        }
        this.ssContactList.renameGroup((ContactGroupJabberImpl)group, newName);
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
        this.subscribtionPacketListener.setHandler(handler);
    }

    public void subscribe(ContactGroup parent, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(parent instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact group (group=" + parent + ")");
        }
        this.ssContactList.addContact(parent, contactIdentifier);
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        this.ssContactList.addContact(contactIdentifier);
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact (contact=" + contact + ")");
        }
        this.ssContactList.removeContact((ContactJabberImpl)contact);
    }

    public static PresenceStatus jabberStatusToPresenceStatus(Presence presence, ProtocolProviderServiceJabberImpl jabberProvider) {
        JabberStatusEnum jabberStatusEnum = jabberProvider.getJabberStatusEnum();
        if (!presence.isAvailable()) {
            return jabberStatusEnum.getStatus("Offline");
        }
        Presence.Mode mode = presence.getMode();
        if (mode.equals((Object)Presence.Mode.available)) {
            return jabberStatusEnum.getStatus("Available");
        }
        if (mode.equals((Object)Presence.Mode.away)) {
            if (presence.getStatus() != null && presence.getStatus().contains("On the phone")) {
                return jabberStatusEnum.getStatus("On the phone");
            }
            if (presence.getStatus() != null && presence.getStatus().contains("In a meeting")) {
                return jabberStatusEnum.getStatus("In a meeting");
            }
            return jabberStatusEnum.getStatus("Away");
        }
        if (mode.equals((Object)Presence.Mode.chat)) {
            return jabberStatusEnum.getStatus("Free For Chat");
        }
        if (mode.equals((Object)Presence.Mode.dnd)) {
            return jabberStatusEnum.getStatus("Do Not Disturb");
        }
        if (mode.equals((Object)Presence.Mode.xa)) {
            return jabberStatusEnum.getStatus("Extended Away");
        }
        if (presence.isAway()) {
            return jabberStatusEnum.getStatus("Away");
        }
        if (presence.isAvailable()) {
            return jabberStatusEnum.getStatus("Available");
        }
        return jabberStatusEnum.getStatus("Offline");
    }

    public static Presence.Mode presenceStatusToJabberMode(PresenceStatus status) {
        return scToJabberModesMappings.get(status.getStatusName());
    }

    void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the Jabber service before being able to communicate.");
        }
        if (!((ProtocolProviderServiceJabberImpl)this.parentProvider).isRegistered()) {
            if (this.currentStatus != null && this.currentStatus.isOnline()) {
                this.fireProviderStatusChangeEvent(this.currentStatus, (PresenceStatus)((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline"));
            }
            throw new IllegalStateException("The provider must be signed on the Jabber service before being able to communicate.");
        }
    }

    public void fireProviderStatusChangeEvent(PresenceStatus oldStatus, PresenceStatus newStatus) {
        if (!oldStatus.equals((Object)newStatus)) {
            this.currentStatus = newStatus;
            super.fireProviderStatusChangeEvent(oldStatus, newStatus);
            JabberStatusEnum.JabberPresenceStatus offlineStatus = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline");
            if (newStatus.equals((Object)offlineStatus)) {
                Iterator groupsIter = this.getServerStoredContactListRoot().subgroups();
                while (groupsIter.hasNext()) {
                    ContactGroup group = (ContactGroup)groupsIter.next();
                    Iterator contactsIter = group.contacts();
                    while (contactsIter.hasNext()) {
                        ContactJabberImpl contact = (ContactJabberImpl)((Object)contactsIter.next());
                        this.updateContactStatus(contact, (PresenceStatus)offlineStatus);
                    }
                }
                Iterator contactsIter = this.getServerStoredContactListRoot().contacts();
                while (contactsIter.hasNext()) {
                    ContactJabberImpl contact = (ContactJabberImpl)((Object)contactsIter.next());
                    this.updateContactStatus(contact, (PresenceStatus)offlineStatus);
                }
            }
        }
    }

    public void setDisplayName(Contact contact, String newName) throws IllegalArgumentException {
        this.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact (contact=" + contact + ")");
        }
        RosterEntry entry = ((ContactJabberImpl)contact).getSourceEntry();
        if (entry == null) {
            return;
        }
        try {
            entry.setName(newName);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            throw new IllegalArgumentException("Could not update name", e);
        }
    }

    private void clearConnectionListeners() {
        XMPPConnection connection = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection();
        if (connection != null && this.subscribtionPacketListener != null && this.contactChangesListener != null) {
            connection.removeAsyncStanzaListener((StanzaListener)this.subscribtionPacketListener);
            Roster.getInstanceFor((XMPPConnection)connection).removeRosterListener((RosterListener)this.contactChangesListener);
            this.subscribtionPacketListener = null;
            this.contactChangesListener = null;
        }
    }

    private boolean updateResources(ContactJabberImpl contact, boolean removeUnavailable) {
        if (!contact.isResolved() || contact instanceof VolatileContactJabberImpl && ((VolatileContactJabberImpl)contact).isPrivateMessagingContact()) {
            return false;
        }
        boolean eventFired = false;
        Map<FullJid, ContactResourceJabberImpl> resources = contact.getResourcesMap();
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null || !((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().isConnected()) {
            if (removeUnavailable) {
                Iterator<Map.Entry<FullJid, ContactResourceJabberImpl>> iter = resources.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<FullJid, ContactResourceJabberImpl> entry = iter.next();
                    iter.remove();
                    contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)entry.getValue(), 1));
                    eventFired = true;
                }
            }
            return eventFired;
        }
        Roster r = Roster.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
        BareJid bareJid = contact.getAddressAsJid().asBareJid();
        for (Presence presence : r.getPresences(bareJid)) {
            eventFired = this.updateResource(contact, null, presence) || eventFired;
        }
        if (!removeUnavailable) {
            return eventFired;
        }
        for (FullJid fullJid : resources.keySet()) {
            if (r.getPresenceResource(fullJid).isAvailable()) continue;
            eventFired = this.removeResource(contact, fullJid) || eventFired;
        }
        return eventFired;
    }

    private boolean updateResource(ContactJabberImpl contact, FullJid fullJid, Presence presence) {
        if (fullJid == null) {
            fullJid = presence.getFrom().asFullJidIfPossible();
        }
        if (fullJid == null) {
            return false;
        }
        Resourcepart resource = fullJid.getResourceOrNull();
        if (resource != null && resource.length() > 0) {
            Map<FullJid, ContactResourceJabberImpl> resources = contact.getResourcesMap();
            ContactResourceJabberImpl contactResource = resources.get(fullJid);
            PresenceStatus newPresenceStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider);
            if (contactResource == null) {
                contactResource = this.createResource(presence, fullJid, (Contact)contact);
                resources.put(fullJid, contactResource);
                contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)contactResource, 0));
                return true;
            }
            boolean oldIndicator = contactResource.isMobile();
            boolean newIndicator = this.mobileIndicator.isMobileResource((Jid)fullJid);
            int oldPriority = contactResource.getPriority();
            contactResource.setMobile(newIndicator);
            contactResource.setPriority(presence.getPriority());
            if (oldPriority != contactResource.getPriority()) {
                this.mobileIndicator.resourcesUpdated(contact);
            }
            if (contactResource.getPresenceStatus().getStatus() != newPresenceStatus.getStatus() || oldIndicator != newIndicator || oldPriority != contactResource.getPriority()) {
                contactResource.setPresenceStatus(newPresenceStatus);
                contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)contactResource, 2));
                return true;
            }
        }
        return false;
    }

    private boolean removeResource(ContactJabberImpl contact, FullJid fullJid) {
        Map<FullJid, ContactResourceJabberImpl> resources = contact.getResourcesMap();
        if (resources.containsKey(fullJid)) {
            ContactResource removedResource = resources.remove(fullJid);
            contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, removedResource, 1));
            return true;
        }
        return false;
    }

    void firePresenceStatusChanged(Presence presence) {
        if (this.contactChangesListener != null) {
            this.contactChangesListener.firePresenceStatusChanged(presence);
        }
    }

    private void updateContactStatus(ContactJabberImpl contact, PresenceStatus newStatus) {
        boolean oldMobileIndicator = contact.isMobile();
        boolean resourceUpdated = this.updateResources(contact, true);
        this.mobileIndicator.resourcesUpdated(contact);
        PresenceStatus oldStatus = contact.getPresenceStatus();
        if (oldStatus.equals((Object)newStatus) && oldMobileIndicator == contact.isMobile()) {
            return;
        }
        contact.updatePresenceStatus(newStatus);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Will Dispatch the contact status event.");
        }
        this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldStatus, newStatus, resourceUpdated);
    }

    public void createAccountPhotoPresenceInterceptor() {
        if (this.vCardTempXUpdatePresenceExtension != null) {
            return;
        }
        byte[] avatar = null;
        try {
            VCardManager manager = VCardManager.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
            VCard vCard = manager.loadVCard();
            avatar = vCard.getAvatar();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            logger.info((Object)("Can not retrieve account avatar for " + ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID() + ": " + ex.getMessage()));
        }
        this.vCardTempXUpdatePresenceExtension = new VCardTempXUpdatePresenceExtension(avatar);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addPacketInterceptor((StanzaListener)new VCardTempXUpdateInterceptor(this.vCardTempXUpdatePresenceExtension), (StanzaFilter)new StanzaTypeFilter(Presence.class));
    }

    public void updateAccountPhotoPresenceExtension(byte[] imageBytes) {
        try {
            if (this.vCardTempXUpdatePresenceExtension.updateImage(imageBytes)) {
                this.publishPresenceStatus(this.currentStatus, this.currentStatusMessage);
            }
        }
        catch (OperationFailedException ex) {
            logger.info((Object)"Can not send presence extension to broadcast photo update", (Throwable)ex);
        }
    }

    public void createContactPhotoPresenceListener() {
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza packet) {
                OperationSetPersistentPresenceJabberImpl.this.parseContactPhotoPresence(packet);
            }
        }, (StanzaFilter)new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Presence.class), new StanzaExtensionFilter("x", "vcard-temp:x:update")}));
    }

    public void parseContactPhotoPresence(Stanza packet) {
        block8: {
            EntityBareJid userID = packet.getFrom().asEntityBareJidOrThrow();
            ContactJabberImpl sourceContact = this.ssContactList.findContactById((Jid)userID);
            if (sourceContact == null) {
                return;
            }
            byte[] currentAvatar = sourceContact.getImage(false);
            StandardExtensionElement defaultPacketExtension = (StandardExtensionElement)packet.getExtension("x", "vcard-temp:x:update");
            if (defaultPacketExtension == null) {
                return;
            }
            try {
                StandardExtensionElement photoElement = defaultPacketExtension.getFirstElement("photo");
                if (photoElement == null) {
                    return;
                }
                String packetPhotoSHA1 = photoElement.getText();
                if (packetPhotoSHA1 != null && !packetPhotoSHA1.equals(VCardTempXUpdatePresenceExtension.getImageSha1((byte[])currentAvatar))) {
                    byte[] newAvatar = null;
                    if (packetPhotoSHA1.length() != 0) {
                        VCardManager manager = VCardManager.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
                        VCard vCard = manager.loadVCard(userID);
                        newAvatar = vCard.getAvatar();
                    } else {
                        newAvatar = new byte[]{};
                    }
                    sourceContact.setImage(newAvatar);
                    this.fireContactPropertyChangeEvent("Image", (Contact)sourceContact, currentAvatar, newAvatar);
                }
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
                logger.info((Object)("Cannot retrieve vCard from: " + packet.getFrom()));
                if (!logger.isTraceEnabled()) break block8;
                logger.trace((Object)"vCard retrieval exception was: ", ex);
            }
        }
    }

    private void initializePriorities() {
        try {
            this.resourcePriorityAvailable = Integer.parseInt(((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getAccountPropertyString((Object)"RESOURCE_PRIORITY"));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Wrong value for resource priority", (Throwable)ex);
        }
        this.addDefaultValue("Away", -5);
        this.addDefaultValue("Extended Away", -10);
        this.addDefaultValue("On the phone", -15);
        this.addDefaultValue("In a meeting", -16);
        this.addDefaultValue("Do Not Disturb", -20);
        this.addDefaultValue("Free For Chat", 5);
    }

    private void addDefaultValue(String statusName, int availableShift) {
        String resourcePriority = this.getAccountPriorityForStatus(statusName);
        if (resourcePriority != null) {
            try {
                OperationSetPersistentPresenceJabberImpl.addPresenceToPriorityMapping(statusName, Integer.parseInt(resourcePriority));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("Wrong value for resource priority for status: " + statusName), (Throwable)ex);
            }
        } else {
            int priority = this.resourcePriorityAvailable + availableShift;
            if (priority <= 0) {
                priority = this.resourcePriorityAvailable;
            }
            OperationSetPersistentPresenceJabberImpl.addPresenceToPriorityMapping(statusName, priority);
        }
    }

    private static void addPresenceToPriorityMapping(String statusName, int value) {
        statusToPriorityMappings.put(statusName.replaceAll(" ", "_").toUpperCase(), value);
    }

    private int getPriorityForPresenceStatus(String statusName) {
        Integer priority = statusToPriorityMappings.get(statusName.replaceAll(" ", "_").toUpperCase());
        if (priority == null) {
            return this.resourcePriorityAvailable;
        }
        return priority;
    }

    private String getAccountPriorityForStatus(String statusName) {
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getAccountPropertyString((Object)("RESOURCE_PRIORITY_" + statusName.replaceAll(" ", "_").toUpperCase()));
    }

    public ServerStoredContactListJabberImpl getSsContactList() {
        return this.ssContactList;
    }

    static {
        scToJabberModesMappings.put("Away", Presence.Mode.away);
        scToJabberModesMappings.put("On the phone", Presence.Mode.away);
        scToJabberModesMappings.put("In a meeting", Presence.Mode.away);
        scToJabberModesMappings.put("Extended Away", Presence.Mode.xa);
        scToJabberModesMappings.put("Do Not Disturb", Presence.Mode.dnd);
        scToJabberModesMappings.put("Free For Chat", Presence.Mode.chat);
        scToJabberModesMappings.put("Available", Presence.Mode.available);
        statusToPriorityMappings = new Hashtable<String, Integer>();
    }

    private class ServerStoredListInit
    implements Runnable,
    StanzaListener {
        private ServerStoredListInit() {
        }

        @Override
        public void run() {
            ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().removeAsyncStanzaListener((StanzaListener)this);
            OperationSetPersistentPresenceJabberImpl.this.ssContactList.init(OperationSetPersistentPresenceJabberImpl.this.contactChangesListener);
            ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).startJingleNodesDiscovery();
        }

        public void processStanza(Stanza packet) {
            if (packet.getError() != null) {
                return;
            }
            new Thread((Runnable)this, this.getClass().getName()).start();
        }
    }

    private class JabberSubscriptionListener
    implements StanzaListener {
        private AuthorizationHandler handler = null;
        private Map<Jid, String> earlySubscriptions = new HashMap<Jid, String>();

        private JabberSubscriptionListener() {
        }

        private synchronized void setHandler(AuthorizationHandler handler) {
            this.handler = handler;
            this.handleEarlySubscribeReceived();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processStanza(Stanza packet) {
            Presence presence = (Presence)packet;
            if (presence == null) {
                return;
            }
            Presence.Type presenceType = presence.getType();
            Jid fromID = presence.getFrom();
            if (presenceType == Presence.Type.subscribe) {
                String displayName = null;
                Nick ext = (Nick)presence.getExtension("http://jabber.org/protocol/nick");
                if (ext != null) {
                    displayName = ext.getName();
                }
                JabberSubscriptionListener jabberSubscriptionListener = this;
                synchronized (jabberSubscriptionListener) {
                    if (this.handler == null) {
                        this.earlySubscriptions.put(fromID, displayName);
                        return;
                    }
                }
                this.handleSubscribeReceived(fromID, displayName);
            } else if (presenceType == Presence.Type.unsubscribed) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(fromID + " does not allow your subscription"));
                }
                if (this.handler == null) {
                    logger.warn((Object)("No to handle unsubscribed AuthorizationHandler for " + fromID));
                    return;
                }
                ContactJabberImpl contact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                if (contact != null) {
                    AuthorizationResponse response = new AuthorizationResponse(AuthorizationResponse.REJECT, "");
                    this.handler.processAuthorizationResponse(response, (Contact)contact);
                    try {
                        OperationSetPersistentPresenceJabberImpl.this.ssContactList.removeContact(contact);
                    }
                    catch (OperationFailedException e) {
                        logger.error((Object)"Cannot remove contact that unsubscribed.");
                    }
                }
            } else if (presenceType == Presence.Type.subscribed) {
                if (this.handler == null) {
                    logger.warn((Object)("No AuthorizationHandler to handle subscribed for " + fromID));
                    return;
                }
                ContactJabberImpl contact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                AuthorizationResponse response = new AuthorizationResponse(AuthorizationResponse.ACCEPT, "");
                this.handler.processAuthorizationResponse(response, (Contact)contact);
            } else if (presenceType == Presence.Type.available && OperationSetPersistentPresenceJabberImpl.this.contactChangesListener != null && OperationSetPersistentPresenceJabberImpl.this.contactChangesListener.isStoringPresenceEvents()) {
                OperationSetPersistentPresenceJabberImpl.this.contactChangesListener.addPresenceEvent(presence);
            }
        }

        private void handleEarlySubscribeReceived() {
            for (Jid from : this.earlySubscriptions.keySet()) {
                this.handleSubscribeReceived(from, this.earlySubscriptions.get(from));
            }
            this.earlySubscriptions.clear();
        }

        private void handleSubscribeReceived(final Jid fromID, final String displayName) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(fromID + " wants to add you to its contact list"));
                    }
                    ContactJabberImpl srcContact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                    Presence.Type responsePresenceType = null;
                    if (srcContact == null) {
                        srcContact = OperationSetPersistentPresenceJabberImpl.this.createVolatileContact(fromID, displayName);
                    } else if (srcContact.isPersistent()) {
                        responsePresenceType = Presence.Type.subscribed;
                    }
                    if (responsePresenceType == null) {
                        AuthorizationRequest req = new AuthorizationRequest();
                        AuthorizationResponse response = JabberSubscriptionListener.this.handler.processAuthorisationRequest(req, (Contact)srcContact);
                        if (response != null) {
                            if (response.getResponseCode().equals(AuthorizationResponse.ACCEPT)) {
                                responsePresenceType = Presence.Type.subscribed;
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)"Sending Accepted Subscription");
                                }
                            } else if (response.getResponseCode().equals(AuthorizationResponse.REJECT)) {
                                responsePresenceType = Presence.Type.unsubscribed;
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)"Sending Rejected Subscription");
                                }
                            }
                        }
                    }
                    if (responsePresenceType == null) {
                        return;
                    }
                    Presence responsePacket = new Presence(responsePresenceType);
                    responsePacket.setTo(fromID);
                    try {
                        ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().sendStanza((Stanza)responsePacket);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException e) {
                        logger.error((Object)"Could not send presence repsonse", e);
                    }
                }
            }).start();
        }
    }

    class ContactChangesListener
    implements RosterListener {
        private boolean storeEvents = false;
        private List<Presence> storedPresences = null;
        private final Map<Jid, TreeSet<Presence>> statuses = new Hashtable<Jid, TreeSet<Presence>>();

        ContactChangesListener() {
        }

        public void entriesAdded(Collection<Jid> addresses) {
        }

        public void entriesUpdated(Collection<Jid> addresses) {
        }

        public void entriesDeleted(Collection<Jid> addresses) {
        }

        public void presenceChanged(Presence presence) {
            this.firePresenceStatusChanged(presence);
        }

        boolean isStoringPresenceEvents() {
            return this.storeEvents;
        }

        void addPresenceEvent(Presence presence) {
            this.storedPresences.add(presence);
        }

        void storeEvents() {
            this.storedPresences = new ArrayList<Presence>();
            this.storeEvents = true;
        }

        void processStoredEvents() {
            this.storeEvents = false;
            for (Presence p : this.storedPresences) {
                this.firePresenceStatusChanged(p);
            }
            this.storedPresences.clear();
            this.storedPresences = null;
        }

        void firePresenceStatusChanged(Presence presence) {
            if (this.storeEvents && this.storedPresences != null) {
                this.storedPresences.add(presence);
                return;
            }
            try {
                Presence currentPresence;
                TreeSet<Presence> userStats;
                BareJid userID = presence.getFrom().asBareJid();
                OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getOperationSet(OperationSetMultiUserChat.class);
                if (mucOpSet != null) {
                    List chatRooms = mucOpSet.getCurrentlyJoinedChatRooms();
                    for (ChatRoom chatRoom : chatRooms) {
                        if (!chatRoom.getName().equals(userID.toString())) continue;
                        userID = presence.getFrom();
                        break;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received a status update for buddy=" + userID));
                }
                if ((userStats = this.statuses.get(userID)) == null) {
                    userStats = new TreeSet<Presence>(new Comparator<Presence>(){

                        @Override
                        public int compare(Presence o1, Presence o2) {
                            int res = o2.getPriority() - o1.getPriority();
                            if (res == 0 && (res = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(o2, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getStatus() - OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(o1, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getStatus()) == 0) {
                                res = o1.getFrom().compareTo((Object)o2.getFrom());
                            }
                            return res;
                        }
                    });
                    this.statuses.put((Jid)userID, userStats);
                } else {
                    Resourcepart resource = presence.getFrom().getResourceOrEmpty();
                    Iterator<Presence> iter = userStats.iterator();
                    while (iter.hasNext()) {
                        Presence p = iter.next();
                        if (!p.getFrom().getResourceOrEmpty().equals((Object)resource)) continue;
                        iter.remove();
                    }
                }
                if (!OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).equals((Object)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getJabberStatusEnum().getStatus("Offline"))) {
                    userStats.add(presence);
                }
                if (userStats.size() == 0) {
                    currentPresence = presence;
                    this.statuses.remove(userID);
                } else {
                    currentPresence = userStats.first();
                }
                ContactJabberImpl sourceContact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById((Jid)userID);
                if (sourceContact == null) {
                    logger.warn((Object)("No source contact found for id=" + userID));
                    return;
                }
                sourceContact.setStatusMessage(currentPresence.getStatus());
                OperationSetPersistentPresenceJabberImpl.this.updateContactStatus(sourceContact, OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(currentPresence, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                logger.error((Object)"Failed changing status", (Throwable)ex);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The Jabber provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().addAsyncStanzaListener((StanzaListener)new ServerStoredListInit(), (StanzaFilter)new StanzaTypeFilter(RosterPacket.class));
                OperationSetPersistentPresenceJabberImpl.this.contactChangesListener = new ContactChangesListener();
                if (OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener == null) {
                    OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener = new JabberSubscriptionListener();
                    ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().addAsyncStanzaListener((StanzaListener)OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener, (StanzaFilter)new StanzaTypeFilter(Presence.class));
                }
            } else if (evt.getNewState() == RegistrationState.REGISTERED) {
                boolean isServerStoredInfoEnabled;
                JabberAccountIDImpl accountID = (JabberAccountIDImpl)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getAccountID();
                boolean bl = isServerStoredInfoEnabled = !accountID.getAccountPropertyBoolean("SERVER_STORED_INFO_DISABLED", false);
                if (isServerStoredInfoEnabled) {
                    OperationSetPersistentPresenceJabberImpl.this.createContactPhotoPresenceListener();
                    if (!accountID.isAnonymousAuthUsed()) {
                        OperationSetPersistentPresenceJabberImpl.this.createAccountPhotoPresenceInterceptor();
                    }
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERING) {
                OperationSetPersistentPresenceJabberImpl.this.clearConnectionListeners();
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                PresenceStatus oldStatus = OperationSetPersistentPresenceJabberImpl.this.currentStatus;
                OperationSetPersistentPresenceJabberImpl.this.currentStatus = (PresenceStatus)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getJabberStatusEnum().getStatus("Offline");
                OperationSetPersistentPresenceJabberImpl.this.clearLocalContactResources();
                OperationSetPersistentPresenceJabberImpl.this.fireProviderStatusChangeEvent(oldStatus, OperationSetPersistentPresenceJabberImpl.this.currentStatus);
                OperationSetPersistentPresenceJabberImpl.this.ssContactList.cleanup();
                OperationSetPersistentPresenceJabberImpl.this.clearConnectionListeners();
            }
        }
    }
}

