/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.IncomingFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bob.BoBHash;
import org.jivesoftware.smackx.bob.BoBManager;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jxmpp.jid.Jid;

public class IncomingFileTransferRequestJabberImpl
implements IncomingFileTransferRequest {
    private static final Logger logger = Logger.getLogger(IncomingFileTransferRequestJabberImpl.class);
    private static ExecutorService thumbnailCollector = Executors.newSingleThreadExecutor();
    private String id;
    private final FileTransferRequest fileTransferRequest;
    private final OperationSetFileTransferJabberImpl fileTransferOpSet;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private Contact sender;
    private byte[] thumbnail;

    public IncomingFileTransferRequestJabberImpl(ProtocolProviderServiceJabberImpl jabberProvider, OperationSetFileTransferJabberImpl fileTransferOpSet, FileTransferRequest fileTransferRequest) {
        this.jabberProvider = jabberProvider;
        this.fileTransferOpSet = fileTransferOpSet;
        this.fileTransferRequest = fileTransferRequest;
        Jid fromUserID = fileTransferRequest.getRequestor();
        OperationSetPersistentPresenceJabberImpl opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.sender = opSetPersPresence.findContactByID(fromUserID);
        if (this.sender == null) {
            ChatRoomJabberImpl privateContactRoom = null;
            OperationSetMultiUserChatJabberImpl mucOpSet = (OperationSetMultiUserChatJabberImpl)jabberProvider.getOperationSet(OperationSetMultiUserChat.class);
            if (mucOpSet != null) {
                privateContactRoom = mucOpSet.getChatRoom(fromUserID.asBareJid());
            }
            if (privateContactRoom != null) {
                this.sender = ((OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class)).createVolatileContact(fromUserID, true);
                privateContactRoom.updatePrivateContactPresenceStatus(this.sender);
            }
        }
        this.id = String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode());
    }

    public Contact getSender() {
        return this.sender;
    }

    public String getFileDescription() {
        return this.fileTransferRequest.getDescription();
    }

    public String getFileName() {
        return this.fileTransferRequest.getFileName();
    }

    public long getFileSize() {
        return this.fileTransferRequest.getFileSize();
    }

    public net.java.sip.communicator.service.protocol.FileTransfer acceptFile(File file) {
        IncomingFileTransferJabberImpl incomingTransfer;
        block2: {
            incomingTransfer = null;
            IncomingFileTransfer jabberTransfer = this.fileTransferRequest.accept();
            try {
                incomingTransfer = new IncomingFileTransferJabberImpl(this.id, this.sender, file, jabberTransfer);
                FileTransferCreatedEvent event = new FileTransferCreatedEvent((net.java.sip.communicator.service.protocol.FileTransfer)incomingTransfer, new Date());
                this.fileTransferOpSet.fireFileTransferCreated(event);
                jabberTransfer.recieveFile(file);
                new OperationSetFileTransferJabberImpl.FileTransferProgressThread((FileTransfer)jabberTransfer, incomingTransfer, this.getFileSize()).start();
            }
            catch (IOException | SmackException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Receiving file failed.", e);
            }
        }
        return incomingTransfer;
    }

    public void rejectFile() throws OperationFailedException {
        try {
            this.fileTransferRequest.reject();
        }
        catch (InterruptedException | SmackException e) {
            throw new OperationFailedException("Could not reject file transfer", 1, e);
        }
        this.fileTransferOpSet.fireFileTransferRequestRejected(new FileTransferRequestEvent((OperationSetFileTransfer)this.fileTransferOpSet, (IncomingFileTransferRequest)this, new Date()));
    }

    public String getID() {
        return this.id;
    }

    public byte[] getThumbnail() {
        return this.thumbnail;
    }

    public void fetchThumbnailAndNotify(final BoBHash cid) {
        final BoBManager bobManager = BoBManager.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection());
        thumbnailCollector.submit(new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)"Sending thumbnail request");
                try {
                    IncomingFileTransferRequestJabberImpl.access$102(IncomingFileTransferRequestJabberImpl.this, bobManager.requestBoB(((ContactJabberImpl)IncomingFileTransferRequestJabberImpl.this.sender).getAddressAsJid(), cid).getContent());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException.XMPPErrorException e) {
                    logger.error((Object)"Could not get thumbnail", e);
                }
                finally {
                    IncomingFileTransferRequestJabberImpl.this.fileTransferOpSet.fireFileTransferRequest(IncomingFileTransferRequestJabberImpl.this);
                }
            }
        });
    }

    static /* synthetic */ byte[] access$102(IncomingFileTransferRequestJabberImpl x0, byte[] x1) {
        x0.thumbnail = x1;
        return x1;
    }
}

