/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ActiveCallsRepositoryJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomConfigurationFormJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.MessageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.utils.StringUtils;
import org.jitsi.xmpp.extensions.condesc.ConferenceDescriptionExtension;
import org.jitsi.xmpp.extensions.condesc.TransportExtension;
import org.jitsi.xmpp.extensions.jitsimeet.AvatarUrl;
import org.jitsi.xmpp.extensions.jitsimeet.Email;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StatsId;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.filter.MUCUserStatusCodeFilter;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xevent.MessageEventManager;
import org.jivesoftware.smackx.xevent.packet.MessageEvent;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class ChatRoomJabberImpl
extends AbstractChatRoom {
    private static final Logger logger = Logger.getLogger(ChatRoomJabberImpl.class);
    private MultiUserChat multiUserChat = null;
    private final Vector<ChatRoomMemberPresenceListener> memberListeners = new Vector();
    private final Vector<ChatRoomMemberRoleListener> memberRoleListeners = new Vector();
    private final Vector<ChatRoomLocalUserRoleListener> localUserRoleListeners = new Vector();
    private final Vector<ChatRoomMessageListener> messageListeners = new Vector();
    private final Vector<ChatRoomPropertyChangeListener> propertyChangeListeners = new Vector();
    private final Vector<ChatRoomMemberPropertyChangeListener> memberPropChangeListeners = new Vector();
    private final ProtocolProviderServiceJabberImpl provider;
    private final OperationSetMultiUserChatJabberImpl opSetMuc;
    private final Hashtable<Resourcepart, ChatRoomMemberJabberImpl> members = new Hashtable();
    private final Hashtable<Resourcepart, ChatRoomMember> banList = new Hashtable();
    private Resourcepart nickname;
    private String oldSubject;
    private ChatRoomMemberRole role = null;
    private ChatRoomConfigurationFormJabberImpl configForm;
    private InvitationRejectionListeners invitationRejectionListeners = new InvitationRejectionListeners();
    private ConferenceDescription publishedConference = null;
    private ConferenceDescriptionExtension publishedConferenceExt = null;
    private Presence lastPresenceSent = null;
    private final List<CallJabberImpl> chatRoomConferenceCalls = new ArrayList<CallJabberImpl>();
    private ChatRoomPresenceListener presenceListener = null;

    public ChatRoomJabberImpl(MultiUserChat multiUserChat, ProtocolProviderServiceJabberImpl provider) {
        this.multiUserChat = multiUserChat;
        this.provider = provider;
        this.opSetMuc = (OperationSetMultiUserChatJabberImpl)provider.getOperationSet(OperationSetMultiUserChat.class);
        this.oldSubject = multiUserChat.getSubject();
        multiUserChat.addSubjectUpdatedListener((SubjectUpdatedListener)new SmackSubjectUpdatedListener());
        multiUserChat.addMessageListener((MessageListener)new SmackMessageListener());
        multiUserChat.addParticipantStatusListener((ParticipantStatusListener)new MemberListener());
        multiUserChat.addUserStatusListener((UserStatusListener)new UserListener());
        multiUserChat.addPresenceInterceptor((PresenceListener)new PresenceInterceptor());
        this.provider.getConnection().addAsyncStanzaListener((StanzaListener)this.invitationRejectionListeners, (StanzaFilter)new StanzaTypeFilter(Message.class));
    }

    private MUCUser getMUCUserExtension(Stanza packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            if (!this.propertyChangeListeners.contains(listener)) {
                this.propertyChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            if (!this.memberPropChangeListeners.contains(listener)) {
                this.memberPropChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            this.memberPropChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            this.messageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            if (!this.memberListeners.contains(listener)) {
                this.memberListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            this.memberListeners.remove(listener);
        }
    }

    public synchronized void addConferenceCall(CallJabberImpl call) {
        if (!this.chatRoomConferenceCalls.contains((Object)call)) {
            this.chatRoomConferenceCalls.add(call);
        }
    }

    public synchronized void removeConferenceCall(CallJabberImpl call) {
        if (this.chatRoomConferenceCalls.contains((Object)call)) {
            this.chatRoomConferenceCalls.remove((Object)call);
        }
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        return new MessageJabberImpl(new String(content), contentType, contentEncoding, subject);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String messageText) {
        MessageJabberImpl msg = new MessageJabberImpl(messageText, "text/plain", "UTF-8", null);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatRoomMember> getMembers() {
        Hashtable<Resourcepart, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            return new LinkedList<ChatRoomMemberJabberImpl>(this.members.values());
        }
    }

    public int getMembersCount() {
        return this.multiUserChat.getOccupantsCount();
    }

    public String getName() {
        return this.multiUserChat.getRoom().toString();
    }

    public String getIdentifier() {
        return this.multiUserChat.getRoom().toString();
    }

    public EntityBareJid getIdentifierAsJid() {
        return this.multiUserChat.getRoom();
    }

    public String getUserNickname() {
        return this.multiUserChat.getNickname().toString();
    }

    public Contact getPrivateContactByNickname(String nickname) {
        OperationSetPersistentPresenceJabberImpl opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        EntityFullJid jid = null;
        try {
            jid = JidCreate.fullFrom((EntityBareJid)this.multiUserChat.getRoom(), (Resourcepart)Resourcepart.from((String)nickname));
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("Invalid XMPP nickname");
        }
        Object sourceContact = opSetPersPresence.findContactByID((Jid)jid);
        if (sourceContact == null) {
            sourceContact = opSetPersPresence.createVolatileContact((Jid)jid, true);
        }
        return sourceContact;
    }

    public String getSubject() {
        return this.multiUserChat.getSubject();
    }

    public void invite(String userAddress, String reason) {
        try {
            this.multiUserChat.invite(JidCreate.entityBareFrom((String)userAddress), reason);
        }
        catch (InterruptedException | SmackException.NotConnectedException | XmppStringprepException e) {
            logger.error((Object)("Could not invite " + userAddress), e);
        }
    }

    public boolean isJoined() {
        return this.multiUserChat.isJoined();
    }

    public void join(byte[] password) throws OperationFailedException {
        this.joinAs(JabberActivator.getGlobalDisplayDetailsService().getDisplayName(this.getParentProvider()), password);
    }

    public void join() throws OperationFailedException {
        this.joinAs(JabberActivator.getGlobalDisplayDetailsService().getDisplayName(this.getParentProvider()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinAs(String nickname, byte[] password) throws OperationFailedException {
        this.assertConnected();
        try {
            this.nickname = Resourcepart.from((String)nickname);
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException("Nickname is empty", 0, (Throwable)e);
        }
        try {
            if (this.multiUserChat.isJoined()) {
                if (!this.multiUserChat.getNickname().equals((Object)this.nickname)) {
                    this.multiUserChat.changeNickname(this.nickname);
                }
            } else {
                this.presenceListener = new ChatRoomPresenceListener((ChatRoom)this);
                this.provider.getConnection().addAsyncStanzaListener((StanzaListener)this.presenceListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{FromMatchesFilter.create((Jid)this.multiUserChat.getRoom()), new StanzaTypeFilter(Presence.class)}));
                if (password == null) {
                    this.multiUserChat.join(this.nickname);
                } else {
                    this.multiUserChat.join(this.nickname, new String(password));
                }
            }
            ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(this, this.nickname, (Jid)JidCreate.bareFrom((String)this.provider.getAccountID().getAccountAddress()));
            Hashtable<Resourcepart, ChatRoomMemberJabberImpl> hashtable = this.members;
            synchronized (hashtable) {
                this.members.put(this.nickname, member);
            }
            this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)this, "LocalUserJoined", null);
        }
        catch (XMPPException.XMPPErrorException ex) {
            if (ex.getXMPPError() == null) {
                String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 1, (Throwable)ex);
            }
            if (ex.getXMPPError().getCondition() == XMPPError.Condition.not_authorized) {
                String errorMessage = "Failed to join chat room " + this.getName() + " with nickname: " + nickname + ". The chat room requests a password.";
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 401, (Throwable)ex);
            }
            if (ex.getXMPPError().getCondition() == XMPPError.Condition.registration_required) {
                String errorMessage = "Failed to join chat room " + this.getName() + " with nickname: " + nickname + ". The chat room requires registration.";
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 13, (Throwable)ex);
            }
            String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
            logger.error((Object)errorMessage, (Throwable)ex);
            throw new OperationFailedException(errorMessage, 1, (Throwable)ex);
        }
        catch (Throwable ex) {
            String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
            logger.error((Object)errorMessage, ex);
            throw new OperationFailedException(errorMessage, 1, ex);
        }
    }

    public void joinAs(String nickname) throws OperationFailedException {
        this.joinAs(nickname, null);
    }

    public static ChatRoomMemberRole smackRoleToScRole(MUCRole smackRole, MUCAffiliation affiliation) {
        if (affiliation != null) {
            if (affiliation == MUCAffiliation.admin) {
                return ChatRoomMemberRole.ADMINISTRATOR;
            }
            if (affiliation == MUCAffiliation.owner) {
                return ChatRoomMemberRole.OWNER;
            }
        }
        if (smackRole != null) {
            if (smackRole == MUCRole.moderator) {
                return ChatRoomMemberRole.MODERATOR;
            }
            if (smackRole == MUCRole.participant) {
                return ChatRoomMemberRole.MEMBER;
            }
        }
        return ChatRoomMemberRole.GUEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomMemberJabberImpl smackParticipantToScMember(Jid participant) {
        if (participant == null) {
            return null;
        }
        Resourcepart participantName = participant.getResourceOrThrow();
        Hashtable<Resourcepart, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            for (ChatRoomMemberJabberImpl member : this.members.values()) {
                if (!participantName.equals((Object)member.getName()) && !participant.equals(member.getContactAddress()) && !participantName.equals((Object)member.getContactAddress())) continue;
                return member;
            }
        }
        return null;
    }

    public boolean destroy(String reason, String alternateAddress) {
        EntityBareJid alternateJid = null;
        try {
            alternateJid = JidCreate.entityBareFrom((String)alternateAddress);
        }
        catch (XmppStringprepException e) {
            logger.warn((Object)"Alternate address is not valid, ignoring", (Throwable)e);
        }
        try {
            this.multiUserChat.destroy(reason, alternateJid);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
            logger.warn((Object)"Error occured while destroying chat room", e);
            return false;
        }
        return true;
    }

    public void leave() {
        this.leave(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave(String reason, EntityBareJid alternateAddress) {
        Hashtable<Resourcepart, ChatRoomMemberJabberImpl> membersCopy;
        ArrayList<CallJabberImpl> tmpConferenceCalls;
        Object callid;
        OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)this.provider.getOperationSet(OperationSetBasicTelephony.class);
        if (basicTelephony != null && this.publishedConference != null) {
            ActiveCallsRepositoryJabberImpl activeRepository = basicTelephony.getActiveCallsRepository();
            callid = this.publishedConference.getCallId();
            if (callid != null) {
                CallJabberImpl call = activeRepository.findCallId((String)callid);
                for (CallPeerJabberImpl callPeerJabberImpl : call.getCallPeerList()) {
                    try {
                        callPeerJabberImpl.hangup(false, null, null);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException e) {
                        logger.error((Object)("Could not hangup peer " + callPeerJabberImpl.getAddress()), e);
                    }
                }
            }
        }
        callid = this.chatRoomConferenceCalls;
        synchronized (callid) {
            tmpConferenceCalls = new ArrayList<CallJabberImpl>(this.chatRoomConferenceCalls);
            this.chatRoomConferenceCalls.clear();
        }
        for (CallJabberImpl call : tmpConferenceCalls) {
            for (CallPeerJabberImpl callPeerJabberImpl : call.getCallPeerList()) {
                try {
                    callPeerJabberImpl.hangup(false, null, null);
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    logger.error((Object)("Could not hangup peer " + callPeerJabberImpl.getAddress()), e);
                }
            }
        }
        this.clearCachedConferenceDescriptionList();
        XMPPConnection connection = this.provider.getConnection();
        try {
            if (connection != null) {
                this.multiUserChat.leave();
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Error occured while leaving, maybe just disconnected before leaving", e);
        }
        Iterator<ChatRoomMemberJabberImpl> iterator = this.members;
        synchronized (iterator) {
            membersCopy = new Hashtable<Resourcepart, ChatRoomMemberJabberImpl>(this.members);
            this.members.clear();
        }
        for (ChatRoomMember chatRoomMember : membersCopy.values()) {
            this.fireMemberPresenceEvent(chatRoomMember, "MemberLeft", "Local user has left the chat room.");
        }
        if (connection != null) {
            connection.removeAsyncStanzaListener((StanzaListener)this.invitationRejectionListeners);
            if (this.presenceListener != null) {
                connection.removeAsyncStanzaListener((StanzaListener)this.presenceListener);
                this.presenceListener = null;
            }
        }
        this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)this, "LocalUserLeft", reason, alternateAddress != null ? alternateAddress.toString() : null);
    }

    private void sendMessage(Message msg) throws OperationFailedException {
        try {
            this.assertConnected();
            msg.setType(Message.Type.groupchat);
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            this.multiUserChat.sendMessage(msg);
        }
        catch (InterruptedException | SmackException.NotConnectedException ex) {
            throw new OperationFailedException("Failed to send message " + msg.toString(), 1, ex);
        }
    }

    public void sendMessage(net.java.sip.communicator.service.protocol.Message message) throws OperationFailedException {
        Message msg = new Message();
        msg.setBody(message.getContent());
        this.sendMessage(msg);
    }

    public void sendJsonMessage(String json) throws OperationFailedException {
        Message msg = new Message();
        msg.addExtension((ExtensionElement)new JsonMessageExtension(json));
        this.sendMessage(msg);
    }

    public void setSubject(String subject) throws OperationFailedException {
        try {
            this.multiUserChat.changeSubject(subject);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException ex) {
            logger.error((Object)("Failed to change subject for chat room" + this.getName()), ex);
            throw new OperationFailedException("Failed to changed subject for chat room" + this.getName(), 403, ex);
        }
    }

    public ProtocolProviderService getParentProvider() {
        return this.provider;
    }

    public ChatRoomMemberRole getUserRole() {
        if (this.role == null) {
            if (this.multiUserChat.getNickname() == null) {
                return ChatRoomMemberRole.GUEST;
            }
            Occupant o = this.multiUserChat.getOccupant(JidCreate.entityFullFrom((EntityBareJid)this.multiUserChat.getRoom(), (Resourcepart)this.multiUserChat.getNickname()));
            if (o == null) {
                return ChatRoomMemberRole.GUEST;
            }
            this.role = ChatRoomJabberImpl.smackRoleToScRole(o.getRole(), o.getAffiliation());
        }
        return this.role;
    }

    public void setLocalUserRole(ChatRoomMemberRole role) {
        this.setLocalUserRole(role, false);
    }

    public void setLocalUserRole(ChatRoomMemberRole role, boolean isInitial) {
        this.fireLocalUserRoleEvent(this.getUserRole(), role, isInitial);
        this.role = role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            if (!this.localUserRoleListeners.contains(listener)) {
                this.localUserRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            this.localUserRoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            if (!this.memberRoleListeners.contains(listener)) {
                this.memberRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            this.memberRoleListeners.remove(listener);
        }
    }

    public Iterator<ChatRoomMember> getBanList() throws OperationFailedException {
        return this.banList.values().iterator();
    }

    public void setUserNickname(String nickname) throws OperationFailedException {
        try {
            Resourcepart resourceNick = Resourcepart.from((String)nickname);
            this.multiUserChat.changeNickname(resourceNick);
            this.nickname = resourceNick;
        }
        catch (XMPPException e) {
            logger.error((Object)("Failed to change nickname for chat room: " + this.getName()));
            throw new OperationFailedException("The " + nickname + "already exists in this chat room.", 10);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | MultiUserChatException.MucNotJoinedException | XmppStringprepException e) {
            logger.error((Object)("Failed to change nickname for chat room: " + this.getName()));
            throw new OperationFailedException("Nickname change error", 0, e);
        }
    }

    public void banParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
        try {
            Jid jid = ((ChatRoomMemberJabberImpl)chatRoomMember).getJabberID();
            this.multiUserChat.banUser(jid, reason);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.not_allowed) {
                throw new OperationFailedException("Kicking an admin user or a chat room owner is a forbidden operation.", 403);
            }
            logger.error((Object)"Failed to ban participant.", (Throwable)e);
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            logger.error((Object)"Failed to ban participant.", e);
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
    }

    public void kickParticipant(ChatRoomMember member, String reason) throws OperationFailedException {
        try {
            Resourcepart nick = ((ChatRoomMemberJabberImpl)member).getNameAsResourcepart();
            this.multiUserChat.kickParticipant(nick, reason);
        }
        catch (XMPPException.XMPPErrorException e) {
            logger.error((Object)"Failed to kick participant.", (Throwable)e);
            if (e.getXMPPError().getCondition() == XMPPError.Condition.not_allowed) {
                throw new OperationFailedException("Kicking an admin user or a chat room owner is a forbidden operation.", 403);
            }
            if (e.getXMPPError().getCondition() == XMPPError.Condition.forbidden) {
                throw new OperationFailedException("The user that intended to kick another participant does not have enough privileges to do that.", 12);
            }
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            logger.error((Object)"Failed to kick participant.", e);
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberPresenceEvent(ChatRoomMember member, String eventID, String eventReason) {
        ChatRoomMemberPresenceChangeEvent evt = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, eventID, eventReason);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Iterator<ChatRoomMemberPresenceListener> listeners = null;
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPresenceListener>(this.memberListeners).iterator();
        }
        while (listeners.hasNext()) {
            ChatRoomMemberPresenceListener listener = listeners.next();
            listener.memberPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberPresenceEvent(ChatRoomMember member, ChatRoomMember actor, String eventID, String eventReason) {
        ArrayList<ChatRoomMemberPresenceListener> listeners;
        ChatRoomMemberPresenceChangeEvent evt = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, actor, eventID, eventReason);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPresenceListener>(this.memberListeners);
        }
        for (ChatRoomMemberPresenceListener listener : listeners) {
            listener.memberPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberRoleEvent(ChatRoomMember member, ChatRoomMemberRole previousRole, ChatRoomMemberRole newRole) {
        ArrayList<ChatRoomMemberRoleListener> listeners;
        member.setRole(newRole);
        ChatRoomMemberRoleChangeEvent evt = new ChatRoomMemberRoleChangeEvent((ChatRoom)this, member, previousRole, newRole);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberRoleListener>(this.memberRoleListeners);
        }
        for (ChatRoomMemberRoleListener listener : listeners) {
            listener.memberRoleChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessageEvent(EventObject evt) {
        ArrayList<ChatRoomMessageListener> listeners;
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMessageListener>(this.messageListeners);
        }
        for (ChatRoomMessageListener listener : listeners) {
            try {
                if (evt instanceof ChatRoomMessageDeliveredEvent) {
                    listener.messageDelivered((ChatRoomMessageDeliveredEvent)evt);
                    continue;
                }
                if (evt instanceof ChatRoomMessageReceivedEvent) {
                    listener.messageReceived((ChatRoomMessageReceivedEvent)evt);
                    continue;
                }
                if (!(evt instanceof ChatRoomMessageDeliveryFailedEvent)) continue;
                listener.messageDeliveryFailed((ChatRoomMessageDeliveryFailedEvent)evt);
            }
            catch (Throwable e) {
                logger.error((Object)("Error delivering multi chat message for " + listener), e);
            }
        }
    }

    public ConferenceDescription publishConference(ConferenceDescription cd, String name) {
        if (this.publishedConference != null) {
            cd = this.publishedConference;
            cd.setAvailable(false);
        } else {
            String displayName = name == null ? JabberActivator.getResources().getI18NString("service.gui.CHAT_CONFERENCE_ITEM_LABEL", new String[]{this.nickname.toString()}) : name;
            cd.setDisplayName(displayName);
        }
        ConferenceDescriptionExtension ext = new ConferenceDescriptionExtension(cd.getUri(), cd.getUri(), cd.getPassword());
        if (this.lastPresenceSent != null) {
            ChatRoomJabberImpl.setPacketExtension((Stanza)this.lastPresenceSent, (ExtensionElement)ext, "http://jitsi.org/protocol/condesc");
            try {
                this.provider.getConnection().sendStanza((Stanza)this.lastPresenceSent);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                logger.warn((Object)"Could not publish conference", e);
                return null;
            }
        } else {
            logger.warn((Object)"Could not publish conference, lastPresenceSent is null.");
            this.publishedConference = null;
            this.publishedConferenceExt = null;
            return null;
        }
        this.publishedConference = cd == null || !cd.isAvailable() ? null : cd;
        this.publishedConferenceExt = this.publishedConference == null ? null : ext;
        this.fireConferencePublishedEvent((ChatRoomMember)this.members.get(this.nickname), cd, 0);
        return cd;
    }

    private static void setPacketExtension(Stanza packet, ExtensionElement extension, String namespace, boolean matchElementName) {
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            return;
        }
        if (matchElementName && extension != null) {
            ExtensionElement pe;
            String element = extension.getElementName();
            while (null != (pe = packet.getExtension(element, namespace))) {
                packet.removeExtension(pe);
            }
        } else {
            ExtensionElement pe;
            while (null != (pe = packet.getExtension(namespace))) {
                packet.removeExtension(pe);
            }
        }
        if (extension != null) {
            packet.addExtension(extension);
        }
    }

    private static void setPacketExtension(Stanza packet, ExtensionElement extension, String namespace) {
        ChatRoomJabberImpl.setPacketExtension(packet, extension, namespace, false);
    }

    public void publishPresenceStatus(String newStatus) {
        if (this.lastPresenceSent == null) {
            return;
        }
        this.lastPresenceSent.setStatus(newStatus);
        try {
            this.provider.getConnection().sendStanza((Stanza)this.lastPresenceSent);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            logger.error((Object)"Could not publish presence", e);
        }
    }

    public void sendPresenceExtension(ExtensionElement extension) {
        if (this.lastPresenceSent == null) {
            return;
        }
        ChatRoomJabberImpl.setPacketExtension((Stanza)this.lastPresenceSent, extension, extension.getNamespace(), true);
        try {
            this.provider.getConnection().sendStanza((Stanza)this.lastPresenceSent);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            logger.error((Object)"Could not send presence", e);
        }
    }

    public void removePresenceExtension(ExtensionElement extension) {
        if (this.lastPresenceSent == null) {
            return;
        }
        ChatRoomJabberImpl.setPacketExtension((Stanza)this.lastPresenceSent, null, extension.getNamespace());
        try {
            this.provider.getConnection().sendStanza((Stanza)this.lastPresenceSent);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            logger.error((Object)"Could not remove presence", e);
        }
    }

    public List<String> getMembersWhiteList() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            for (Affiliate a : this.multiUserChat.getMembers()) {
                res.add(a.getJid().toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot obtain members list", (Throwable)e);
        }
        return res;
    }

    public void setMembersWhiteList(List<String> members) {
        try {
            for (Affiliate a : this.multiUserChat.getMembers()) {
                if (members.contains(a.getJid().toString())) continue;
                this.multiUserChat.revokeMembership(a.getJid());
            }
            for (String m : members) {
                this.multiUserChat.grantMembership(JidCreate.from((String)m));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot modify members list", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalUserRoleEvent(ChatRoomMemberRole previousRole, ChatRoomMemberRole newRole, boolean isInitial) {
        ArrayList<ChatRoomLocalUserRoleListener> listeners;
        ChatRoomLocalUserRoleChangeEvent evt = new ChatRoomLocalUserRoleChangeEvent((ChatRoom)this, previousRole, newRole, isInitial);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomLocalUserRoleListener>(this.localUserRoleListeners);
        }
        for (ChatRoomLocalUserRoleListener listener : listeners) {
            listener.localUserRoleChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeEvent(PropertyChangeEvent evt) {
        ArrayList<ChatRoomPropertyChangeListener> listeners;
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomPropertyChangeListener>(this.propertyChangeListeners);
        }
        for (ChatRoomPropertyChangeListener listener : listeners) {
            if (evt instanceof ChatRoomPropertyChangeEvent) {
                listener.chatRoomPropertyChanged((ChatRoomPropertyChangeEvent)evt);
                continue;
            }
            if (!(evt instanceof ChatRoomPropertyChangeFailedEvent)) continue;
            listener.chatRoomPropertyChangeFailed((ChatRoomPropertyChangeFailedEvent)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMemberPropertyChangeEvent(ChatRoomMemberPropertyChangeEvent evt) {
        ArrayList<ChatRoomMemberPropertyChangeListener> listeners;
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPropertyChangeListener>(this.memberPropChangeListeners);
        }
        for (ChatRoomMemberPropertyChangeListener listener : listeners) {
            listener.chatRoomPropertyChanged(evt);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.provider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.provider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException {
        Form smackConfigForm = null;
        try {
            smackConfigForm = this.multiUserChat.getConfigurationForm();
            this.configForm = new ChatRoomConfigurationFormJabberImpl(this.multiUserChat, smackConfigForm);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.forbidden) {
                throw new OperationFailedException("Failed to obtain smack multi user chat config form.User doesn't have enough privileges to see the form.", 12, (Throwable)e);
            }
            throw new OperationFailedException("Failed to obtain smack multi user chat config form.", 1, (Throwable)e);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Failed to obtain smack multi user chat config form.", 1, e);
        }
        return this.configForm;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isPersistent() {
        boolean persistent = false;
        EntityBareJid roomName = this.multiUserChat.getRoom();
        try {
            DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.provider.getConnection()).discoverInfo((Jid)roomName);
            if (info != null) {
                persistent = info.containsFeature((CharSequence)"muc_persistent");
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("could not get persistent state for room :" + roomName + "\n"), (Throwable)ex);
        }
        return persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomMemberJabberImpl findMemberForNickName(Resourcepart jabberID) {
        Hashtable<Resourcepart, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            return this.members.get(jabberID);
        }
    }

    public void grantAdmin(String jid) {
        try {
            this.multiUserChat.grantAdmin(JidCreate.from((String)jid));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs granting administrator privileges to a user.", ex);
        }
    }

    public void grantMembership(String jid) {
        try {
            this.multiUserChat.grantMembership(JidCreate.from((String)jid));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs granting membership to a user", ex);
        }
    }

    public void grantModerator(String nickname) {
        try {
            this.multiUserChat.grantModerator(Resourcepart.from((String)nickname));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs granting moderator privileges to a user", ex);
        }
    }

    public void grantOwnership(String jid) {
        try {
            this.multiUserChat.grantOwnership(JidCreate.from((String)jid));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs granting ownership privileges to a user", ex);
        }
    }

    public void grantVoice(String nickname) {
        try {
            this.multiUserChat.grantVoice(Resourcepart.from((String)nickname));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs granting voice to a visitor", ex);
        }
    }

    public void revokeAdmin(String jid) {
        try {
            this.multiUserChat.revokeAdmin(JidCreate.from((String)jid).asEntityJidOrThrow());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"n error occurs revoking administrator privileges to a user", ex);
        }
    }

    public void revokeMembership(String jid) {
        try {
            this.multiUserChat.revokeMembership(JidCreate.from((String)jid));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs revoking membership to a user", ex);
        }
    }

    public void revokeModerator(String nickname) {
        try {
            this.multiUserChat.revokeModerator(Resourcepart.from((String)nickname));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"n error occurs revoking moderator privileges from a user", ex);
        }
    }

    public void revokeOwnership(String jid) {
        try {
            this.multiUserChat.revokeOwnership(JidCreate.from((String)jid));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.error((Object)"An error occurs revoking ownership privileges from a user", ex);
        }
    }

    public void revokeVoice(String nickname) {
        try {
            this.multiUserChat.revokeVoice(Resourcepart.from((String)nickname));
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException ex) {
            logger.info((Object)"An error occurs revoking voice from a participant", ex);
        }
    }

    MultiUserChat getMultiUserChat() {
        return this.multiUserChat;
    }

    public void updatePrivateContactPresenceStatus(String nickname) {
        ContactJabberImpl sourceContact;
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        try {
            sourceContact = (ContactJabberImpl)presenceOpSet.findContactByID(JidCreate.fullFrom((EntityBareJid)this.multiUserChat.getRoom(), (Resourcepart)Resourcepart.from((String)nickname)).toString());
        }
        catch (XmppStringprepException e) {
            logger.error((Object)("Invalid nickname: " + nickname), (Throwable)e);
            return;
        }
        this.updatePrivateContactPresenceStatus((Contact)sourceContact);
    }

    public void updatePrivateContactPresenceStatus(Contact contact) {
        Resourcepart nickname;
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (contact == null) {
            return;
        }
        PresenceStatus oldContactStatus = contact.getPresenceStatus();
        try {
            nickname = JidCreate.from((String)contact.getAddress()).getResourceOrThrow();
        }
        catch (XmppStringprepException e) {
            logger.error((Object)("Invalid contact address: " + contact.getAddress()));
            return;
        }
        boolean isOffline = !this.members.containsKey(nickname);
        JabberStatusEnum.JabberPresenceStatus offlineStatus = this.provider.getJabberStatusEnum().getStatus(isOffline ? "Offline" : "Available");
        ((ContactJabberImpl)contact).updatePresenceStatus((PresenceStatus)offlineStatus);
        presenceOpSet.fireContactPresenceStatusChangeEvent(contact, contact.getParentContactGroup(), oldContactStatus, (PresenceStatus)offlineStatus);
    }

    private class PresenceInterceptor
    implements PresenceListener {
        private PresenceInterceptor() {
        }

        public void processPresence(Presence packet) {
            ChatRoomJabberImpl.setPacketExtension((Stanza)packet, (ExtensionElement)ChatRoomJabberImpl.this.publishedConferenceExt, "http://jitsi.org/protocol/condesc");
            ChatRoomJabberImpl.this.lastPresenceSent = packet;
        }
    }

    private class InvitationRejectionListeners
    implements StanzaListener {
        private InvitationRejectionListeners() {
        }

        public void processStanza(Stanza packet) {
            MUCUser mucUser = ChatRoomJabberImpl.this.getMUCUserExtension(packet);
            if (mucUser != null && mucUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                Contact c;
                int messageReceivedEventType = 3;
                ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, Resourcepart.EMPTY, (Jid)ChatRoomJabberImpl.this.multiUserChat.getRoom());
                EntityBareJid from = mucUser.getDecline().getFrom();
                String contactDisplayName = from.toString();
                OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)ChatRoomJabberImpl.this.provider.getOperationSet(OperationSetPersistentPresence.class);
                if (presenceOpSet != null && (c = presenceOpSet.findContactByID((Jid)from.asBareJid())) != null) {
                    contactDisplayName = c.getDisplayName() + " (" + from + ")";
                }
                String msgBody = JabberActivator.getResources().getI18NString("service.gui.INVITATION_REJECTED", new String[]{contactDisplayName, mucUser.getDecline().getReason()});
                ChatRoomMessageReceivedEvent msgReceivedEvt = new ChatRoomMessageReceivedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, new Date(), ChatRoomJabberImpl.this.createMessage(msgBody), messageReceivedEventType);
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
            }
        }
    }

    private class ChatRoomPresenceListener
    implements StanzaListener {
        private ChatRoom chatRoom;

        public ChatRoomPresenceListener(ChatRoom chatRoom) {
            this.chatRoom = chatRoom;
        }

        public void processStanza(Stanza packet) {
            if (packet == null || !(packet instanceof Presence) || packet.getError() != null) {
                logger.warn((Object)("Unable to handle packet: " + packet));
                return;
            }
            Presence presence = (Presence)packet;
            if (MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF.accept((Stanza)presence)) {
                this.processOwnPresence(presence);
            } else {
                this.processOtherPresence(presence);
            }
        }

        private void processOwnPresence(Presence presence) {
            MUCUser mucUser = ChatRoomJabberImpl.this.getMUCUserExtension((Stanza)presence);
            if (mucUser != null) {
                MUCAffiliation affiliation = mucUser.getItem().getAffiliation();
                MUCRole role = mucUser.getItem().getRole();
                if (mucUser.getStatus().contains(MUCUser.Status.ROOM_CREATED_201)) {
                    try {
                        ChatRoomJabberImpl.this.multiUserChat.sendConfigurationForm(new Form(DataForm.Type.submit));
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                        logger.error((Object)"Failed to send config form.", e);
                    }
                    ChatRoomJabberImpl.this.opSetMuc.addSmackInvitationRejectionListener(ChatRoomJabberImpl.this.multiUserChat, this.chatRoom);
                    if (affiliation == MUCAffiliation.owner) {
                        ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.OWNER, true);
                    } else {
                        ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MODERATOR, true);
                    }
                } else {
                    ChatRoomMemberRole jitsiRole = ChatRoomJabberImpl.smackRoleToScRole(role, affiliation);
                    if (jitsiRole == ChatRoomMemberRole.MODERATOR || jitsiRole == ChatRoomMemberRole.OWNER || jitsiRole == ChatRoomMemberRole.ADMINISTRATOR) {
                        ChatRoomJabberImpl.this.setLocalUserRole(jitsiRole, true);
                    }
                    if (!presence.isAvailable() && affiliation == MUCAffiliation.none && role == MUCRole.none) {
                        Destroy destroy = mucUser.getDestroy();
                        if (destroy == null) {
                            ChatRoomJabberImpl.this.leave();
                        } else {
                            ChatRoomJabberImpl.this.leave(destroy.getReason(), destroy.getJid());
                        }
                    }
                }
            }
        }

        private void processOtherPresence(Presence presence) {
            StatsId statsId;
            AvatarUrl avatarUrl;
            Email emailExtension;
            Jid from = presence.getFrom();
            Resourcepart participantName = null;
            if (from != null) {
                participantName = from.getResourceOrNull();
            }
            ChatRoomMemberJabberImpl member = participantName == null ? null : (ChatRoomMemberJabberImpl)ChatRoomJabberImpl.this.members.get(participantName);
            ExtensionElement ext = presence.getExtension("conference", "http://jitsi.org/protocol/condesc");
            if (presence.isAvailable() && ext != null) {
                ConferenceDescriptionExtension cdExt = (ConferenceDescriptionExtension)ext;
                ConferenceDescription cd = new ConferenceDescription(cdExt.getUri(), cdExt.getCallId(), cdExt.getPassword());
                cd.setAvailable(cdExt.isAvailable());
                cd.setDisplayName(ChatRoomJabberImpl.this.getName());
                for (TransportExtension t : cdExt.getChildExtensionsOfType(TransportExtension.class)) {
                    cd.addTransport(t.getNamespace());
                }
                if (!ChatRoomJabberImpl.this.processConferenceDescription(cd, participantName)) {
                    return;
                }
                if (member != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received " + cd + " from " + participantName + "in " + ChatRoomJabberImpl.this.multiUserChat.getRoom()));
                    }
                    ChatRoomJabberImpl.this.fireConferencePublishedEvent((ChatRoomMember)member, cd, 1);
                } else {
                    logger.warn((Object)("Received a ConferenceDescription from an unknown member (" + participantName + ") in " + ChatRoomJabberImpl.this.multiUserChat.getRoom()));
                }
            }
            if (member == null) {
                return;
            }
            Nick nickExtension = (Nick)presence.getExtension("nick", "http://jabber.org/protocol/nick");
            if (nickExtension != null) {
                member.setDisplayName(nickExtension.getName());
            }
            if ((emailExtension = (Email)presence.getExtension("email", "jabber:client")) != null) {
                member.setEmail(emailExtension.getAddress());
            }
            if ((avatarUrl = (AvatarUrl)presence.getExtension("avatar-url", "jabber:client")) != null) {
                member.setAvatarUrl(avatarUrl.getAvatarUrl());
            }
            if ((statsId = (StatsId)presence.getExtension("stats-id", "jabber:client")) != null) {
                member.setStatisticsID(statsId.getStatsId());
            }
            member.setLastPresence(presence);
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, "MemberUpdated", null);
        }
    }

    private class UserListener
    implements UserStatusListener {
        private UserListener() {
        }

        public void roomDestroyed(MultiUserChat multiUserChat, String s) {
            throw new UnsupportedOperationException();
        }

        public void kicked(Jid actor, String reason) {
            ChatRoomJabberImpl.this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)ChatRoomJabberImpl.this, "LocalUserKicked", reason);
            ChatRoomJabberImpl.this.leave();
        }

        public void voiceGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void voiceRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.SILENT_MEMBER);
        }

        public void banned(Jid actor, String reason) {
            ChatRoomJabberImpl.this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)ChatRoomJabberImpl.this, "LocalUserDropped", reason);
            ChatRoomJabberImpl.this.leave();
        }

        public void membershipGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void membershipRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.GUEST);
        }

        public void moderatorGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MODERATOR);
        }

        public void moderatorRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void ownershipGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.OWNER);
        }

        public void ownershipRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void adminGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.ADMINISTRATOR);
        }

        public void adminRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }
    }

    private class SmackSubjectUpdatedListener
    implements SubjectUpdatedListener {
        private SmackSubjectUpdatedListener() {
        }

        public void subjectUpdated(String subject, EntityFullJid from) {
            if (subject != null && !subject.equals(ChatRoomJabberImpl.this.oldSubject)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Subject updated to " + subject));
                }
                ChatRoomPropertyChangeEvent evt = new ChatRoomPropertyChangeEvent((ChatRoom)ChatRoomJabberImpl.this, "ChatRoomSubject", (Object)ChatRoomJabberImpl.this.oldSubject, (Object)subject);
                ChatRoomJabberImpl.this.firePropertyChangeEvent((PropertyChangeEvent)evt);
            }
            ChatRoomJabberImpl.this.oldSubject = subject;
        }
    }

    private class SmackMessageListener
    implements MessageListener {
        private Date lastSeenDelayedMessage = null;
        private static final String LAST_SEEN_DELAYED_MESSAGE_PROP = "lastSeenDelayedMessage";

        private SmackMessageListener() {
        }

        public void processMessage(Message msg) {
            Date timeStamp;
            DelayInformation delay = (DelayInformation)msg.getExtension("x", "jabber:x:delay");
            if (delay != null) {
                timeStamp = delay.getStamp();
                if (this.lastSeenDelayedMessage == null) {
                    String timestamp = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)ChatRoomJabberImpl.this.provider, (String)ChatRoomJabberImpl.this.getIdentifier(), (String)LAST_SEEN_DELAYED_MESSAGE_PROP);
                    try {
                        this.lastSeenDelayedMessage = new Date(Long.parseLong(timestamp));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.lastSeenDelayedMessage != null && !timeStamp.after(this.lastSeenDelayedMessage)) {
                    return;
                }
                ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)ChatRoomJabberImpl.this.provider, (String)ChatRoomJabberImpl.this.getIdentifier(), (String)LAST_SEEN_DELAYED_MESSAGE_PROP, (String)String.valueOf(timeStamp.getTime()));
                this.lastSeenDelayedMessage = timeStamp;
            } else {
                timeStamp = new Date();
            }
            String msgBody = msg.getBody();
            if (msgBody == null) {
                return;
            }
            int messageReceivedEventType = 1;
            Jid msgFrom = msg.getFrom();
            ChatRoomMemberJabberImpl member = null;
            EntityBareJid roomName = ChatRoomJabberImpl.this.multiUserChat.getRoom();
            if (msgFrom.equals((CharSequence)roomName)) {
                messageReceivedEventType = 3;
                member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, Resourcepart.EMPTY, (Jid)roomName);
            } else {
                member = ChatRoomJabberImpl.this.smackParticipantToScMember(msgFrom);
            }
            if (member == null) {
                member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, msgFrom.getResourceOrThrow(), msgFrom);
            }
            if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug((Object)("Received from " + msgFrom + " the message " + msg.toXML()));
            }
            net.java.sip.communicator.service.protocol.Message newMessage = ChatRoomJabberImpl.this.createMessage(msgBody);
            if (ChatRoomJabberImpl.this.multiUserChat.getNickname().equals((Object)msgFrom.getResourceOrThrow())) {
                ChatRoomMessageDeliveredEvent msgDeliveredEvt = new ChatRoomMessageDeliveredEvent((ChatRoom)ChatRoomJabberImpl.this, timeStamp, newMessage, 1);
                if (delay != null) {
                    msgDeliveredEvt.setHistoryMessage(true);
                }
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgDeliveredEvt);
                return;
            }
            if (msg.getType() == Message.Type.error) {
                MessageEvent msgEvent;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Message error received from " + msgFrom));
                }
                XMPPError error = msg.getError();
                XMPPError.Condition errorCode = error.getCondition();
                int errorResultCode = 1;
                String errorReason = error.getConditionText();
                if (errorCode == XMPPError.Condition.service_unavailable && (msgEvent = (MessageEvent)msg.getExtension("x", "jabber:x:event")) != null && msgEvent.isOffline()) {
                    errorResultCode = 5;
                }
                ChatRoomMessageDeliveryFailedEvent evt = new ChatRoomMessageDeliveryFailedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, errorResultCode, errorReason, new Date(), newMessage);
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)evt);
                return;
            }
            ChatRoomMessageReceivedEvent msgReceivedEvt = new ChatRoomMessageReceivedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, timeStamp, newMessage, messageReceivedEventType);
            if (delay != null) {
                msgReceivedEvt.setHistoryMessage(true);
            }
            if (messageReceivedEventType == 1 && newMessage.getContent().contains(ChatRoomJabberImpl.this.getUserNickname() + ":")) {
                msgReceivedEvt.setImportantMessage(true);
            }
            ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
        }
    }

    private class MemberListener
    implements ParticipantStatusListener {
        private MemberListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void banned(EntityFullJid participant, Jid actor, String reason) {
            ChatRoomMemberJabberImpl member;
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has been banned from " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            if ((member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant)) == null) {
                return;
            }
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participant.getResourceOrThrow());
            }
            ChatRoomJabberImpl.this.banList.put(participant.getResourceOrThrow(), member);
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.OUTCAST);
        }

        public void adminGranted(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.ADMINISTRATOR);
        }

        public void adminRevoked(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void joined(EntityFullJid participant) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has joined the " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            Resourcepart participantName = participant.getResourceOrThrow();
            if (ChatRoomJabberImpl.this.nickname.equals((Object)participantName) || ChatRoomJabberImpl.this.members.containsKey(participantName)) {
                return;
            }
            if (ChatRoomJabberImpl.this.members.contains(participantName)) {
                return;
            }
            Occupant occupant = ChatRoomJabberImpl.this.multiUserChat.getOccupant(participant);
            ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, occupant.getNick(), occupant.getJid());
            ChatRoomJabberImpl.this.members.put(participantName, member);
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, "MemberJoined", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void left(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member;
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has left the " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            if ((member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant)) == null) {
                return;
            }
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participant.getResourceOrThrow());
            }
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, "MemberLeft", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nicknameChanged(EntityFullJid participant, Resourcepart newNickname) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            member.setName(newNickname);
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomMemberJabberImpl mem = (ChatRoomMemberJabberImpl)ChatRoomJabberImpl.this.members.remove(participant.getResourceOrThrow());
                ChatRoomJabberImpl.this.members.put(newNickname, mem);
            }
            ChatRoomMemberPropertyChangeEvent evt = new ChatRoomMemberPropertyChangeEvent((ChatRoomMember)member, (ChatRoom)ChatRoomJabberImpl.this, "MemberNickname", (Object)participant.getResourceOrThrow(), (Object)newNickname);
            ChatRoomJabberImpl.this.fireMemberPropertyChangeEvent(evt);
        }

        public void ownershipRevoked(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kicked(EntityFullJid participant, Jid actor, String reason) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            ChatRoomMemberJabberImpl actorMember = ChatRoomJabberImpl.this.smackParticipantToScMember(actor);
            if (member == null) {
                return;
            }
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participant.getResourceOrThrow());
            }
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, (ChatRoomMember)actorMember, "MemberKicked", reason);
        }

        public void moderatorGranted(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MODERATOR);
        }

        public void voiceRevoked(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.SILENT_MEMBER);
        }

        public void membershipGranted(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void moderatorRevoked(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void voiceGranted(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void membershipRevoked(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.GUEST);
        }

        public void ownershipGranted(EntityFullJid participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember((Jid)participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.OWNER);
        }
    }
}

