/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ColibriStreamConnector;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAutoAnswerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetIncomingDTMFJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetIncomingDTMF;
import net.java.sip.communicator.service.protocol.event.DTMFReceivedEvent;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaHandler;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.StreamConnectorFactory;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.CoinPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JinglePacketFactory;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferPacketExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.Jid;

public class CallJabberImpl
extends MediaAwareCall<CallPeerJabberImpl, OperationSetBasicTelephonyJabberImpl, ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(CallJabberImpl.class);
    private ColibriConferenceIQ colibri;
    private MediaHandler colibriMediaHandler;
    private final List<WeakReference<ColibriStreamConnector>> colibriStreamConnectors;
    private Jid jitsiVideobridge;
    private boolean localInputEvtAware = false;

    protected CallJabberImpl(OperationSetBasicTelephonyJabberImpl parentOpSet) {
        super((OperationSetBasicTelephony)parentOpSet);
        int mediaTypeValueCount = MediaType.values().length;
        this.colibriStreamConnectors = new ArrayList<WeakReference<ColibriStreamConnector>>(mediaTypeValueCount);
        for (int i = 0; i < mediaTypeValueCount; ++i) {
            this.colibriStreamConnectors.add(null);
        }
        parentOpSet.getActiveCallsRepository().addCall((Call)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeColibriStreamConnector(CallPeerJabberImpl peer, MediaType mediaType, ColibriStreamConnector colibriStreamConnector) {
        colibriStreamConnector.close();
        List<WeakReference<ColibriStreamConnector>> list = this.colibriStreamConnectors;
        synchronized (list) {
            int index = mediaType.ordinal();
            WeakReference<ColibriStreamConnector> weakReference = this.colibriStreamConnectors.get(index);
            if (weakReference != null && ((Object)((Object)colibriStreamConnector)).equals(weakReference.get())) {
                this.colibriStreamConnectors.set(index, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        try {
            Iterator peers = this.getCallPeers();
            while (peers.hasNext()) {
                CallPeerJabberImpl callPeer = (CallPeerJabberImpl)((Object)peers.next());
                if (callPeer.getState() != CallPeerState.CONNECTED) continue;
                callPeer.sendCoinSessionInfo();
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException throwable) {
        }
        finally {
            super.conferenceFocusChanged(oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColibriConferenceIQ createColibriChannels(CallPeerJabberImpl peer, Map<ContentPacketExtension, ContentPacketExtension> contentMap) throws OperationFailedException {
        String colibriID;
        Stanza stanza;
        Jid jitsiVideobridge;
        if (!this.getConference().isJitsiVideobridge()) {
            return null;
        }
        CallPeerMediaHandlerJabberImpl peerMediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler();
        if (peerMediaHandler.getMediaHandler() != this.colibriMediaHandler) {
            for (MediaType mediaType : MediaType.values()) {
                if (peerMediaHandler.getStream(mediaType) == null) continue;
                return null;
            }
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        Jid jid = jitsiVideobridge = this.colibri == null ? this.getJitsiVideobridge() : this.colibri.getFrom();
        if (jitsiVideobridge == null || jitsiVideobridge.length() == 0) {
            logger.error((Object)"Failed to allocate colibri channels: no videobridge found.");
            return null;
        }
        if (this.colibriMediaHandler == null) {
            this.colibriMediaHandler = new MediaHandler();
        }
        peerMediaHandler.setMediaHandler(this.colibriMediaHandler);
        ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
        if (this.colibri != null) {
            conferenceRequest.setID(this.colibri.getID());
        }
        for (Map.Entry entry : contentMap.entrySet()) {
            ColibriConferenceIQ.Content content;
            ContentPacketExtension localContent = (ContentPacketExtension)entry.getKey();
            ContentPacketExtension remoteContent = (ContentPacketExtension)entry.getValue();
            ContentPacketExtension cpe = remoteContent == null ? localContent : remoteContent;
            RtpDescriptionPacketExtension rdpe = (RtpDescriptionPacketExtension)cpe.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            String string = rdpe.getMedia();
            MediaType mediaType = MediaType.parseString((String)string);
            String contentName = mediaType.toString();
            ColibriConferenceIQ.Content contentRequest = new ColibriConferenceIQ.Content(contentName);
            conferenceRequest.addContent(contentRequest);
            boolean requestLocalChannel = true;
            if (this.colibri != null && (content = this.colibri.getContent(contentName)) != null && content.getChannelCount() > 0) {
                requestLocalChannel = false;
            }
            boolean peerIsInitiator = peer.isInitiator();
            if (requestLocalChannel) {
                ColibriConferenceIQ.Channel localChannelRequest = new ColibriConferenceIQ.Channel();
                localChannelRequest.setEndpoint(protocolProvider.getOurJID().toString());
                localChannelRequest.setInitiator(Boolean.valueOf(peerIsInitiator));
                for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                    localChannelRequest.addPayloadType(ptpe);
                }
                this.setTransportOnChannel(peer, string, localChannelRequest);
                this.setDtlsEncryptionOnChannel(jitsiVideobridge, peer, mediaType, localChannelRequest);
                this.ensureTransportOnChannel(localChannelRequest, peer);
                contentRequest.addChannel(localChannelRequest);
            }
            ColibriConferenceIQ.Channel remoteChannelRequest = new ColibriConferenceIQ.Channel();
            remoteChannelRequest.setEndpoint(peer.getAddress());
            remoteChannelRequest.setInitiator(Boolean.valueOf(!peerIsInitiator));
            for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                remoteChannelRequest.addPayloadType(ptpe);
            }
            this.setTransportOnChannel(string, localContent, remoteContent, peer, remoteChannelRequest);
            this.setDtlsEncryptionOnChannel(mediaType, localContent, remoteContent, peer, remoteChannelRequest);
            this.ensureTransportOnChannel(remoteChannelRequest, peer);
            contentRequest.addChannel(remoteChannelRequest);
        }
        conferenceRequest.setTo(jitsiVideobridge);
        conferenceRequest.setType(IQ.Type.get);
        XMPPConnection connection = protocolProvider.getConnection();
        Object var8_11 = null;
        try {
            StanzaCollector packetCollector = connection.createStanzaCollectorAndSend((IQ)conferenceRequest);
            try {
                stanza = packetCollector.nextResultOrThrow();
            }
            finally {
                packetCollector.cancel();
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send the conference request", 0, e);
        }
        catch (SmackException.NoResponseException e) {
            logger.error((Object)"Failed to allocate colibri channels: response is null. Maybe the response timed out.");
            return null;
        }
        catch (XMPPException.XMPPErrorException e) {
            logger.error((Object)("Failed to allocate colibri channels: " + e.getXMPPError()));
            return null;
        }
        ColibriConferenceIQ conferenceResponse = (ColibriConferenceIQ)stanza;
        String conferenceResponseID = conferenceResponse.getID();
        if (this.colibri == null) {
            this.colibri = new ColibriConferenceIQ();
            this.colibri.setFrom(conferenceResponse.getFrom());
        }
        if ((colibriID = this.colibri.getID()) == null) {
            this.colibri.setID(conferenceResponseID);
        } else if (!colibriID.equals(conferenceResponseID)) {
            throw new IllegalStateException("conference.id");
        }
        for (ColibriConferenceIQ.Content content : conferenceResponse.getContents()) {
            String contentName = content.getName();
            ColibriConferenceIQ.Content content2 = this.colibri.getOrCreateContent(contentName);
            for (ColibriConferenceIQ.Channel channelResponse : content.getChannels()) {
                int channelIndex = content2.getChannelCount();
                content2.addChannel(channelResponse);
                if (channelIndex != 0) continue;
                TransportManagerJabberImpl transportManager = peerMediaHandler.getTransportManager();
                transportManager.isEstablishingConnectivityWithJitsiVideobridge = true;
                transportManager.startConnectivityEstablishmentWithJitsiVideobridge = true;
                MediaType mediaType = MediaType.parseString((String)contentName);
                this.addDtlsAdvertisedEncryptions(peer, channelResponse, mediaType);
            }
        }
        ColibriConferenceIQ conferenceResult = new ColibriConferenceIQ();
        conferenceResult.setFrom(this.colibri.getFrom());
        conferenceResult.setID(conferenceResponseID);
        for (Map.Entry entry : contentMap.entrySet()) {
            ContentPacketExtension localContent = (ContentPacketExtension)entry.getKey();
            ContentPacketExtension remoteContent = (ContentPacketExtension)entry.getValue();
            ContentPacketExtension cpe = remoteContent == null ? localContent : remoteContent;
            MediaType mediaType = JingleUtils.getMediaType(cpe);
            ColibriConferenceIQ.Content contentResponse = conferenceResponse.getContent(mediaType.toString());
            if (contentResponse == null) continue;
            String contentName = contentResponse.getName();
            ColibriConferenceIQ.Content contentResult = new ColibriConferenceIQ.Content(contentName);
            conferenceResult.addContent(contentResult);
            ColibriConferenceIQ.Content content = this.colibri.getContent(contentName);
            ColibriConferenceIQ.Channel localChannel = null;
            if (content != null && content.getChannelCount() > 0) {
                localChannel = content.getChannel(0);
                contentResult.addChannel(localChannel);
            }
            String localChannelID = localChannel == null ? null : localChannel.getID();
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                if (localChannelID != null && localChannelID.equals(channelResponse.getID())) continue;
                contentResult.addChannel(channelResponse);
            }
        }
        return conferenceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColibriStreamConnector createColibriStreamConnector(CallPeerJabberImpl peer, MediaType mediaType, ColibriConferenceIQ.Channel channel, StreamConnectorFactory factory) {
        ColibriStreamConnector colibriStreamConnector;
        String channelID = channel.getID();
        if (channelID == null) {
            throw new IllegalArgumentException("channel");
        }
        if (this.colibri == null) {
            throw new IllegalStateException("colibri");
        }
        ColibriConferenceIQ.Content content = this.colibri.getContent(mediaType.toString());
        if (content == null) {
            throw new IllegalArgumentException("mediaType");
        }
        if (content.getChannelCount() < 1 || !channelID.equals((channel = content.getChannel(0)).getID())) {
            throw new IllegalArgumentException("channel");
        }
        List<WeakReference<ColibriStreamConnector>> list = this.colibriStreamConnectors;
        synchronized (list) {
            StreamConnector streamConnector;
            int index = mediaType.ordinal();
            WeakReference<ColibriStreamConnector> weakReference = this.colibriStreamConnectors.get(index);
            ColibriStreamConnector colibriStreamConnector2 = colibriStreamConnector = weakReference == null ? null : (ColibriStreamConnector)((Object)weakReference.get());
            if (colibriStreamConnector == null && (streamConnector = factory.createStreamConnector()) != null) {
                colibriStreamConnector = new ColibriStreamConnector(streamConnector);
                this.colibriStreamConnectors.set(index, new WeakReference<ColibriStreamConnector>(colibriStreamConnector));
            }
        }
        return colibriStreamConnector;
    }

    public void expireColibriChannels(CallPeerJabberImpl peer, ColibriConferenceIQ conference) throws SmackException.NotConnectedException, InterruptedException {
        String conferenceID;
        if (this.colibri != null && (conferenceID = this.colibri.getID()).equals(conference.getID())) {
            ColibriConferenceIQ.Content colibriContent;
            ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
            conferenceRequest.setID(conferenceID);
            for (ColibriConferenceIQ.Content content : conference.getContents()) {
                colibriContent = this.colibri.getContent(content.getName());
                if (colibriContent == null) continue;
                ColibriConferenceIQ.Content contentRequest = conferenceRequest.getOrCreateContent(colibriContent.getName());
                for (ColibriConferenceIQ.Channel channel : content.getChannels()) {
                    ColibriConferenceIQ.Channel colibriChannel = colibriContent.getChannel(channel.getID());
                    if (colibriChannel == null) continue;
                    ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
                    channelRequest.setExpire(0);
                    channelRequest.setID(colibriChannel.getID());
                    contentRequest.addChannel(channelRequest);
                }
            }
            block2: for (ColibriConferenceIQ.Content contentRequest : conferenceRequest.getContents()) {
                colibriContent = this.colibri.getContent(contentRequest.getName());
                for (ColibriConferenceIQ.Channel channelRequest : contentRequest.getChannels()) {
                    ColibriConferenceIQ.Channel colibriChannel = colibriContent.getChannel(channelRequest.getID());
                    colibriContent.removeChannel(colibriChannel);
                    if (colibriContent.getChannelCount() != 1) continue;
                    colibriChannel = colibriContent.getChannel(0);
                    channelRequest = new ColibriConferenceIQ.Channel();
                    channelRequest.setExpire(0);
                    channelRequest.setID(colibriChannel.getID());
                    contentRequest.addChannel(channelRequest);
                    colibriContent.removeChannel(colibriChannel);
                    continue block2;
                }
            }
            conferenceRequest.setTo(this.colibri.getFrom());
            conferenceRequest.setType(IQ.Type.set);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)conferenceRequest);
        }
    }

    public void setChannelDirection(String channelID, MediaType mediaType, MediaDirection direction) throws SmackException.NotConnectedException, InterruptedException {
        ColibriConferenceIQ.Channel channel;
        ColibriConferenceIQ.Content content;
        if (this.colibri != null && channelID != null && (content = this.colibri.getContent(mediaType.toString())) != null && (channel = content.getChannel(channelID)) != null) {
            ColibriConferenceIQ.Channel requestChannel = new ColibriConferenceIQ.Channel();
            requestChannel.setID(channelID);
            requestChannel.setDirection(direction.toString());
            ColibriConferenceIQ.Content requestContent = new ColibriConferenceIQ.Content();
            requestContent.setName(mediaType.toString());
            requestContent.addChannel(requestChannel);
            ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
            conferenceRequest.setID(this.colibri.getID());
            conferenceRequest.setTo(this.colibri.getFrom());
            conferenceRequest.setType(IQ.Type.set);
            conferenceRequest.addContent(requestContent);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)conferenceRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallPeerJabberImpl initiateSession(Jid calleeJID, DiscoverInfo discoverInfo, Iterable<ExtensionElement> sessionInitiateExtensions, Collection<String> supportedTransports) throws OperationFailedException {
        CallPeerJabberImpl callPeer = new CallPeerJabberImpl(calleeJID, this);
        callPeer.setDiscoveryInfo(discoverInfo);
        this.addCallPeer(callPeer);
        callPeer.setState(CallPeerState.INITIATING_CALL);
        if (this.getCallPeerCount() == 1) {
            ((OperationSetBasicTelephonyJabberImpl)this.parentOpSet).fireCallEvent(1, (Call)this);
        }
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)callPeer.getMediaHandler();
        mediaHandler.setSupportedTransports(supportedTransports);
        mediaHandler.setLocalVideoTransmissionEnabled(this.localVideoAllowed);
        mediaHandler.setLocalInputEvtAware(this.getLocalInputEvtAware());
        callPeer.setState(CallPeerState.CONNECTING);
        boolean sessionInitiated = false;
        try {
            callPeer.initiateSession(sessionInitiateExtensions);
            sessionInitiated = true;
        }
        finally {
            if (!sessionInitiated) {
                callPeer.setState(CallPeerState.FAILED);
            }
        }
        return callPeer;
    }

    public void modifyVideoContent() throws OperationFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating video content for " + (Object)((Object)this)));
        }
        boolean change = false;
        for (CallPeerJabberImpl peer : this.getCallPeerList()) {
            try {
                change |= peer.sendModifyVideoContent();
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new OperationFailedException("Could send modify video content to " + peer.getAddress(), 0, e);
            }
        }
        if (change) {
            this.fireCallChangeEvent("CallParticipantsChanged", null, null);
        }
    }

    boolean processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        if (this.colibri == null) {
            return false;
        }
        if (conferenceIQ.getID().equals(this.colibri.getID())) {
            for (MediaType mediaType : MediaType.values()) {
                ColibriConferenceIQ.Channel thisChannel;
                ColibriConferenceIQ.Channel channel;
                ColibriConferenceIQ.Content thisContent;
                String contentName = mediaType.toString();
                ColibriConferenceIQ.Content content = conferenceIQ.getContent(contentName);
                if (content == null || (thisContent = this.colibri.getContent(contentName)) == null || thisContent.getChannelCount() <= 0 || (channel = content.getChannel((thisChannel = thisContent.getChannel(0)).getID())) == null) continue;
                content.removeChannel(channel);
            }
            for (CallPeerJabberImpl callPeer : this.getCallPeerList()) {
                callPeer.processColibriConferenceIQ(conferenceIQ);
            }
            return true;
        }
        return false;
    }

    public CallPeerJabberImpl processSessionInitiate(JingleIQ jingleIQ) {
        OperationSetAutoAnswerJabberImpl autoAnswerOpSet;
        CallPeerJabberImpl callPeer;
        OperationSetBasicTelephonyJabberImpl basicTelephony;
        CallPeerJabberImpl attendant;
        boolean autoAnswer;
        block19: {
            Jid remoteParty = jingleIQ.getFrom();
            autoAnswer = false;
            attendant = null;
            basicTelephony = null;
            callPeer = new CallPeerJabberImpl(remoteParty, this, jingleIQ);
            this.addCallPeer(callPeer);
            try {
                ProtocolProviderServiceJabberImpl protocolProvider;
                CallJabberImpl attendantCall;
                String sid;
                TransferPacketExtension transfer = (TransferPacketExtension)jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
                if (transfer != null && (sid = transfer.getSID()) != null && (attendantCall = (basicTelephony = (OperationSetBasicTelephonyJabberImpl)(protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicTelephony.class)).getActiveCallsRepository().findSID(sid)) != null && (attendant = attendantCall.getPeer(sid)) != null && basicTelephony.getFullCalleeURI(attendant.getAddress()).equals((CharSequence)transfer.getFrom()) && protocolProvider.getOurJID().equals((CharSequence)transfer.getTo())) {
                    autoAnswer = true;
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Failed to hang up on attendant as part of session transfer", t);
                if (!(t instanceof ThreadDeath)) break block19;
                throw (ThreadDeath)t;
            }
        }
        CoinPacketExtension coin = (CoinPacketExtension)jingleIQ.getExtension("conference-info", "urn:xmpp:coin:1");
        if (coin != null) {
            boolean b = Boolean.parseBoolean((String)coin.getAttribute("isfocus"));
            callPeer.setConferenceFocus(b);
        }
        try {
            callPeer.processSessionInitiate(jingleIQ);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            callPeer.setState(CallPeerState.INCOMING_CALL);
            return null;
        }
        if (((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getAccountID().getAccountPropertyBoolean((Object)"MODE_PARANOIA", false) && ((CallPeerMediaHandlerJabberImpl)callPeer.getMediaHandler()).getAdvertisedEncryptionMethods().length == 0) {
            String reasonText = JabberActivator.getResources().getI18NString("service.gui.security.encryption.required");
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)jingleIQ.getTo(), (Jid)jingleIQ.getFrom(), (String)jingleIQ.getSID(), (Reason)Reason.SECURITY_ERROR, (String)reasonText);
            callPeer.setState(CallPeerState.FAILED, reasonText);
            try {
                ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                logger.error((Object)"Could not send session terminate", e);
                return null;
            }
            return null;
        }
        if (callPeer.getState() == CallPeerState.FAILED) {
            return null;
        }
        callPeer.setState(CallPeerState.INCOMING_CALL);
        if (autoAnswer) {
            try {
                callPeer.answer();
            }
            catch (Exception e) {
                logger.info((Object)"Exception occurred while answer transferred call", (Throwable)e);
                callPeer = null;
            }
            try {
                basicTelephony.hangupCallPeer((CallPeer)attendant);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"Failed to hang up on attendant as part of session transfer", (Throwable)e);
            }
            return callPeer;
        }
        List offer = callPeer.getSessionIQ().getContentList();
        HashMap<MediaType, MediaDirection> directions = new HashMap<MediaType, MediaDirection>();
        directions.put(MediaType.AUDIO, MediaDirection.INACTIVE);
        directions.put(MediaType.VIDEO, MediaDirection.INACTIVE);
        for (ContentPacketExtension c : offer) {
            String contentName = c.getName();
            MediaDirection remoteDirection = JingleUtils.getDirection(c, callPeer.isInitiator());
            if (MediaType.AUDIO.toString().equals(contentName)) {
                directions.put(MediaType.AUDIO, remoteDirection);
                continue;
            }
            if (!MediaType.VIDEO.toString().equals(contentName)) continue;
            directions.put(MediaType.VIDEO, remoteDirection);
        }
        if (this.getCallPeerCount() == 1) {
            ((OperationSetBasicTelephonyJabberImpl)this.parentOpSet).fireCallEvent(2, (Call)this, directions);
        }
        if ((autoAnswerOpSet = (OperationSetAutoAnswerJabberImpl)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicAutoAnswer.class)) != null) {
            autoAnswerOpSet.autoAnswer((Call)this, directions);
        }
        return callPeer;
    }

    private boolean addDtlsAdvertisedEncryptions(CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel, MediaType mediaType) {
        CallPeerMediaHandlerJabberImpl peerMediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler();
        DtlsControl dtlsControl = (DtlsControl)peerMediaHandler.getSrtpControls().get(mediaType, SrtpControlType.DTLS_SRTP);
        if (dtlsControl != null) {
            dtlsControl.setSetup(peer.isInitiator() ? DtlsControl.Setup.ACTIVE : DtlsControl.Setup.PASSIVE);
        }
        IceUdpTransportPacketExtension remoteTransport = channel.getTransport();
        return peerMediaHandler.addDtlsAdvertisedEncryptions(true, remoteTransport, mediaType, false);
    }

    private void setDtlsEncryptionOnChannel(MediaType mediaType, ContentPacketExtension localContent, ContentPacketExtension remoteContent, CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel) {
        List localFingerprints;
        IceUdpTransportPacketExtension localTransport;
        List remoteFingerprints;
        IceUdpTransportPacketExtension remoteTransport;
        AccountID accountID = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getAccountID();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.DTLS_SRTP) && remoteContent != null && (remoteTransport = (IceUdpTransportPacketExtension)remoteContent.getFirstChildOfType(IceUdpTransportPacketExtension.class)) != null && !(remoteFingerprints = remoteTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty() && (localTransport = this.ensureTransportOnChannel(channel, peer)) != null && (localFingerprints = localTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty()) {
            for (DtlsFingerprintPacketExtension remoteFingerprint : remoteFingerprints) {
                DtlsFingerprintPacketExtension localFingerprint = new DtlsFingerprintPacketExtension();
                localFingerprint.setFingerprint(remoteFingerprint.getFingerprint());
                localFingerprint.setHash(remoteFingerprint.getHash());
                localTransport.addChildExtension((ExtensionElement)localFingerprint);
            }
        }
    }

    private void setDtlsEncryptionOnChannel(Jid jitsiVideobridge, CallPeerJabberImpl peer, MediaType mediaType, ColibriConferenceIQ.Channel channel) {
        IceUdpTransportPacketExtension transport;
        CallPeerMediaHandlerJabberImpl mediaHandler;
        DtlsControl dtlsControl;
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        AccountID accountID = protocolProvider.getAccountID();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.DTLS_SRTP) && protocolProvider.isFeatureSupported(jitsiVideobridge, "urn:xmpp:jingle:apps:dtls:0") && (dtlsControl = (DtlsControl)(mediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getSrtpControls().getOrCreate(mediaType, SrtpControlType.DTLS_SRTP)) != null && (transport = this.ensureTransportOnChannel(channel, peer)) != null) {
            CallJabberImpl.setDtlsEncryptionOnTransport(dtlsControl, transport);
        }
    }

    static void setDtlsEncryptionOnTransport(DtlsControl dtlsControl, IceUdpTransportPacketExtension localTransport) {
        String fingerprint = dtlsControl.getLocalFingerprint();
        String hash = dtlsControl.getLocalFingerprintHashFunction();
        DtlsFingerprintPacketExtension fingerprintPE = (DtlsFingerprintPacketExtension)localTransport.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (fingerprintPE == null) {
            fingerprintPE = new DtlsFingerprintPacketExtension();
            localTransport.addChildExtension((ExtensionElement)fingerprintPE);
        }
        fingerprintPE.setFingerprint(fingerprint);
        fingerprintPE.setHash(hash);
    }

    private void setTransportOnChannel(CallPeerJabberImpl peer, String media, ColibriConferenceIQ.Channel channel) throws OperationFailedException {
        ExtensionElement transport = ((CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getTransportManager().createTransport(media);
        if (transport instanceof IceUdpTransportPacketExtension) {
            channel.setTransport((IceUdpTransportPacketExtension)transport);
        }
    }

    private void setTransportOnChannel(String media, ContentPacketExtension localContent, ContentPacketExtension remoteContent, CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel) throws OperationFailedException {
        if (remoteContent != null) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)remoteContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            channel.setTransport(TransportManagerJabberImpl.cloneTransportAndCandidates(transport));
        }
    }

    private IceUdpTransportPacketExtension ensureTransportOnChannel(ColibriConferenceIQ.Channel channel, CallPeerJabberImpl peer) {
        ExtensionElement pe;
        IceUdpTransportPacketExtension transport = channel.getTransport();
        if (transport == null && (pe = ((CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getTransportManager().createTransportPacketExtension()) instanceof IceUdpTransportPacketExtension) {
            transport = (IceUdpTransportPacketExtension)pe;
            channel.setTransport(transport);
        }
        return transport;
    }

    public Jid getJitsiVideobridge() {
        Jid jitsiVideobridge;
        if (this.jitsiVideobridge == null && this.getConference().isJitsiVideobridge() && (jitsiVideobridge = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getJitsiVideobridge()) != null) {
            this.jitsiVideobridge = jitsiVideobridge;
        }
        return this.jitsiVideobridge;
    }

    public void toneReceived(DTMFReceivedEvent evt) {
        OperationSetIncomingDTMF opSet = (OperationSetIncomingDTMF)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetIncomingDTMF.class);
        if (opSet != null && opSet instanceof OperationSetIncomingDTMFJabberImpl) {
            ((OperationSetIncomingDTMFJabberImpl)opSet).toneReceived(new DTMFReceivedEvent((Object)this, evt.getValue(), evt.getDuration(), evt.getStart()));
        }
    }

    public void setLocalInputEvtAware(boolean enable) {
        this.localInputEvtAware = enable;
    }

    public boolean getLocalInputEvtAware() {
        return this.localInputEvtAware;
    }

    public CallPeerJabberImpl getPeer(String sid) {
        if (sid == null) {
            return null;
        }
        for (CallPeerJabberImpl peer : this.getCallPeerList()) {
            if (!sid.equals(peer.getSID())) continue;
            return peer;
        }
        return null;
    }

    public boolean containsSID(String sid) {
        return this.getPeer(sid) != null;
    }

    public CallPeerJabberImpl getPeerBySessInitPacketID(String id) {
        if (id == null) {
            return null;
        }
        for (CallPeerJabberImpl peer : this.getCallPeerList()) {
            if (!id.equals(peer.getSessInitID())) continue;
            return peer;
        }
        return null;
    }
}

