/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.packetlogging;

import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.java.sip.communicator.impl.packetlogging.PacketLoggingActivator;
import net.java.sip.communicator.impl.packetlogging.PacketLoggingConfigurationImpl;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.packetlogging.PacketLoggingConfiguration;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class PacketLoggingServiceImpl
implements PacketLoggingService {
    private static final Logger logger = Logger.getLogger(PacketLoggingServiceImpl.class);
    private static final int EVICTING_QUEUE_MAX_SIZE = 1000;
    private FileOutputStream outputStream = null;
    private SaverThread saverThread = new SaverThread();
    private PacketLoggingConfiguration packetLoggingConfiguration = null;
    private static final byte[] fakeEthernetHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ipv4EtherType = new byte[]{8, 0};
    private static final byte[] ipv6EtherType = new byte[]{-122, -35};
    private static final byte[] ipHeaderTemplate = new byte[]{69, 0, 3, 72, -55, 20, 0, 0, 53, 17, 0, 0, -43, -64, 59, 75, -64, -88, 0, 52};
    private static final byte[] ip6HeaderTemplate = new byte[]{96, 0, 0, 0, 0, 0, 17, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] udpHeaderTemplate = new byte[]{19, -60, 19, -60, 3, 52, 0, 0};
    private static final byte[] tcpHeaderTemplate = new byte[]{-73, 97, 19, -60, 79, 32, 55, 59, 17, 29, -68, 84, -128, 24, 0, 46, -84, 120, 0, 0, 1, 1, 8, 10, 0, 6, -44, 72, 110, -52, 118, -67};
    private Object tcpCounterLock = new Object();
    private long srcCount = 1L;
    private long dstCount = 1L;
    private long written = 0L;
    private File[] files;

    public void start() {
        this.saverThread.start();
    }

    private void getFileNames() throws Exception {
        int fileCount = this.getConfiguration().getLogfileCount();
        this.files = new File[fileCount];
        for (int i = 0; i < fileCount; ++i) {
            this.files[i] = PacketLoggingActivator.getFileAccessService().getPrivatePersistentFile(new File("log", "jitsi" + i + ".pcap").toString(), FileCategory.LOG);
        }
    }

    private void rotateFiles() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        for (int i = this.getConfiguration().getLogfileCount() - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            f1.renameTo(f2);
        }
        this.outputStream = new FileOutputStream(this.files[0]);
        this.written = 0L;
        this.createGlobalHeader();
    }

    public void stop() {
        this.saverThread.stopRunning();
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.outputStream = null;
            }
        }
    }

    private void createGlobalHeader() throws IOException {
        this.outputStream.write(212);
        this.outputStream.write(195);
        this.outputStream.write(178);
        this.outputStream.write(161);
        this.outputStream.write(2);
        this.outputStream.write(0);
        this.outputStream.write(4);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(255);
        this.outputStream.write(255);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(1);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
    }

    public boolean isLoggingEnabled() {
        return this.getConfiguration().isGlobalLoggingEnabled();
    }

    public boolean isLoggingEnabled(PacketLoggingService.ProtocolName protocol) {
        PacketLoggingConfiguration cfg = this.getConfiguration();
        if (cfg.isGlobalLoggingEnabled()) {
            switch (protocol) {
                case SIP: {
                    return cfg.isSipLoggingEnabled();
                }
                case JABBER: {
                    return cfg.isJabberLoggingEnabled();
                }
                case RTP: {
                    return cfg.isRTPLoggingEnabled();
                }
                case ICE4J: {
                    return cfg.isIce4JLoggingEnabled();
                }
                case ARBITRARY: {
                    return cfg.isArbitraryLoggingEnabled();
                }
            }
            return false;
        }
        return false;
    }

    public void logPacket(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent) {
        this.logPacket(protocol, sourceAddress, sourcePort, destinationAddress, destinationPort, transport, sender, packetContent, 0, packetContent.length);
    }

    public void logPacket(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent, int packetOffset, int packetLength) {
        this.saverThread.queuePacket(new Packet(protocol, sourceAddress, sourcePort, destinationAddress, destinationPort, transport, sender, packetContent, packetOffset, packetLength));
    }

    public PacketLoggingConfiguration getConfiguration() {
        if (this.packetLoggingConfiguration == null) {
            this.packetLoggingConfiguration = new PacketLoggingConfigurationImpl();
        }
        return this.packetLoggingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePacket(Packet packet) throws Exception {
        int inclLen;
        short len;
        byte[] transportHeader;
        byte[] ipHeader;
        boolean isIPv4;
        boolean bl = isIPv4 = packet.sourceAddress.length == 4 || packet.destinationAddress.length == 4;
        if (isIPv4) {
            ipHeader = new byte[ipHeaderTemplate.length];
            System.arraycopy(ipHeaderTemplate, 0, ipHeader, 0, ipHeader.length);
            System.arraycopy(packet.sourceAddress, 0, ipHeader, 12, 4);
            System.arraycopy(packet.destinationAddress, 0, ipHeader, 16, 4);
        } else {
            ipHeader = new byte[ip6HeaderTemplate.length];
            System.arraycopy(ip6HeaderTemplate, 0, ipHeader, 0, ipHeader.length);
            System.arraycopy(packet.sourceAddress, 0, ipHeader, 8, 16);
            System.arraycopy(packet.destinationAddress, 0, ipHeader, 24, 16);
        }
        if (packet.transport == PacketLoggingService.TransportName.UDP) {
            byte[] udpHeader = new byte[udpHeaderTemplate.length];
            transportHeader = udpHeader;
            System.arraycopy(udpHeaderTemplate, 0, udpHeader, 0, udpHeader.length);
            PacketLoggingServiceImpl.writeShort(packet.sourcePort, udpHeader, 0);
            PacketLoggingServiceImpl.writeShort(packet.destinationPort, udpHeader, 2);
            len = (short)(packet.packetLength + udpHeader.length);
            PacketLoggingServiceImpl.writeShort(len, udpHeader, 4);
        } else {
            long acknum;
            Object object;
            transportHeader = new byte[tcpHeaderTemplate.length];
            System.arraycopy(tcpHeaderTemplate, 0, transportHeader, 0, transportHeader.length);
            PacketLoggingServiceImpl.writeShort(packet.sourcePort, transportHeader, 0);
            PacketLoggingServiceImpl.writeShort(packet.destinationPort, transportHeader, 2);
            len = (short)(packet.packetLength + transportHeader.length);
            if (packet.sender) {
                long seqnum;
                object = this.tcpCounterLock;
                synchronized (object) {
                    seqnum = this.srcCount;
                    this.srcCount += (long)packet.packetLength;
                    acknum = this.dstCount;
                }
                PacketLoggingServiceImpl.intToBytes((int)(seqnum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 4);
                PacketLoggingServiceImpl.intToBytes((int)(acknum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 8);
            } else {
                long seqnum;
                object = this.tcpCounterLock;
                synchronized (object) {
                    seqnum = this.dstCount;
                    this.dstCount += (long)packet.packetLength;
                    acknum = this.srcCount;
                }
                PacketLoggingServiceImpl.intToBytes((int)(seqnum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 4);
                PacketLoggingServiceImpl.intToBytes((int)(acknum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 8);
            }
        }
        if (isIPv4) {
            short ipTotalLen = (short)(len + ipHeader.length);
            PacketLoggingServiceImpl.writeShort(ipTotalLen, ipHeader, 2);
            ipHeader[9] = packet.transport == PacketLoggingService.TransportName.UDP ? 17 : 6;
            int chk2 = this.computeChecksum(ipHeader);
            ipHeader[10] = (byte)(chk2 >> 8);
            ipHeader[11] = (byte)(chk2 & 0xFF);
        } else {
            PacketLoggingServiceImpl.writeShort(len, ipHeader, 4);
            ipHeader[6] = packet.transport == PacketLoggingService.TransportName.UDP ? 17 : 6;
        }
        long current = System.currentTimeMillis();
        int tsSec = (int)(current / 1000L);
        int tsUsec = (int)(current % 1000L * 1000L);
        int feakHeaderLen = fakeEthernetHeader.length + (isIPv4 ? ipv4EtherType : ipv6EtherType).length + ipHeader.length + transportHeader.length;
        int origLen = inclLen = packet.packetLength + feakHeaderLen;
        PacketLoggingServiceImpl packetLoggingServiceImpl = this;
        synchronized (packetLoggingServiceImpl) {
            long limit;
            if (this.outputStream == null) {
                this.getFileNames();
                this.rotateFiles();
            }
            if ((limit = this.getConfiguration().getLimit()) > 0L && this.written > limit) {
                this.rotateFiles();
            }
            this.addInt(tsSec);
            this.addInt(tsUsec);
            this.addInt(inclLen);
            this.addInt(origLen);
            this.outputStream.write(fakeEthernetHeader);
            this.outputStream.write(isIPv4 ? ipv4EtherType : ipv6EtherType);
            this.outputStream.write(ipHeader);
            this.outputStream.write(transportHeader);
            this.outputStream.write(packet.packetContent, packet.packetOffset, packet.packetLength);
            this.outputStream.flush();
            this.written += (long)(inclLen + 16);
        }
    }

    private void addInt(int d) throws IOException {
        this.outputStream.write(d & 0xFF);
        this.outputStream.write((d & 0xFF00) >> 8);
        this.outputStream.write((d & 0xFF0000) >> 16);
        this.outputStream.write((d & 0xFF000000) >> 24);
    }

    private static final void intToBytes(int address, byte[] data, int offset) {
        data[offset] = (byte)(0xFF & address >>> 24);
        data[offset + 1] = (byte)(0xFF & address >>> 16);
        data[offset + 2] = (byte)(0xFF & address >>> 8);
        data[offset + 3] = (byte)(0xFF & address);
    }

    private static void writeShort(int value, byte[] data, int offset) {
        data[offset] = (byte)(value >> 8);
        data[offset + 1] = (byte)value;
    }

    private int computeChecksum(byte[] data) {
        int total = 0;
        int i = 0;
        int imax = data.length - data.length % 2;
        while (i < imax) {
            total += (data[i++] & 0xFF) << 8 | data[i++] & 0xFF;
        }
        if (i < data.length) {
            total += (data[i] & 0xFF) << 8;
        }
        while ((total & 0xFFFF0000) != 0) {
            total = (total & 0xFFFF) + (total >>> 16);
        }
        total = ~total & 0xFFFF;
        return total;
    }

    private class SaverThread
    extends Thread {
        private boolean stopped = true;
        private final EvictingQueue<Packet> pktsToSave = EvictingQueue.create((int)1000);

        SaverThread() {
            this.setName(PacketLoggingServiceImpl.class.getName() + " SaverThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stopped = false;
            while (!this.stopped) {
                Packet pktToSave;
                SaverThread saverThread = this;
                synchronized (saverThread) {
                    if (this.pktsToSave.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    pktToSave = (Packet)this.pktsToSave.poll();
                }
                if (pktToSave == null) continue;
                try {
                    PacketLoggingServiceImpl.this.savePacket(pktToSave);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error((Object)"Error writing packet to file", t);
                }
            }
        }

        public synchronized void stopRunning() {
            this.stopped = true;
            this.notifyAll();
        }

        public synchronized void queuePacket(Packet packet) {
            if (1000 - this.pktsToSave.size() == 0) {
                logger.warn((Object)"Queue is full, packets are being evicted.");
            }
            this.pktsToSave.add((Object)packet);
            this.notifyAll();
        }
    }

    private static class Packet {
        PacketLoggingService.ProtocolName protocol;
        byte[] sourceAddress;
        int sourcePort;
        byte[] destinationAddress;
        int destinationPort;
        PacketLoggingService.TransportName transport;
        boolean sender;
        byte[] packetContent;
        int packetOffset;
        int packetLength;

        private Packet(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent, int packetOffset, int packetLength) {
            this.protocol = protocol;
            this.sourceAddress = sourceAddress != null ? sourceAddress : new byte[4];
            this.sourcePort = sourcePort;
            this.destinationAddress = destinationAddress != null ? destinationAddress : new byte[4];
            this.destinationPort = destinationPort;
            this.transport = transport;
            this.sender = sender;
            this.packetContent = packetContent;
            this.packetOffset = packetOffset;
            this.packetLength = packetLength;
        }
    }
}

