/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.mucclient;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.TrustAllHostnameVerifier;
import org.jitsi.xmpp.TrustAllX509TrustManager;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jitsi.xmpp.mucclient.MucClientManager;
import org.jitsi.xmpp.util.IQUtils;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.ping.PingManager;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class MucClient {
    private static final Logger logger = Logger.getLogger(MucClient.class);
    private static final IQ.Type[] IQ_TYPES = new IQ.Type[]{IQ.Type.get, IQ.Type.set};
    private AbstractXMPPConnection xmppConnection;
    private final MucClientManager mucClientManager;
    private IQListener iqListener;
    private Resourcepart mucNickname;
    private IQRequestHandler.Mode iqHandlerMode = IQRequestHandler.Mode.async;
    private final MucClientConfiguration config;
    private final Map<Jid, MucWrapper> mucs = new ConcurrentHashMap<Jid, MucWrapper>();

    private static XMPPTCPConnectionConfiguration createXMPPTCPConnectionConfiguration(MucClientConfiguration config) {
        DomainBareJid domainJid;
        String domain = config.getDomain();
        if (domain == null) {
            domain = config.getHostname();
        }
        try {
            domainJid = JidCreate.domainBareFrom((String)domain);
        }
        catch (XmppStringprepException xse) {
            logger.error((Object)("Failed to parse domain: " + domain));
            return null;
        }
        XMPPTCPConnectionConfiguration.Builder builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost(config.getHostname())).setXmppDomain(domainJid)).setUsernameAndPassword((CharSequence)config.getUsername(), config.getPassword());
        if (config.getDisableCertificateVerification()) {
            logger.warn((Object)"Disabling certificate verification!");
            builder.setCustomX509TrustManager((X509TrustManager)new TrustAllX509TrustManager());
            builder.setHostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        }
        return builder.build();
    }

    MucClient(MucClientConfiguration config, MucClientManager mucClientManager) {
        this.mucClientManager = mucClientManager;
        this.config = config;
    }

    void initializeConnectAndJoin() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initializing a new MucClient for " + this.config));
        }
        if (!this.config.isComplete()) {
            throw new IllegalArgumentException("incomplete configuration");
        }
        this.mucNickname = Resourcepart.from((String)this.config.getMucNickname());
        if ("sync".equals(this.config.getIqHandlerMode())) {
            this.iqHandlerMode = IQRequestHandler.Mode.sync;
        }
        this.xmppConnection = new XMPPTCPConnection(MucClient.createXMPPTCPConnectionConfiguration(this.config));
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.xmppConnection);
        this.mucClientManager.getFeatures().forEach(arg_0 -> ((ServiceDiscoveryManager)sdm).addFeature(arg_0));
        ReconnectionManager reconnectionManager = ReconnectionManager.getInstanceFor((AbstractXMPPConnection)this.xmppConnection);
        reconnectionManager.enableAutomaticReconnection();
        this.xmppConnection.addConnectionListener(new ConnectionListener(){

            public void connected(XMPPConnection xmppConnection) {
                logger.info((Object)(MucClient.this + " connected"));
            }

            public void authenticated(XMPPConnection xmppConnection, boolean b) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(MucClient.this + " authenticated, b=" + b));
                }
                try {
                    MucClient.this.joinMucs();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void connectionClosed() {
                logger.info((Object)(MucClient.this + " closed"));
            }

            public void connectionClosedOnError(Exception e) {
                logger.info((Object)(MucClient.this + " closed on error:"), (Throwable)e);
            }

            public void reconnectionSuccessful() {
                logger.info((Object)(MucClient.this + " reconnection successful"));
                try {
                    MucClient.this.joinMucs();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void reconnectingIn(int i) {
                MucClient.this.mucs.values().forEach(rec$ -> ((MucWrapper)rec$).resetLastPresenceSent());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(MucClient.this + " reconnecting in " + i));
                }
            }

            public void reconnectionFailed(Exception e) {
                logger.info((Object)(MucClient.this + " reconnection failed"));
            }
        });
        this.mucClientManager.getRegisteredIqs().forEach(this::registerIQ);
        this.setIQListener(this.mucClientManager.getIqListener());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " about to connect and login."));
        }
        this.xmppConnection.connect().login();
    }

    private void joinMucs() throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException, XMPPException.XMPPErrorException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " about to join MUCs."));
        }
        for (String mucJidStr : this.config.getMucJids()) {
            EntityBareJid mucJid = JidCreate.entityBareFrom((String)mucJidStr);
            MucWrapper mucWrapper = this.getOrCreateMucState((Jid)mucJid);
            mucWrapper.join(mucJid);
        }
    }

    private MucWrapper getOrCreateMucState(Jid mucJid) {
        return this.mucs.computeIfAbsent(mucJid, k -> new MucWrapper());
    }

    public boolean sendStanza(Stanza stanza) {
        try {
            this.xmppConnection.sendStanza(stanza);
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to send stanza: " + e));
            return false;
        }
    }

    public String toString() {
        return "[MucClient id=" + this.config.getId() + " hostname=" + this.config.getHostname() + "]";
    }

    public void setPresenceExtension(ExtensionElement extension) {
        this.setPresenceExtensions(Collections.singletonList(extension));
    }

    public void setPresenceExtensions(Collection<ExtensionElement> extensions) {
        this.mucs.values().forEach(ms -> ms.setPresenceExtensions(extensions));
    }

    public void removePresenceExtension(String elementName, String namespace) {
        this.mucs.values().forEach(ms -> ((MucWrapper)ms).removePresenceExtension(elementName, namespace));
    }

    void setIQListener(IQListener iqListener) {
        this.iqListener = iqListener;
    }

    void registerIQ(IQ iq) {
        for (final IQ.Type type : IQ_TYPES) {
            this.xmppConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler(iq.getChildElementName(), iq.getChildElementNamespace(), type, this.iqHandlerMode){

                public IQ handleIQRequest(IQ iqRequest) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received an IQ with type " + type + ": " + iqRequest.toString()));
                    }
                    return MucClient.this.handleIq(iqRequest);
                }
            });
        }
    }

    private IQ handleIq(IQ iq) {
        IQ responseIq = null;
        EntityBareJid fromJid = iq.getFrom().asEntityBareJidIfPossible();
        String fromJidStr = fromJid.toString().toLowerCase();
        if (fromJid == null || !this.config.getMucJids().stream().anyMatch(mucJid -> mucJid.toLowerCase().equals(fromJidStr))) {
            logger.warn((Object)("Received an IQ from a non-MUC member: " + fromJid));
            return IQUtils.createError(iq, XMPPError.Condition.forbidden);
        }
        IQListener iqListener = this.iqListener;
        if (iqListener == null) {
            logger.error((Object)"Received an IQ, but the listener is null.");
        } else {
            responseIq = iqListener.handleIq(iq, this);
        }
        if (responseIq == null) {
            logger.info((Object)("Failed to produce a response for IQ, returning internal server error. Request: " + iq.toString()));
            responseIq = IQUtils.createError(iq, XMPPError.Condition.internal_server_error, "Unknown error");
        }
        return responseIq;
    }

    public String getId() {
        return this.config.getId();
    }

    void stop() {
        this.mucs.values().forEach(rec$ -> ((MucWrapper)rec$).leave());
        this.xmppConnection.disconnect();
    }

    static {
        PingManager.setDefaultPingInterval((int)30);
    }

    private class MucWrapper {
        private MultiUserChat muc;
        private Presence lastPresenceSent;
        private final PresenceListener presenceInterceptor = this::presenceSent;

        private MucWrapper() {
        }

        private void presenceSent(Presence presence) {
            this.lastPresenceSent = presence;
        }

        private void leave() {
            try {
                this.muc.leave();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while trying to leave a MUC: ", (Throwable)e);
            }
            this.muc = null;
        }

        private void join(EntityBareJid mucJid) throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException, XMPPException.XMPPErrorException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.NotAMucServiceException {
            this.resetLastPresenceSent();
            if (this.muc != null) {
                this.muc.removePresenceInterceptor(this.presenceInterceptor);
                logger.info((Object)"Leaving a MUC we already occupy.");
                this.muc.leave();
            }
            MultiUserChatManager mucManager = MultiUserChatManager.getInstanceFor((XMPPConnection)MucClient.this.xmppConnection);
            this.muc = mucManager.getMultiUserChat(mucJid);
            this.muc.addPresenceInterceptor(this.presenceInterceptor);
            MultiUserChat.MucCreateConfigFormHandle mucCreateHandle = this.muc.createOrJoin(MucClient.this.mucNickname);
            if (mucCreateHandle != null) {
                String whoisFieldName;
                Form config = this.muc.getConfigurationForm();
                Form answer = config.createAnswerForm();
                FormField whois = answer.getField(whoisFieldName = "muc#roomconfig_whois");
                if (whois == null) {
                    whois = new FormField(whoisFieldName);
                    answer.addField(whois);
                }
                whois.addValue("anyone");
                this.muc.sendConfigurationForm(answer);
            }
            logger.info((Object)("Joined MUC: " + mucJid));
            this.setPresenceExtensions(MucClient.this.mucClientManager.getPresenceExtensions());
        }

        void setPresenceExtensions(Collection<ExtensionElement> extensions) {
            if (this.lastPresenceSent == null) {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)"Not setting an extension yet, presence not sent.");
                }
                return;
            }
            this.lastPresenceSent.removeExtension("x", "http://jabber.org/protocol/muc");
            extensions.forEach(arg_0 -> ((Presence)this.lastPresenceSent).overrideExtension(arg_0));
            this.lastPresenceSent.setStanzaId(StanzaIdUtil.newStanzaId());
            try {
                MucClient.this.xmppConnection.sendStanza((Stanza)this.lastPresenceSent);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to send stanza:", (Throwable)e);
            }
        }

        private void removePresenceExtension(String elementName, String namespace) {
            if (this.lastPresenceSent != null && this.lastPresenceSent.removeExtension(elementName, namespace) != null) {
                try {
                    MucClient.this.xmppConnection.sendStanza((Stanza)this.lastPresenceSent);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to send stanza:", (Throwable)e);
                }
            }
        }

        private void resetLastPresenceSent() {
            this.lastPresenceSent = null;
        }
    }
}

