/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.MuxServerSocketChannelFactory;

public abstract class AbstractTcpListener {
    private static final Logger logger = Logger.getLogger(AbstractTcpListener.class.getName());
    private AcceptThread acceptThread;
    private boolean close = false;
    protected final List<TransportAddress> localAddresses = new LinkedList<TransportAddress>();
    private final List<SocketChannel> newChannels = new LinkedList<SocketChannel>();
    private final Selector readSelector = Selector.open();
    private ReadThread readThread;
    private final List<ServerSocketChannel> serverSocketChannels = new LinkedList<ServerSocketChannel>();
    protected final Object sessionsSyncRoot = new Object();

    static void closeNoExceptions(Channel channel) {
        MuxServerSocketChannelFactory.closeNoExceptions(channel);
    }

    private static List<TransportAddress> getLocalAddresses(int port, List<NetworkInterface> interfaces) throws IOException {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (NetworkInterface iface : interfaces) {
            if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface) || !HostCandidateHarvester.isInterfaceAllowed(iface)) continue;
            Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
            while (ifaceAddresses.hasMoreElements()) {
                InetAddress addr = ifaceAddresses.nextElement();
                addresses.add(new TransportAddress(addr, port, Transport.TCP));
            }
        }
        return addresses;
    }

    private static boolean isFirstDatagramPacket(DatagramPacket p) {
        int len = p.getLength();
        boolean b = false;
        if (len > 0) {
            byte[] buf = p.getData();
            int off = p.getOffset();
            byte[] googleTurnSslTcp = GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE;
            if (len >= googleTurnSslTcp.length) {
                b = true;
                int i = 0;
                int iEnd = googleTurnSslTcp.length;
                int j = off;
                while (i < iEnd) {
                    if (googleTurnSslTcp[i] != buf[j]) {
                        b = false;
                        break;
                    }
                    ++i;
                    ++j;
                }
            }
            if (!b && len >= 10 && buf[off + 2] == 0 && buf[off + 3] == 1) {
                byte[] magicCookie = Message.MAGIC_COOKIE;
                b = true;
                int i = 0;
                int iEnd = magicCookie.length;
                int j = off + 6;
                while (i < iEnd) {
                    if (magicCookie[i] != buf[j]) {
                        b = false;
                        break;
                    }
                    ++i;
                    ++j;
                }
            }
        }
        return b;
    }

    public AbstractTcpListener(int port) throws IOException {
        this(port, Collections.list(NetworkInterface.getNetworkInterfaces()));
    }

    public AbstractTcpListener(int port, List<NetworkInterface> interfaces) throws IOException {
        this(AbstractTcpListener.getLocalAddresses(port, interfaces));
    }

    public AbstractTcpListener(List<TransportAddress> transportAddresses) throws IOException {
        this.addLocalAddresses(transportAddresses);
        this.init();
    }

    protected void addLocalAddresses(List<TransportAddress> transportAddresses) throws IOException {
        boolean useIPv6 = !StackProperties.getBoolean("org.ice4j.ipv6.DISABLED", false);
        boolean useLinkLocalAddresses = !StackProperties.getBoolean("org.ice4j.ice.harvest.DISABLE_LINK_LOCAL_ADDRESSES", false);
        String[] allowedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.ALLOWED_ADDRESSES", ";");
        InetAddress[] allowedAddresses = null;
        if (allowedAddressesStr != null) {
            allowedAddresses = new InetAddress[allowedAddressesStr.length];
            for (int i = 0; i < allowedAddressesStr.length; ++i) {
                allowedAddresses[i] = InetAddress.getByName(allowedAddressesStr[i]);
            }
        }
        String[] blockedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.BLOCKED_ADDRESSES", ";");
        InetAddress[] blockedAddresses = null;
        if (blockedAddressesStr != null) {
            blockedAddresses = new InetAddress[blockedAddressesStr.length];
            for (int i = 0; i < blockedAddressesStr.length; ++i) {
                blockedAddresses[i] = InetAddress.getByName(blockedAddressesStr[i]);
            }
        }
        for (TransportAddress transportAddress : transportAddresses) {
            boolean found;
            InetAddress address = transportAddress.getAddress();
            if (address.isLoopbackAddress() || !useIPv6 && address instanceof Inet6Address) continue;
            if (!useLinkLocalAddresses && address.isLinkLocalAddress()) {
                logger.info("Not using link-local address " + address + " for TCP candidates.");
                continue;
            }
            if (allowedAddresses != null) {
                found = false;
                for (InetAddress allowedAddress : allowedAddresses) {
                    if (!allowedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.info("Not using " + address + " for TCP candidates, because it is not in the allowed list.");
                    continue;
                }
            }
            if (blockedAddresses != null) {
                found = false;
                for (InetAddress blockedAddress : blockedAddresses) {
                    if (!blockedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    logger.info("Not using " + address + " for TCP candidates, because it is in the blocked list.");
                    continue;
                }
            }
            this.localAddresses.add(transportAddress);
        }
    }

    public void close() {
        this.close = true;
    }

    protected void init() throws IOException {
        boolean bindWildcard = StackProperties.getBoolean("org.ice4j.BIND_WILDCARD", false);
        HashSet<InetSocketAddress> addressesToBind = new HashSet<InetSocketAddress>();
        for (TransportAddress transportAddress : this.localAddresses) {
            addressesToBind.add(new InetSocketAddress(bindWildcard ? null : transportAddress.getAddress(), transportAddress.getPort()));
        }
        for (InetSocketAddress addressToBind : addressesToBind) {
            this.addSocketChannel(addressToBind);
        }
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    private void addSocketChannel(InetSocketAddress address) throws IOException {
        ServerSocketChannel channel = MuxServerSocketChannelFactory.openAndBindMuxServerSocketChannel(null, address, 0, new DatagramPacketFilter(){

            @Override
            public boolean accept(DatagramPacket p) {
                return AbstractTcpListener.isFirstDatagramPacket(p);
            }
        });
        this.serverSocketChannels.add(channel);
    }

    protected abstract void acceptSession(Socket var1, String var2, DatagramPacket var3) throws IOException, IllegalStateException;

    private class ReadThread
    extends Thread {
        public ReadThread() throws IOException {
            this.setName("TcpHarvester ReadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForNewChannels() {
            List list = AbstractTcpListener.this.newChannels;
            synchronized (list) {
                for (SocketChannel channel : AbstractTcpListener.this.newChannels) {
                    try {
                        channel.configureBlocking(false);
                        channel.register(AbstractTcpListener.this.readSelector, 1, new ChannelDesc(channel));
                    }
                    catch (IOException ioe) {
                        logger.info("Failed to register channel: " + ioe);
                        AbstractTcpListener.closeNoExceptions(channel);
                    }
                }
                AbstractTcpListener.this.newChannels.clear();
            }
        }

        private void cleanup() {
            long now = System.currentTimeMillis();
            for (SelectionKey key : AbstractTcpListener.this.readSelector.keys()) {
                long lastActive;
                ChannelDesc channelDesc;
                if (!key.isValid() || (channelDesc = (ChannelDesc)key.attachment()) == null || (lastActive = channelDesc.lastActive) == -1L || now - lastActive <= 15000L) continue;
                key.cancel();
                SocketChannel channel = channelDesc.channel;
                logger.info("Read timeout for socket: " + channel.socket());
                AbstractTcpListener.closeNoExceptions(channel);
            }
        }

        private void readFromChannel(ChannelDesc channel, SelectionKey key) {
            if (channel.buffer == null) {
                channel.buffer = !channel.checkedForSSLHandshake && channel.length == -1 ? ByteBuffer.allocate(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length) : (channel.length == -1 ? ByteBuffer.allocate(2) : ByteBuffer.allocate(channel.length));
            }
            try {
                int read = channel.channel.read(channel.buffer);
                if (read == -1) {
                    throw new IOException("End of stream!");
                }
                if (read > 0) {
                    channel.lastActive = System.currentTimeMillis();
                }
                if (!channel.buffer.hasRemaining()) {
                    if (!channel.checkedForSSLHandshake) {
                        byte[] bytesRead = new byte[GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length];
                        channel.buffer.flip();
                        channel.buffer.get(bytesRead);
                        channel.buffer = null;
                        channel.checkedForSSLHandshake = true;
                        if (Arrays.equals(bytesRead, GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE)) {
                            ByteBuffer byteBuffer = ByteBuffer.wrap(GoogleTurnSSLCandidateHarvester.SSL_SERVER_HANDSHAKE);
                            channel.channel.write(byteBuffer);
                        } else {
                            byte fb = bytesRead[0];
                            byte sb = bytesRead[1];
                            channel.length = (fb & 0xFF) << 8 | sb & 0xFF;
                            byte[] preBuffered = Arrays.copyOfRange(bytesRead, 2, bytesRead.length);
                            if (channel.length <= bytesRead.length - 2) {
                                this.processFirstDatagram(preBuffered, channel, key);
                            } else {
                                channel.preBuffered = preBuffered;
                                channel.length -= channel.preBuffered.length;
                            }
                        }
                    } else if (channel.length == -1) {
                        channel.buffer.flip();
                        byte fb = channel.buffer.get();
                        byte sb = channel.buffer.get();
                        channel.length = (fb & 0xFF) << 8 | sb & 0xFF;
                        channel.buffer = null;
                    } else {
                        byte[] bytesRead = new byte[channel.length];
                        channel.buffer.flip();
                        channel.buffer.get(bytesRead);
                        if (channel.preBuffered != null) {
                            byte[] newBytesRead = new byte[channel.preBuffered.length + bytesRead.length];
                            System.arraycopy(channel.preBuffered, 0, newBytesRead, 0, channel.preBuffered.length);
                            System.arraycopy(bytesRead, 0, newBytesRead, channel.preBuffered.length, bytesRead.length);
                            bytesRead = newBytesRead;
                            channel.preBuffered = null;
                        }
                        this.processFirstDatagram(bytesRead, channel, key);
                    }
                }
            }
            catch (Exception e) {
                logger.info("Failed to handle TCP socket " + channel.channel.socket() + ": " + e.getMessage());
                key.cancel();
                AbstractTcpListener.closeNoExceptions(channel.channel);
            }
        }

        private void processFirstDatagram(byte[] bytesRead, ChannelDesc channel, SelectionKey key) throws IOException, IllegalStateException {
            String ufrag = AbstractUdpListener.getUfrag(bytesRead, 0, (char)bytesRead.length);
            if (ufrag == null) {
                throw new IOException("Cannot extract ufrag");
            }
            key.cancel();
            channel.channel.configureBlocking(true);
            DatagramPacket p = new DatagramPacket(bytesRead, bytesRead.length);
            Socket socket = channel.channel.socket();
            p.setAddress(socket.getInetAddress());
            p.setPort(socket.getPort());
            AbstractTcpListener.this.acceptSession(socket, ufrag, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator<SelectionKey> iterator;
            while (true) {
                iterator = AbstractTcpListener.this;
                synchronized (iterator) {
                    if (AbstractTcpListener.this.close) {
                        break;
                    }
                }
                this.cleanup();
                this.checkForNewChannels();
                for (SelectionKey selectionKey : AbstractTcpListener.this.readSelector.keys()) {
                    if (!selectionKey.isValid()) continue;
                    ChannelDesc channelDesc = (ChannelDesc)selectionKey.attachment();
                    this.readFromChannel(channelDesc, selectionKey);
                }
                AbstractTcpListener.this.readSelector.selectedKeys().clear();
                try {
                    AbstractTcpListener.this.readSelector.select(7500L);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select a read-ready channel.");
                }
            }
            iterator = AbstractTcpListener.this.newChannels;
            synchronized (iterator) {
                for (SelectableChannel channel : AbstractTcpListener.this.newChannels) {
                    AbstractTcpListener.closeNoExceptions(channel);
                }
                AbstractTcpListener.this.newChannels.clear();
            }
            for (SelectionKey selectionKey : AbstractTcpListener.this.readSelector.keys()) {
                SelectableChannel channel;
                if (!selectionKey.isValid() || !(channel = selectionKey.channel()).isOpen()) continue;
                AbstractTcpListener.closeNoExceptions(channel);
            }
            try {
                AbstractTcpListener.this.readSelector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static class PushBackIceSocketWrapper
    extends IceSocketWrapper {
        private DatagramPacket datagramPacket;
        private final IceSocketWrapper wrapped;

        public PushBackIceSocketWrapper(IceSocketWrapper wrappedWrapper, DatagramPacket datagramPacket) {
            this.wrapped = wrappedWrapper;
            this.datagramPacket = datagramPacket;
        }

        @Override
        public void close() {
            this.wrapped.close();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.wrapped.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.wrapped.getLocalSocketAddress();
        }

        @Override
        public Socket getTCPSocket() {
            return this.wrapped.getTCPSocket();
        }

        @Override
        public DatagramSocket getUDPSocket() {
            return this.wrapped.getUDPSocket();
        }

        @Override
        public void receive(DatagramPacket p) throws IOException {
            if (this.datagramPacket != null) {
                int len = Math.min(p.getLength(), this.datagramPacket.getLength());
                System.arraycopy(this.datagramPacket.getData(), 0, p.getData(), 0, len);
                p.setAddress(this.datagramPacket.getAddress());
                p.setPort(this.datagramPacket.getPort());
                this.datagramPacket = null;
            } else {
                this.wrapped.receive(p);
            }
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            this.wrapped.send(p);
        }
    }

    private static class ChannelDesc {
        public final SocketChannel channel;
        long lastActive = System.currentTimeMillis();
        ByteBuffer buffer = null;
        boolean checkedForSSLHandshake = false;
        byte[] preBuffered = null;
        int length = -1;

        public ChannelDesc(SocketChannel channel) {
            this.channel = channel;
        }
    }

    private class AcceptThread
    extends Thread {
        private final Selector selector;

        public AcceptThread() throws IOException {
            this.setName("TcpHarvester AcceptThread");
            this.setDaemon(true);
            this.selector = Selector.open();
            for (ServerSocketChannel channel : AbstractTcpListener.this.serverSocketChannels) {
                channel.configureBlocking(false);
                channel.register(this.selector, 16);
            }
        }

        private void notifyReadThread() {
            AbstractTcpListener.this.readSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AbstractTcpListener.this.close) {
                IOException exception = null;
                LinkedList<SocketChannel> channelsToAdd = new LinkedList<SocketChannel>();
                long selectTimeout = 3000L;
                for (SelectionKey key : this.selector.keys()) {
                    SocketChannel channel;
                    if (!key.isValid()) continue;
                    boolean acceptable = key.isAcceptable();
                    try {
                        channel = ((ServerSocketChannel)key.channel()).accept();
                    }
                    catch (IOException ioe) {
                        exception = ioe;
                        break;
                    }
                    if (channel != null) {
                        channelsToAdd.add(channel);
                        continue;
                    }
                    if (!acceptable) continue;
                    selectTimeout = 100L;
                }
                this.selector.selectedKeys().clear();
                if (!channelsToAdd.isEmpty()) {
                    List list = AbstractTcpListener.this.newChannels;
                    synchronized (list) {
                        AbstractTcpListener.this.newChannels.addAll(channelsToAdd);
                    }
                    this.notifyReadThread();
                }
                if (exception != null) {
                    logger.info("Failed to accept a socket, which should have been ready to accept: " + exception);
                    break;
                }
                try {
                    this.selector.select(selectTimeout);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select an accept-ready socket: " + ioe);
                    break;
                }
            }
            for (ServerSocketChannel serverSocketChannel : AbstractTcpListener.this.serverSocketChannels) {
                AbstractTcpListener.closeNoExceptions(serverSocketChannel);
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

