/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.container;

import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jivesoftware.util.XMLProperties;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.container.ComponentFinder;
import org.xmpp.component.ComponentManager;

public class ServerContainer {
    private static final ServerContainer instance = new ServerContainer();
    private Server jetty;
    private ExternalComponentManager manager;
    private ComponentFinder componentFinder;
    private boolean setupMode = true;
    private String homeDir;
    private XMLProperties properties;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage ServerContainer <absolute path to home folder> <config filename>");
            return;
        }
        String homeDir = args[0];
        XMLProperties properties = null;
        try {
            properties = new XMLProperties(homeDir + "/conf/" + args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        instance.setHomeDirectory(homeDir);
        instance.setProperties(properties);
        instance.start();
    }

    public static ServerContainer getInstance() {
        return instance;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    void setHomeDirectory(String homeDir) {
        this.homeDir = homeDir;
    }

    public XMLProperties getProperties() {
        return this.properties;
    }

    void setProperties(XMLProperties properties) {
        this.properties = properties;
    }

    public void start() {
        try {
            this.jetty = new Server();
            boolean plainStarted = false;
            String interfaceName = this.properties.getProperty("adminConsole.inteface");
            String port = this.properties.getProperty("adminConsole.port");
            int adminPort = port == null ? 9090 : Integer.parseInt(port);
            SelectChannelConnector connector0 = new SelectChannelConnector();
            connector0.setPort(adminPort);
            if (interfaceName != null) {
                connector0.setHost(interfaceName);
            }
            if (adminPort > 0) {
                this.jetty.addConnector((Connector)connector0);
                plainStarted = true;
            }
            boolean secureStarted = false;
            String securePortProperty = this.properties.getProperty("adminConsole.securePort");
            int adminSecurePort = 9091;
            try {
                int n = adminSecurePort = securePortProperty == null ? 9091 : Integer.parseInt(securePortProperty);
                if (adminSecurePort > 0) {
                    SslSelectChannelConnector listener = new SslSelectChannelConnector();
                    String keyStoreLocation = this.properties.getProperty("xmpp.socket.ssl.keystore");
                    keyStoreLocation = keyStoreLocation == null ? "resources" + File.separator + "security" + File.separator + "keystore" : keyStoreLocation;
                    keyStoreLocation = this.homeDir + File.separator + keyStoreLocation;
                    String keypass = this.properties.getProperty("xmpp.socket.ssl.keypass");
                    keypass = keypass == null ? "changeit" : keypass;
                    keypass = keypass.trim();
                    String trustStoreLocation = this.properties.getProperty("xmpp.socket.ssl.truststore");
                    trustStoreLocation = trustStoreLocation == null ? "resources" + File.separator + "security" + File.separator + "truststore" : trustStoreLocation;
                    trustStoreLocation = this.homeDir + File.separator + trustStoreLocation;
                    String trustpass = this.properties.getProperty("xmpp.socket.ssl.trustpass");
                    trustpass = trustpass == null ? "changeit" : trustpass;
                    trustpass = trustpass.trim();
                    listener.setKeystore(keyStoreLocation);
                    listener.setKeyPassword(keypass);
                    listener.setPassword(keypass);
                    listener.setHost(interfaceName);
                    listener.setPort(adminSecurePort);
                    this.jetty.addConnector((Connector)listener);
                    secureStarted = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("true".equals(this.properties.getProperty("setup"))) {
                this.setupMode = false;
            }
            String xmppServerHost = this.properties.getProperty("xmppServer.host");
            port = this.properties.getProperty("xmppServer.port");
            int xmppServerPort = port == null ? 10015 : Integer.parseInt(port);
            this.manager = new ExternalComponentManager(xmppServerHost, xmppServerPort, false);
            String serverDomain = this.properties.getProperty("xmppServer.domain");
            if (serverDomain != null) {
                this.manager.setServerName(serverDomain);
            }
            if (this.properties.getProperty("xmppServer.defaultSecretKey") != null) {
                this.manager.setDefaultSecretKey(this.properties.getProperty("xmppServer.defaultSecretKey"));
            }
            WebAppContext webapp = new WebAppContext();
            webapp.setContextPath("/");
            webapp.setResourceBase(this.homeDir + File.separator + "webapp");
            webapp.setWelcomeFiles(new String[]{"index.jsp"});
            webapp.setParentLoaderPriority(true);
            this.jetty.setHandler((Handler)webapp);
            this.jetty.start();
            this.jetty.join();
            if (!plainStarted && !secureStarted) {
                this.manager.getLog().info("Warning: admin console not started due to configuration settings.");
                System.out.println("Warning: admin console not started due to configuration settings.");
            } else if (!plainStarted && secureStarted) {
                this.manager.getLog().info("Admin console listening at secure port: " + adminSecurePort);
                System.out.println("Admin console listening at secure port: " + adminSecurePort);
            } else if (!secureStarted && plainStarted) {
                this.manager.getLog().info("Admin console listening at port: " + adminPort);
                System.out.println("Admin console listening at port: " + adminPort);
            } else {
                String msg = "Admin console listening at:\n  port: " + adminPort + "\n" + "  secure port: " + adminSecurePort;
                this.manager.getLog().info(msg);
            }
            File componentDir = new File(this.homeDir, "components");
            this.componentFinder = new ComponentFinder(this, componentDir);
            this.componentFinder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSetupMode() {
        return this.setupMode;
    }

    public ComponentManager getManager() {
        return this.manager;
    }
}

