/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.container;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;

class ComponentClassLoader {
    private URLClassLoader classLoader;

    public ComponentClassLoader(File componentDir) throws MalformedURLException, SecurityException {
        File libDir;
        File[] jars;
        ArrayList<URL> list = new ArrayList<URL>();
        File classesDir = new File(componentDir, "classes");
        if (classesDir.exists()) {
            list.add(classesDir.toURI().toURL());
        }
        if ((jars = (libDir = new File(componentDir, "lib")).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        })) != null) {
            for (int i = 0; i < jars.length; ++i) {
                if (jars[i] == null || !jars[i].isFile()) continue;
                list.add(jars[i].toURI().toURL());
            }
        }
        Iterator urls = list.iterator();
        URL[] urlArray = new URL[list.size()];
        int i = 0;
        while (urls.hasNext()) {
            urlArray[i] = (URL)urls.next();
            ++i;
        }
        this.classLoader = new URLClassLoader(urlArray, this.findParentClassLoader());
    }

    public Class loadClass(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SecurityException {
        return this.classLoader.loadClass(name);
    }

    public void destroy() {
        this.classLoader = null;
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

