/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.stats.CallStatsIOTransport;
import org.jitsi.videobridge.stats.ColibriStatsTransport;
import org.jitsi.videobridge.stats.MucStatsTransport;
import org.jitsi.videobridge.stats.PubSubStatsTransport;
import org.jitsi.videobridge.stats.StatsManager;
import org.jitsi.videobridge.stats.StatsTransport;
import org.jitsi.videobridge.stats.VideobridgeStatistics;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StatsManagerBundleActivator
implements BundleActivator {
    private static BundleContext bundleContext;
    public static final int DEFAULT_STAT_INTERVAL = 1000;
    private static final String DEFAULT_STAT_TRANSPORT;
    private static final String ENABLE_STATISTICS_PNAME = "org.jitsi.videobridge.ENABLE_STATISTICS";
    private static final Logger logger;
    private static final String PUBSUB_NODE_PNAME = "org.jitsi.videobridge.PUBSUB_NODE";
    private static final String PUBSUB_SERVICE_PNAME = "org.jitsi.videobridge.PUBSUB_SERVICE";
    public static final String STAT_TRANSPORT_CALLSTATS_IO = "callstats.io";
    private static final String STAT_TRANSPORT_COLIBRI = "colibri";
    private static final String STAT_TRANSPORT_PUBSUB = "pubsub";
    private static final String STAT_TRANSPORT_MUC = "muc";
    public static final String STATISTICS_INTERVAL_PNAME = "org.jitsi.videobridge.STATISTICS_INTERVAL";
    private static final String STATISTICS_TRANSPORT_PNAME = "org.jitsi.videobridge.STATISTICS_TRANSPORT";
    private ServiceRegistration<StatsManager> serviceRegistration;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    private void addTransport(StatsManager statsMgr, ConfigurationService cfg, int interval, String transport) {
        StatsTransport t = null;
        if (STAT_TRANSPORT_CALLSTATS_IO.equalsIgnoreCase(transport)) {
            t = new CallStatsIOTransport();
        } else if (STAT_TRANSPORT_COLIBRI.equalsIgnoreCase(transport)) {
            t = new ColibriStatsTransport();
        } else if (STAT_TRANSPORT_PUBSUB.equalsIgnoreCase(transport)) {
            Jid service;
            try {
                service = JidCreate.from((String)cfg.getString(PUBSUB_SERVICE_PNAME));
            }
            catch (XmppStringprepException e) {
                logger.error((Object)"Invalid pubsub service name", (Throwable)e);
                return;
            }
            String node = cfg.getString(PUBSUB_NODE_PNAME);
            if (service != null && node != null) {
                t = new PubSubStatsTransport(service, node);
            } else {
                logger.error((Object)"No configuration properties for PubSub service and/or node found.");
            }
        } else if (STAT_TRANSPORT_MUC.equalsIgnoreCase(transport)) {
            logger.info((Object)"Using a MUC stats transport");
            t = new MucStatsTransport();
        } else {
            logger.error((Object)("Unknown/unsupported statistics transport: " + transport));
        }
        if (t != null) {
            interval = ConfigUtils.getInt((ConfigurationService)cfg, (String)("org.jitsi.videobridge.STATISTICS_INTERVAL." + transport), (int)interval);
            if (statsMgr.findStatistics(VideobridgeStatistics.class, interval) == null) {
                statsMgr.addStatistics(new VideobridgeStatistics(), interval);
            }
            statsMgr.addTransport(t, interval);
        }
    }

    private void addTransports(StatsManager statsMgr, ConfigurationService cfg, int interval) {
        String transports = ConfigUtils.getString((ConfigurationService)cfg, (String)STATISTICS_TRANSPORT_PNAME, (String)DEFAULT_STAT_TRANSPORT);
        if (transports == null || transports.length() == 0) {
            return;
        }
        for (String transport : transports.split(",")) {
            this.addTransport(statsMgr, cfg, interval, transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        boolean enable = false;
        if (cfg != null) {
            enable = cfg.getBoolean(ENABLE_STATISTICS_PNAME, enable);
        }
        if (enable) {
            StatsManagerBundleActivator.bundleContext = bundleContext;
            boolean started = false;
            try {
                this.start(cfg);
                started = true;
            }
            finally {
                if (!started && StatsManagerBundleActivator.bundleContext == bundleContext) {
                    StatsManagerBundleActivator.bundleContext = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ConfigurationService cfg) throws Exception {
        StatsManager statsMgr = new StatsManager();
        int interval = ConfigUtils.getInt((ConfigurationService)cfg, (String)STATISTICS_INTERVAL_PNAME, (int)1000);
        statsMgr.addStatistics(new VideobridgeStatistics(), interval);
        this.addTransports(statsMgr, cfg, interval);
        statsMgr.start(bundleContext);
        ServiceRegistration serviceRegistration = null;
        try {
            serviceRegistration = bundleContext.registerService(StatsManager.class, (Object)statsMgr, null);
        }
        finally {
            if (serviceRegistration != null) {
                this.serviceRegistration = serviceRegistration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        ServiceRegistration<StatsManager> serviceRegistration = this.serviceRegistration;
        this.serviceRegistration = null;
        StatsManager statsMgr = null;
        if (serviceRegistration == null) {
            return;
        }
        try {
            statsMgr = (StatsManager)bundleContext.getService(serviceRegistration.getReference());
        }
        finally {
            serviceRegistration.unregister();
            if (statsMgr != null) {
                statsMgr.stop(bundleContext);
            }
        }
    }

    static {
        DEFAULT_STAT_TRANSPORT = null;
        logger = Logger.getLogger(StatsManagerBundleActivator.class);
    }
}

