/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.ssi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.rest.ssi.HttpServletResponseWrapper;

public class SSIResourceHandler
extends ResourceHandler {
    private static final String JETTY_SSI_RESOURCE_HANDLER_PATHS = ".jetty.SSIResourceHandler.paths";
    private static final String OLD_PREFIX = "org.jitsi.videobridge.rest";
    private static final String SSI_CMD_START = "<!--#";
    private static final String SSI_CMD_END = "-->";
    private static final String SSI_CMD_INCLUDE = "include";
    private static final String SSI_PARAM_VIRTUAL = "virtual";
    private static final String SSI_PARAM_FILE = "file";
    protected final ConfigurationService cfg;
    private final List<String> ssiPaths;

    public SSIResourceHandler(ConfigurationService cfg) {
        this.cfg = cfg;
        String paths = ConfigUtils.getString((ConfigurationService)cfg, (String)"org.jitsi.videobridge.rest.jetty.SSIResourceHandler.paths", (String)"org.jitsi.videobridge.rest.jetty.SSIResourceHandler.paths", null);
        this.ssiPaths = paths == null ? Collections.emptyList() : Arrays.asList(paths.split(";"));
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.ssiPaths.contains(target)) {
            this.handleSSIRequest(target, baseRequest, request, response);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private void handleSSIRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletResponseWrapper servletResponseWrapper = new HttpServletResponseWrapper(response);
        super.handle(target, baseRequest, request, (HttpServletResponse)servletResponseWrapper);
        byte[] processedResult = this.processContentForServerSideIncludes(servletResponseWrapper.getContent());
        response.setContentLength(processedResult.length);
        response.getOutputStream().write(processedResult);
    }

    private byte[] processContentForServerSideIncludes(byte[] content) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (content == null) {
            return out.toByteArray();
        }
        Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(content), "UTF-8").useDelimiter("(?<=\n)|(?!\n)(?<=\r)");
        Charset charset = StandardCharsets.UTF_8;
        while (scanner.hasNext()) {
            int endIx;
            String line = scanner.next();
            int startIx = line.indexOf(SSI_CMD_START);
            if (startIx != -1 && (endIx = line.indexOf(SSI_CMD_END, startIx + SSI_CMD_START.length())) != -1) {
                String cmd = line.substring(startIx + SSI_CMD_START.length(), endIx);
                out.write(line.substring(0, startIx).getBytes(charset));
                if (!this.processSSICmd(cmd, out)) {
                    out.write(SSI_CMD_START.getBytes(charset));
                    out.write(cmd.getBytes(charset));
                    out.write(SSI_CMD_END.getBytes(charset));
                }
                out.write(line.substring(endIx + SSI_CMD_END.length(), line.length()).getBytes(charset));
                continue;
            }
            out.write(line.getBytes(charset));
        }
        return out.toByteArray();
    }

    private boolean processSSICmd(String cmd, OutputStream out) throws IOException {
        if (cmd.startsWith(SSI_CMD_INCLUDE) && cmd.contains("=")) {
            Resource r;
            String parameterName = cmd.substring(SSI_CMD_INCLUDE.length(), cmd.indexOf("=")).trim();
            if (!SSI_PARAM_VIRTUAL.equals(parameterName) && !SSI_PARAM_FILE.equals(parameterName)) {
                return false;
            }
            String fileToInclude = cmd.substring(cmd.indexOf("=") + 1).trim();
            fileToInclude = fileToInclude.replaceAll("\\\"", "");
            if (SSI_PARAM_VIRTUAL.equals(parameterName)) {
                if (!fileToInclude.startsWith("/")) {
                    fileToInclude = "/" + fileToInclude;
                }
                String property = ".jetty.ResourceHandler.alias." + fileToInclude;
                String aliasValue = ConfigUtils.getString((ConfigurationService)this.cfg, (String)(OLD_PREFIX + property), (String)(OLD_PREFIX + property), null);
                if (aliasValue != null) {
                    fileToInclude = aliasValue;
                }
            }
            if ((r = Resource.newResource((String)fileToInclude)).exists()) {
                r.writeTo(out, 0L, r.length());
                return true;
            }
        }
        return false;
    }
}

