/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import java.net.SocketException;
import java.net.UnknownHostException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.videobridge.octo.OctoRelay;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class OctoRelayService
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(OctoRelayService.class);
    public static final String ADDRESS_PNAME = "org.jitsi.videobridge.octo.BIND_ADDRESS";
    public static final String PUBLIC_ADDRESS_PNAME = "org.jitsi.videobridge.octo.PUBLIC_ADDRESS";
    public static final String PORT_PNAME = "org.jitsi.videobridge.octo.BIND_PORT";
    private OctoRelay relay;
    private ConfigurationService cfg;

    public OctoRelay getRelay() {
        return this.relay;
    }

    public void start(BundleContext bundleContext) {
        this.cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        String address = this.cfg.getString(ADDRESS_PNAME, null);
        String publicAddress = this.cfg.getString(PUBLIC_ADDRESS_PNAME, address);
        int port = this.cfg.getInt(PORT_PNAME, -1);
        if (address != null && NetworkUtils.isValidPortNumber((int)port)) {
            try {
                this.relay = new OctoRelay(address, port);
                this.relay.setPublicAddress(publicAddress);
                bundleContext.registerService(OctoRelayService.class.getName(), (Object)this, null);
            }
            catch (SocketException | UnknownHostException e) {
                logger.error((Object)("Failed to initialize Octo relay with address " + address + ":" + port + ". "), (Throwable)e);
            }
        } else {
            logger.info((Object)"Octo relay not configured.");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.relay != null) {
            this.relay.stop();
        }
    }

    public String getRelayId() {
        return this.relay.getId();
    }
}

