/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jitsi.impl.neomedia.VideoMediaStreamImpl;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.translator.RTCPFeedbackMessageSender;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.rtp.BandwidthEstimator;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointMessageBuilder;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.cc.BandwidthProbing;
import org.jitsi.videobridge.cc.BitrateController;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;

public class VideoChannel
extends RtpChannel {
    public static final String DISABLE_LASTN_NOTIFICATIONS_PNAME = "org.jitsi.videobridge.DISABLE_LASTN_NOTIFICATIONS";
    public static final String DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS_PNAME = "org.jitsi.videobridge.DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS";
    @Deprecated
    public static final String DISABLE_NACK_TERMINATION_PNAME = "org.jitsi.videobridge.DISABLE_NACK_TERMINATION";
    static final String ENABLE_LIPSYNC_HACK_PNAME;
    private static final String LOG_OVERSENDING_STATS_PNAME = "org.jitsi.videobridge.LOG_OVERSENDING_STATS";
    private static final ConfigurationService cfg;
    public static final boolean DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS;
    private static final int[] DEFAULT_RTCP_RECV_REPORT_SSRCS;
    private static final int MAX_FRAME_HEIGHT_DEFAULT = 2160;
    private static final Logger classLogger;
    private static final Timer delayedFirTimer;
    private static RecurringRunnableExecutor recurringExecutor;
    private final boolean disableLastNNotifications;
    private int maxFrameHeight = 2160;
    private final BitrateController bitrateController = new BitrateController(this);
    private final BandwidthProbing bandwidthProbing = new BandwidthProbing(this);
    private final Logger logger;
    private TimerTask delayedFirTask;
    private final Object delayedFirTaskSyncRoot = new Object();
    private final RecurringRunnable logOversendingStatsRunnable;
    private int lastN = -1;

    private static synchronized RecurringRunnableExecutor getRecurringExecutor() {
        if (recurringExecutor == null) {
            recurringExecutor = new RecurringRunnableExecutor(VideoChannel.class.getSimpleName());
        }
        return recurringExecutor;
    }

    VideoChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) {
        super(content, id, channelBundleId, transportNamespace, initiator);
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)content.getConference().getLogger());
        this.disableLastNNotifications = cfg != null && cfg.getBoolean(DISABLE_LASTN_NOTIFICATIONS_PNAME, false);
        this.initializeTransformerEngine();
        if (cfg != null && cfg.getBoolean(LOG_OVERSENDING_STATS_PNAME, false)) {
            this.logOversendingStatsRunnable = this.createLogOversendingStatsRunnable();
            VideoChannel.getRecurringExecutor().registerRecurringRunnable(this.logOversendingStatsRunnable);
        } else {
            this.logOversendingStatsRunnable = null;
        }
        VideoChannel.getRecurringExecutor().registerRecurringRunnable((RecurringRunnable)this.bandwidthProbing);
    }

    @Override
    protected void maybeStartStream() throws IOException {
        boolean currentlyStarted;
        MediaStream stream = this.getStream();
        boolean previouslyStarted = stream != null && stream.isStarted();
        super.maybeStartStream();
        stream = this.getStream();
        boolean bl = currentlyStarted = stream != null && stream.isStarted();
        if (currentlyStarted && !previouslyStarted) {
            this.bitrateController.update(null, -1L);
        }
    }

    @Override
    protected void updateBitrateController() {
        this.bitrateController.update();
    }

    @Override
    public int[] getDefaultReceiveSSRCs() {
        return DEFAULT_RTCP_RECV_REPORT_SSRCS;
    }

    @Override
    void initialize(RTPLevelRelayType rtpLevelRelayType) throws IOException {
        super.initialize(rtpLevelRelayType);
        ((VideoMediaStream)this.getStream()).getOrCreateBandwidthEstimator().addListener(this.bitrateController::update);
    }

    public BitrateController getBitrateController() {
        return this.bitrateController;
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        super.describe((ColibriConferenceIQ.ChannelCommon)iq);
        iq.setLastN(Integer.valueOf(this.lastN));
    }

    public int getLastN() {
        return this.lastN;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String propertyName = ev.getPropertyName();
        if (Endpoint.PINNED_ENDPOINTS_PROPERTY_NAME.equals(propertyName) || Endpoint.SELECTED_ENDPOINTS_PROPERTY_NAME.equals(propertyName) || Conference.ENDPOINTS_PROPERTY_NAME.equals(propertyName)) {
            this.bitrateController.update();
        }
    }

    @Override
    boolean rtpTranslatorWillWrite(boolean data, RawPacket pkt, RtpChannel source) {
        if (!data) {
            return true;
        }
        return this.bitrateController.accept(pkt);
    }

    @Override
    void endpointMessageTransportConnected() {
        super.endpointMessageTransportConnected();
        this.sendLastNEndpointsChangeEvent(this.bitrateController.getForwardedEndpoints(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire() {
        BandwidthEstimator.Statistics bweStats;
        BandwidthEstimator bwe;
        MediaStream mediaStream;
        if (!super.expire()) {
            return false;
        }
        Object object = this.delayedFirTaskSyncRoot;
        synchronized (object) {
            if (this.delayedFirTask != null) {
                this.delayedFirTask.cancel();
                this.delayedFirTask = null;
            }
        }
        if (recurringExecutor != null && this.logOversendingStatsRunnable != null) {
            recurringExecutor.deRegisterRecurringRunnable(this.logOversendingStatsRunnable);
        }
        if (recurringExecutor != null) {
            recurringExecutor.deRegisterRecurringRunnable((RecurringRunnable)this.bandwidthProbing);
        }
        if ((mediaStream = this.getStream()) instanceof VideoMediaStream && (bwe = ((VideoMediaStream)mediaStream).getOrCreateBandwidthEstimator()) != null && (bweStats = bwe.getStatistics()) != null) {
            bweStats.update(System.currentTimeMillis());
            Videobridge.Statistics videobridgeStats = this.getContent().getConference().getVideobridge().getStatistics();
            long lossLimitedMs = bweStats.getLossLimitedMs();
            long lossDegradedMs = bweStats.getLossDegradedMs();
            long participantMs = bweStats.getLossFreeMs() + lossDegradedMs + lossLimitedMs;
            videobridgeStats.totalLossControlledParticipantMs.addAndGet(participantMs);
            videobridgeStats.totalLossLimitedParticipantMs.addAndGet(lossLimitedMs);
            videobridgeStats.totalLossDegradedParticipantMs.addAndGet(lossDegradedMs);
        }
        return true;
    }

    public void sendLastNEndpointsChangeEvent(Collection<String> forwardedEndpoints, Collection<String> endpointsEnteringLastN, Collection<String> conferenceEndpoints) {
        if (this.disableLastNNotifications) {
            return;
        }
        AbstractEndpoint thisEndpoint = this.getEndpoint();
        if (thisEndpoint == null) {
            return;
        }
        if (endpointsEnteringLastN == null) {
            endpointsEnteringLastN = forwardedEndpoints;
        }
        String msg = EndpointMessageBuilder.createLastNEndpointsChangeEvent(forwardedEndpoints, endpointsEnteringLastN, conferenceEndpoints);
        try {
            thisEndpoint.sendMessage(msg);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to send message on data channel.", (Throwable)e);
        }
    }

    @Override
    public void setLastN(int lastN) {
        if (this.lastN != lastN) {
            this.lastN = lastN;
            this.bitrateController.update();
        }
        this.touch();
    }

    @Override
    void speechActivityEndpointsChanged(List<AbstractEndpoint> endpoints) {
        this.bitrateController.update(endpoints, -1L);
    }

    @Override
    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        MediaStream mediaStream;
        super.setPayloadTypes(payloadTypes);
        boolean enableRedFilter = true;
        boolean supportsFir = false;
        boolean supportsPli = false;
        boolean supportsRemb = false;
        if (payloadTypes == null || payloadTypes.isEmpty()) {
            return;
        }
        for (PayloadTypePacketExtension payloadType : payloadTypes) {
            if ("red".equals(payloadType.getName())) {
                enableRedFilter = false;
            }
            for (RtcpFbPacketExtension rtcpFb : payloadType.getRtcpFeedbackTypeList()) {
                if ("ccm".equals(rtcpFb.getAttribute("type")) && "fir".equals(rtcpFb.getAttribute("subtype"))) {
                    supportsFir = true;
                    continue;
                }
                if ("nack".equals(rtcpFb.getAttribute("type")) && "pli".equals(rtcpFb.getAttribute("subtype"))) {
                    supportsPli = true;
                    continue;
                }
                if (!"goog-remb".equals(rtcpFb.getAttribute("type"))) continue;
                supportsRemb = true;
            }
        }
        if (this.transformEngine != null) {
            this.transformEngine.enableREDFilter(enableRedFilter);
        }
        if ((mediaStream = this.getStream()) instanceof VideoMediaStreamImpl) {
            ((VideoMediaStreamImpl)mediaStream).setSupportsFir(supportsFir);
            ((VideoMediaStreamImpl)mediaStream).setSupportsPli(supportsPli);
            ((VideoMediaStreamImpl)mediaStream).setSupportsRemb(supportsRemb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dominantSpeakerChanged() {
        AbstractEndpoint dominantEndpoint = this.conferenceSpeechActivity.getDominantEndpoint();
        if (dominantEndpoint != null && ((Object)((Object)dominantEndpoint)).equals((Object)this.getEndpoint())) {
            if (this.getContent().getChannelCount() < 3) {
                return;
            }
            long senderRtt = this.getRtt();
            long maxReceiverRtt = this.getMaxReceiverDelay();
            if (maxReceiverRtt > 0L && senderRtt > 0L) {
                long firDelay = maxReceiverRtt - senderRtt + 10L;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(Logger.Category.STATISTICS, "schedule_fir," + this.getLoggingId() + " delay=" + firDelay);
                }
                this.scheduleFir(firDelay);
            }
        } else {
            Object object = this.delayedFirTaskSyncRoot;
            synchronized (object) {
                if (this.delayedFirTask != null) {
                    this.delayedFirTask.cancel();
                }
            }
        }
    }

    private long getRtt() {
        long rtt = -1L;
        MediaStream stream = this.getStream();
        if (stream != null) {
            rtt = stream.getMediaStreamStats().getReceiveStats().getRtt();
        }
        return rtt;
    }

    public void setMaxFrameHeight(int maxFrameHeight) {
        this.maxFrameHeight = maxFrameHeight;
        this.bitrateController.update();
    }

    public int getMaxFrameHeight() {
        return this.maxFrameHeight;
    }

    private long getMaxReceiverDelay() {
        long maxRtt = -1L;
        for (Channel channel : this.getContent().getChannels()) {
            long rtt;
            if (!(channel instanceof VideoChannel) || this.equals(channel) || maxRtt >= (rtt = ((VideoChannel)channel).getRtt())) continue;
            maxRtt = rtt;
        }
        return maxRtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFir(long delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (VideoChannel.this.isExpired()) {
                    return;
                }
                MediaStreamTrackReceiver receiver = VideoChannel.this.getStream().getMediaStreamTrackReceiver();
                if (receiver == null) {
                    return;
                }
                Object[] tracks = receiver.getMediaStreamTracks();
                if (ArrayUtils.isNullOrEmpty((Object[])tracks)) {
                    return;
                }
                Object[] encodings = tracks[0].getRTPEncodings();
                if (ArrayUtils.isNullOrEmpty((Object[])encodings)) {
                    return;
                }
                int ssrc = (int)encodings[encodings.length - 1].getPrimarySSRC();
                RTCPFeedbackMessageSender rtcpFeedbackMessageSender = ((RTPTranslatorImpl)VideoChannel.this.getContent().getRTPTranslator()).getRtcpFeedbackMessageSender();
                if (rtcpFeedbackMessageSender != null) {
                    if (VideoChannel.this.logger.isTraceEnabled()) {
                        VideoChannel.this.logger.trace((Object)("send_fir,stream=" + VideoChannel.this.getStream().hashCode() + ",reason=scheduled"));
                    }
                    rtcpFeedbackMessageSender.requestKeyframe((long)ssrc & 0xFFFFFFFFL);
                }
            }
        };
        Object object = this.delayedFirTaskSyncRoot;
        synchronized (object) {
            if (this.delayedFirTask != null) {
                this.logger.warn((Object)("Canceling an existing delayed FIR task for endpoint " + this.getEndpoint().getID() + "."));
                this.delayedFirTask.cancel();
            }
            this.delayedFirTask = task;
        }
        delayedFirTimer.schedule(task, Math.max(0L, delay));
    }

    private RecurringRunnable createLogOversendingStatsRunnable() {
        return new PeriodicRunnable(1000L){
            private BandwidthEstimator bandwidthEstimator;
            {
                this.bandwidthEstimator = null;
            }

            public void run() {
                VideoMediaStream videoStream;
                super.run();
                if (this.bandwidthEstimator == null && (videoStream = (VideoMediaStream)VideoChannel.this.getStream()) != null) {
                    this.bandwidthEstimator = videoStream.getOrCreateBandwidthEstimator();
                }
                if (this.bandwidthEstimator == null) {
                    return;
                }
                long bwe = this.bandwidthEstimator.getLatestEstimate();
                if (bwe <= 0L) {
                    return;
                }
                long sendingBitrate = 0L;
                AbstractEndpoint endpoint = VideoChannel.this.getEndpoint();
                if (endpoint != null) {
                    sendingBitrate = endpoint.getChannels().stream().mapToLong(channel -> channel.getStream().getMediaStreamStats().getSendStats().getBitrate()).sum();
                }
                if (sendingBitrate <= 0L) {
                    return;
                }
                double lossRate = VideoChannel.this.getStream().getMediaStreamStats().getSendStats().getLossRate();
                if (VideoChannel.this.logger.isDebugEnabled()) {
                    VideoChannel.this.logger.debug(Logger.Category.STATISTICS, "sending_bitrate," + VideoChannel.this.getLoggingId() + " bwe=" + bwe + ",sbr=" + sendingBitrate + ",loss=" + lossRate + ",remb=" + this.bandwidthEstimator.getLatestREMB() + ",rrLoss=" + this.bandwidthEstimator.getLatestFractionLoss());
                }
            }
        };
    }

    static {
        int[] nArray;
        ENABLE_LIPSYNC_HACK_PNAME = VideoChannel.class.getName() + ".ENABLE_LIPSYNC_HACK";
        cfg = LibJitsi.getConfigurationService();
        DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS = cfg.getBoolean(DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS_PNAME, false);
        if (DISABLE_DEFAULT_RTCP_RECV_REPORT_SSRCS) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 2;
        }
        DEFAULT_RTCP_RECV_REPORT_SSRCS = nArray;
        classLogger = Logger.getLogger(VideoChannel.class);
        delayedFirTimer = new Timer();
    }
}

