/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.SocketClosedException;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.osgi.framework.AsyncExecutor;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.RawPacketQueue;
import org.jitsi.utils.concurrent.ExecutorUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.WebRtcDataStream;
import org.jitsi.videobridge.WebRtcDataStreamListener;

public class SctpConnection
extends Channel
implements SctpDataCallback,
SctpSocket.NotificationListener {
    private static int debugIdGen = -1;
    private static final int DTLS_BUFFER_SIZE = 2048;
    private static final boolean LOG_SCTP_PACKETS = false;
    private static final Logger classLogger = Logger.getLogger(SctpConnection.class);
    private static final int MSG_CHANNEL_ACK = 2;
    private static final byte[] MSG_CHANNEL_ACK_BYTES = new byte[]{2};
    private static final int MSG_OPEN_CHANNEL = 3;
    private static final int SCTP_BUFFER_SIZE = 2035;
    private static final ExecutorService threadPool = ExecutorUtils.newCachedThreadPool((boolean)true, (String)SctpConnection.class.getName());
    static final int WEB_RTC_PPID_BIN = 53;
    static final int WEB_RTC_PPID_CTRL = 50;
    static final int WEB_RTC_PPID_STRING = 51;
    private static final String WEBRTC_DATA_CHANNEL_PROTOCOL = "http://jitsi.org/protocols/colibri";
    private boolean acceptedIncomingConnection;
    private boolean assocIsUp;
    private final Map<Integer, WebRtcDataStream> channels = new HashMap<Integer, WebRtcDataStream>();
    private final int debugId;
    private final AsyncExecutor<Runnable> sctpDispatcher = new AsyncExecutor(15L, TimeUnit.MILLISECONDS);
    private final List<WebRtcDataStreamListener> listeners = new ArrayList<WebRtcDataStreamListener>();
    private final Object isReadyWaitLock = new Object();
    private final int remoteSctpPort;
    private SctpSocket sctpSocket;
    private boolean started;
    private final Object syncRoot = new Object();
    private final RawPacketQueue packetQueue;
    private DtlsPacketTransformer transformer = null;
    private final Handler handler = new Handler();
    private final Logger logger;

    private static synchronized int generateDebugId() {
        return debugIdGen += 2;
    }

    public SctpConnection(String id, Content content, AbstractEndpoint endpoint, int remoteSctpPort, String channelBundleId, Boolean initiator) {
        super(content, id, channelBundleId, "urn:xmpp:jingle:transports:ice-udp:1", initiator);
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)content.getConference().getLogger());
        this.setEndpoint(endpoint);
        this.packetQueue = new RawPacketQueue(false, this.getClass().getSimpleName() + "-" + endpoint.getID(), (PacketQueue.PacketHandler)this.handler);
        this.remoteSctpPort = remoteSctpPort;
        this.debugId = SctpConnection.generateDebugId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelListener(WebRtcDataStreamListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<WebRtcDataStreamListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeStream() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.assocIsUp = false;
            this.acceptedIncomingConnection = false;
            this.packetQueue.close();
            if (this.sctpSocket != null) {
                this.sctpSocket.close();
                this.sctpSocket = null;
            }
        }
    }

    @Override
    protected TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            Content content = this.getContent();
            return new IceUdpTransportManager(content.getConference(), this.isInitiator(), 1, content.getName());
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    @Override
    public boolean expire() {
        if (!super.expire()) {
            return false;
        }
        this.sctpDispatcher.shutdown();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachDataStream(Consumer<WebRtcDataStream> action) {
        ArrayList<WebRtcDataStream> streams;
        Object object = this.syncRoot;
        synchronized (object) {
            streams = new ArrayList<WebRtcDataStream>(this.channels.values());
        }
        streams.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebRtcDataStreamListener[] getChannelListeners() {
        WebRtcDataStreamListener[] ls;
        List<WebRtcDataStreamListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.isEmpty() ? null : this.listeners.toArray(new WebRtcDataStreamListener[this.listeners.size()]);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRtcDataStream getDefaultDataStream() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.sctpSocket != null) {
                WebRtcDataStream highestClientSid = this.channels.values().stream().filter(s -> this.isInitiator() ? s.getSid() % 2 == 1 : s.getSid() % 2 == 0).max(Comparator.comparingInt(WebRtcDataStream::getSid)).orElse(null);
                if (highestClientSid != null) {
                    return highestClientSid;
                }
                return this.channels.values().stream().max(Comparator.comparingInt(WebRtcDataStream::getSid)).orElse(null);
            }
            return null;
        }
    }

    public boolean isReady() {
        return this.assocIsUp && this.acceptedIncomingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeOpenDefaultWebRTCDataChannel() {
        boolean openChannel;
        Object object = this.syncRoot;
        synchronized (object) {
            openChannel = !this.isExpired() && this.sctpSocket != null && this.channels.size() == 0;
        }
        if (openChannel) {
            this.openDefaultWebRTCDataChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void maybeStartStream() {
        StreamConnector connector = this.getStreamConnector();
        if (connector == null) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.started) {
                return;
            }
            threadPool.execute(() -> {
                try {
                    Sctp.init();
                    this.runOnDtlsTransport(connector);
                }
                catch (IOException e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
                finally {
                    try {
                        Sctp.finish();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e);
                    }
                }
            });
            this.started = true;
        }
    }

    private void notifyChannelOpened(WebRtcDataStream dataChannel) {
        WebRtcDataStreamListener[] ls;
        if (!this.isExpired() && (ls = this.getChannelListeners()) != null) {
            for (WebRtcDataStreamListener l : ls) {
                l.onChannelOpened(this, dataChannel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCtrlPacket(byte[] data, int sid) throws IOException {
        Object object = this.syncRoot;
        synchronized (object) {
            this.onCtrlPacketNotSynchronized(data, sid);
        }
    }

    private void onCtrlPacketNotSynchronized(byte[] data, int sid) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int messageType = 0xFF & buffer.get();
        if (messageType == 2) {
            WebRtcDataStream channel;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.Category.STATISTICS, "sctp_ack_received," + this.getLoggingId() + " sid=" + sid);
            }
            if ((channel = this.channels.get(sid)) != null) {
                if (!channel.isAcknowledged()) {
                    channel.ackReceived();
                    this.notifyChannelOpened(channel);
                } else {
                    this.logger.log(Level.WARNING, Logger.Category.STATISTICS, "sctp_redundant_ack_received," + this.getLoggingId() + " sid=" + sid);
                }
            } else {
                this.logger.error(Logger.Category.STATISTICS, "sctp_no_channel_for_sid," + this.getLoggingId() + " sid=" + sid);
            }
        } else if (messageType == 3) {
            String protocol;
            String label;
            int channelType = 0xFF & buffer.get();
            int priority = 0xFFFF & buffer.getShort();
            long reliability = 0xFFFFFFFFL & (long)buffer.getInt();
            int labelLength = 0xFFFF & buffer.getShort();
            int protocolLength = 0xFFFF & buffer.getShort();
            if (labelLength == 0) {
                label = "";
            } else {
                byte[] labelBytes = new byte[labelLength];
                buffer.get(labelBytes);
                label = new String(labelBytes, "UTF-8");
            }
            if (protocolLength == 0) {
                protocol = "";
            } else {
                byte[] protocolBytes = new byte[protocolLength];
                buffer.get(protocolBytes);
                protocol = new String(protocolBytes, "UTF-8");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.Category.STATISTICS, "dc_open_request," + this.getLoggingId() + " sid=" + sid + ",type=" + channelType + ",prio=" + priority + ",reliab=" + reliability + ",label=" + label + ",proto=" + protocol);
            }
            WebRtcDataStream.DataCallback oldCallback = null;
            if (this.channels.containsKey(sid)) {
                this.logger.log(Level.SEVERE, Logger.Category.STATISTICS, "sctp_channel_exists," + this.getLoggingId() + " sid=" + sid);
                oldCallback = this.channels.get(sid).getDataCallback();
            }
            WebRtcDataStream newChannel = new WebRtcDataStream(this, this.sctpSocket, sid, label, true);
            this.channels.put(sid, newChannel);
            if (oldCallback != null) {
                newChannel.setDataCallback(oldCallback);
            }
            this.sendOpenChannelAck(sid);
            this.notifyChannelOpened(newChannel);
        } else {
            this.logger.error((Object)("Unexpected ctrl msg type: " + messageType));
        }
    }

    @Override
    protected void onEndpointChanged(AbstractEndpoint oldValue, AbstractEndpoint newValue) {
        super.onEndpointChanged(oldValue, newValue);
        if (oldValue != null && oldValue instanceof Endpoint) {
            ((Endpoint)oldValue).setSctpConnection(null);
        }
        if (newValue != null && newValue instanceof Endpoint) {
            ((Endpoint)newValue).setSctpConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSctpNotification(SctpSocket socket, SctpNotification notification) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.logger.isDebugEnabled() && 10 != notification.sn_type) {
                this.logger.info(Logger.Category.STATISTICS, "sctp_notification," + this.getLoggingId() + " notification=" + notification);
            }
            block4 : switch (notification.sn_type) {
                case 1: {
                    SctpNotification.AssociationChange assocChange = (SctpNotification.AssociationChange)notification;
                    switch (assocChange.state) {
                        case 1: {
                            Object object2 = this.isReadyWaitLock;
                            synchronized (object2) {
                                if (!this.assocIsUp) {
                                    this.assocIsUp = true;
                                    this.isReadyWaitLock.notifyAll();
                                }
                                break block4;
                            }
                        }
                        case 2: 
                        case 4: 
                        case 5: {
                            this.closeStream();
                        }
                    }
                }
            }
        }
    }

    private void openDefaultWebRTCDataChannel() {
        try {
            int sid = this.isInitiator() ? 0 : 1;
            this.logger.debug((Object)String.format("Will open default WebRTC data channel for: %s next SID: %d", this.getLoggingId(), sid));
            this.openChannel(0, 0, 0L, sid, "default");
        }
        catch (IOException e) {
            this.logger.error((Object)String.format("Could open the default data stream for endpoint: %s", this.getLoggingId()), (Throwable)e);
        }
    }

    public void onSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        this.sctpDispatcher.execute(() -> {
            if (!this.isExpired() && this.sctpSocket != null) {
                this.processSctpPacket(data, sid, ssn, tsn, ppid, context, flags);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRtcDataStream openChannel(int type, int prio, long reliab, int sid, String label) throws IOException {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.openChannelNotSynchronized(type, prio, reliab, sid, label);
        }
    }

    private WebRtcDataStream openChannelNotSynchronized(int type, int prio, long reliab, int sid, String label) throws IOException {
        int sentCount;
        int labelByteLength;
        byte[] labelBytes;
        if (this.channels.containsKey(sid)) {
            throw new IOException("Channel on sid: " + sid + " already exists");
        }
        if (label == null) {
            labelBytes = null;
            labelByteLength = 0;
        } else {
            labelBytes = label.getBytes("UTF-8");
            labelByteLength = Math.min(labelBytes.length, 65535);
        }
        String protocol = WEBRTC_DATA_CHANNEL_PROTOCOL;
        byte[] protocolBytes = protocol.getBytes("UTF-8");
        int protocolByteLength = Math.min(protocolBytes.length, 65535);
        ByteBuffer packet = ByteBuffer.allocate(12 + labelByteLength + protocolByteLength);
        packet.put((byte)3);
        packet.put((byte)type);
        packet.putShort((short)prio);
        packet.putInt((int)reliab);
        packet.putShort((short)labelByteLength);
        packet.putShort((short)protocolByteLength);
        if (labelByteLength != 0) {
            packet.put(labelBytes, 0, labelByteLength);
        }
        if (protocolByteLength != 0) {
            packet.put(protocolBytes, 0, protocolByteLength);
        }
        if ((sentCount = this.sctpSocket.send(packet.array(), true, sid, 50)) != packet.capacity()) {
            throw new IOException("Failed to open new chanel on sid: " + sid);
        }
        WebRtcDataStream channel = new WebRtcDataStream(this, this.sctpSocket, sid, label, false);
        this.channels.put(sid, channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (ppid == 50L) {
            try {
                this.onCtrlPacket(data, sid);
            }
            catch (IOException e) {
                this.logger.error((Object)"IOException when processing ctrl packet", (Throwable)e);
            }
        } else if (ppid == 51L || ppid == 53L) {
            WebRtcDataStream channel;
            Object object = this.syncRoot;
            synchronized (object) {
                channel = this.channels.get(sid);
            }
            if (channel == null) {
                this.logger.error((Object)("No channel found for sid: " + sid));
                return;
            }
            if (ppid == 51L) {
                String charsetName = "UTF-8";
                try {
                    String str = new String(data, charsetName);
                    channel.onStringMsg(str);
                }
                catch (UnsupportedEncodingException uee) {
                    this.logger.error((Object)("Unsupported charset encoding/name " + charsetName), (Throwable)uee);
                }
            } else {
                channel.onBinaryMsg(data);
            }
        } else {
            this.logger.warn((Object)("Got message on unsupported PPID: " + ppid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannelListener(WebRtcDataStreamListener listener) {
        if (listener != null) {
            List<WebRtcDataStreamListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void runOnDtlsTransport(StreamConnector connector) throws IOException {
        srtpControl = this.getTransportManager().getSrtpControl(this);
        engine = (DtlsTransformEngine)srtpControl.getTransformEngine();
        transformer = (DtlsPacketTransformer)engine.getRTPTransformer();
        if (this.transformer == null) {
            this.transformer = transformer;
        }
        receiveBuffer = new byte[2035];
        var6_6 = this.syncRoot;
        synchronized (var6_6) {
            this.sctpSocket = Sctp.createSocket((int)5000);
            this.assocIsUp = false;
            this.acceptedIncomingConnection = false;
        }
        this.sctpSocket.setLink(new NetworkLink(){

            public void onConnOut(SctpSocket s, byte[] packet) throws IOException {
                SctpConnection.this.packetQueue.add(packet, 0, packet.length);
            }
        });
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting SCTP to port: " + this.remoteSctpPort + " to " + this.getEndpoint().getID()));
        }
        this.sctpSocket.setNotificationListener((SctpSocket.NotificationListener)this);
        this.sctpSocket.listen();
        this.sctpSocket.setDataCallback((SctpDataCallback)this);
        this.sctpDispatcher.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, acceptIncomingSctpConnection(), ()V)((SctpConnection)this));
        datagramSocket = connector.getDataSocket();
        iceSocket /* !! */  = datagramSocket != null ? new IceUdpSocketWrapper(datagramSocket) : new IceTcpSocketWrapper(connector.getDataTCPSocket());
        recv = new DatagramPacket(receiveBuffer, 0, receiveBuffer.length);
        try {
            block8: while (true) {
                iceSocket /* !! */ .receive(recv);
                send = new RawPacket[]{new RawPacket(recv.getData(), recv.getOffset(), recv.getLength())};
                if ((send = transformer.reverseTransform(send)) == null || send.length == 0) continue;
                this.touch(Channel.ActivityType.PAYLOAD);
                if (this.sctpSocket == null) {
                    break;
                }
                var10_12 = send;
                var11_13 = var10_12.length;
                var12_14 = 0;
                while (true) {
                    if (var12_14 < var11_13) ** break;
                    continue block8;
                    s = var10_12[var12_14];
                    if (s != null) {
                        this.sctpSocket.onConnIn(s.getBuffer(), s.getOffset(), s.getLength());
                    }
                    ++var12_14;
                }
                break;
            }
        }
        catch (SocketException ex) {
            if (!"Socket closed".equals(ex.getMessage()) && !(ex instanceof SocketClosedException)) {
                throw ex;
            }
        }
        finally {
            this.closeStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptIncomingSctpConnection() {
        SctpSocket sctpSocket = null;
        try {
            sctpSocket = this.sctpSocket;
            while (sctpSocket != null) {
                if (sctpSocket.accept()) {
                    this.acceptedIncomingConnection = true;
                    this.logger.info((Object)String.format("SCTP socket accepted on %s", this.getLoggingId()));
                    break;
                }
                Thread.sleep(100L);
                sctpSocket = this.sctpSocket;
            }
            Object object = this.isReadyWaitLock;
            synchronized (object) {
                while (sctpSocket != null && !this.isExpired() && !this.isReady()) {
                    this.isReadyWaitLock.wait();
                    sctpSocket = this.sctpSocket;
                }
                this.sctpDispatcher.execute(this::maybeOpenDefaultWebRTCDataChannel);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Error accepting SCTP connection %s", this.getLoggingId()), (Throwable)e);
        }
        if (sctpSocket == null) {
            this.logger.info((Object)String.format("SctpConnection %s closed before SctpSocket accept()-ed.", this.getLoggingId()));
        }
    }

    private void sendOpenChannelAck(int sid) throws IOException {
        byte[] ack = MSG_CHANNEL_ACK_BYTES;
        if (this.sctpSocket.send(ack, true, sid, 50) != ack.length) {
            this.logger.error((Object)"Failed to send open channel confirmation");
        }
    }

    private class Handler
    implements PacketQueue.PacketHandler<RawPacket> {
        private Handler() {
        }

        public boolean handlePacket(RawPacket pkt) {
            if (pkt == null) {
                return true;
            }
            DtlsPacketTransformer transformer = SctpConnection.this.transformer;
            if (transformer == null) {
                SctpConnection.this.logger.error((Object)"Cannot send SCTP packet, DTLS transformer is null");
                return false;
            }
            transformer.sendApplicationData(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
            return true;
        }
    }
}

