/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointMessageBuilder;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.WebRtcDataStream;
import org.jitsi.videobridge.WebRtcDataStreamListener;
import org.jitsi.videobridge.rest.ColibriWebSocket;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class EndpointMessageTransport
extends AbstractEndpointMessageTransport
implements WebRtcDataStream.DataCallback {
    private static final Logger classLogger = Logger.getLogger(EndpointMessageTransport.class);
    private final Endpoint endpoint;
    private final Logger logger;
    private ColibriWebSocket webSocket;
    private final Object webSocketSyncRoot = new Object();
    private boolean webSocketLastActive = false;
    private WeakReference<SctpConnection> sctpConnection = new WeakReference<Object>(null);
    private WebRtcDataStream writableWebRtcDataStream;
    private final WebRtcDataStreamListener webRtcDataStreamListener = new WebRtcDataStreamListener(){

        @Override
        public void onChannelOpened(SctpConnection source, WebRtcDataStream channel) {
            SctpConnection currentConnection = EndpointMessageTransport.this.getSctpConnection();
            if (source.equals(currentConnection)) {
                EndpointMessageTransport.this.hookUpDefaultWebRtcDataChannel(currentConnection);
            }
        }
    };

    EndpointMessageTransport(Endpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)endpoint.getConference().getLogger());
    }

    private void hookUpDefaultWebRtcDataChannel(SctpConnection connection) {
        WebRtcDataStream _defaultStream;
        WebRtcDataStream webRtcDataStream = _defaultStream = connection != null ? connection.getDefaultDataStream() : null;
        if (_defaultStream != null) {
            WebRtcDataStream oldDataStream = this.writableWebRtcDataStream;
            this.writableWebRtcDataStream = _defaultStream;
            _defaultStream.setDataCallback(this);
            if (oldDataStream == null) {
                this.logger.info((Object)String.format("WebRTC data channel established for %s", connection.getLoggingId()));
                this.notifyTransportChannelConnected();
            }
        }
    }

    @Override
    protected void notifyTransportChannelConnected() {
        EventAdmin eventAdmin = this.endpoint.getConference().getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.postEvent(EventFactory.endpointMessageTransportReady(this.endpoint));
        }
        this.endpoint.getConference().endpointMessageTransportConnected(this.endpoint);
        for (RtpChannel channel : this.endpoint.getChannels()) {
            channel.endpointMessageTransportConnected();
        }
    }

    @Override
    protected void onClientHello(Object src, JSONObject jsonObject) {
        this.sendMessage(src, EndpointMessageBuilder.createServerHelloEvent(), "response to ClientHello");
    }

    private void sendMessage(Object dst, String message) {
        this.sendMessage(dst, message, "");
    }

    private void sendMessage(Object dst, String message, String errorMessage) {
        if (dst instanceof WebRtcDataStream) {
            this.sendMessage((WebRtcDataStream)dst, message, errorMessage);
        } else if (dst instanceof ColibriWebSocket) {
            this.sendMessage((ColibriWebSocket)((Object)dst), message, errorMessage);
        } else {
            throw new IllegalArgumentException("unknown transport:" + dst);
        }
    }

    private void sendMessage(WebRtcDataStream dst, String message, String errorMessage) {
        try {
            dst.sendString(message);
            this.endpoint.getConference().getVideobridge().getStatistics().totalDataChannelMessagesSent.incrementAndGet();
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Failed to send a message over a WebRTC data channel (endpoint=" + this.endpoint.getID() + "): " + errorMessage), (Throwable)ioe);
        }
    }

    private void sendMessage(ColibriWebSocket dst, String message, String errorMessage) {
        dst.getRemote().sendStringByFuture(message);
        this.endpoint.getConference().getVideobridge().getStatistics().totalColibriWebSocketMessagesSent.incrementAndGet();
    }

    @Override
    protected void onPinnedEndpointChangedEvent(Object src, JSONObject jsonObject) {
        String newPinnedEndpointID = (String)jsonObject.get((Object)"pinnedEndpoint");
        Set<String> newPinnedIDs = Collections.EMPTY_SET;
        if (newPinnedEndpointID != null && !"".equals(newPinnedEndpointID)) {
            newPinnedIDs = Collections.singleton(newPinnedEndpointID);
        }
        this.endpoint.pinnedEndpointsChanged(newPinnedIDs);
    }

    @Override
    protected void onPinnedEndpointsChangedEvent(Object src, JSONObject jsonObject) {
        Object o = jsonObject.get((Object)"pinnedEndpoints");
        if (!(o instanceof JSONArray)) {
            this.logger.warn((Object)("Received invalid or unexpected JSON (" + this.endpoint.getLoggingId() + "):" + jsonObject));
            return;
        }
        JSONArray jsonArray = (JSONArray)o;
        HashSet<String> newPinnedEndpoints = new HashSet<String>();
        for (Object endpointId : jsonArray) {
            if (endpointId == null || !(endpointId instanceof String)) continue;
            newPinnedEndpoints.add((String)endpointId);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.Category.STATISTICS, "pinned," + this.endpoint.getLoggingId() + " pinned=" + newPinnedEndpoints);
        }
        this.endpoint.pinnedEndpointsChanged(newPinnedEndpoints);
    }

    @Override
    protected void onSelectedEndpointChangedEvent(Object src, JSONObject jsonObject) {
        String newSelectedEndpointID = (String)jsonObject.get((Object)"selectedEndpoint");
        Set<String> newSelectedIDs = Collections.EMPTY_SET;
        if (newSelectedEndpointID != null && !"".equals(newSelectedEndpointID)) {
            newSelectedIDs = Collections.singleton(newSelectedEndpointID);
        }
        this.endpoint.selectedEndpointsChanged(newSelectedIDs);
    }

    @Override
    protected void onSelectedEndpointsChangedEvent(Object src, JSONObject jsonObject) {
        Object o = jsonObject.get((Object)"selectedEndpoints");
        if (!(o instanceof JSONArray)) {
            this.logger.warn((Object)("Received invalid or unexpected JSON: " + jsonObject));
            return;
        }
        JSONArray jsonArray = (JSONArray)o;
        HashSet<String> newSelectedEndpoints = new HashSet<String>();
        for (Object endpointId : jsonArray) {
            if (endpointId == null || !(endpointId instanceof String)) continue;
            newSelectedEndpoints.add((String)endpointId);
        }
        this.endpoint.selectedEndpointsChanged(newSelectedEndpoints);
    }

    @Override
    public void onStringData(WebRtcDataStream src, String msg) {
        this.webSocketLastActive = false;
        this.endpoint.getConference().getVideobridge().getStatistics().totalDataChannelMessagesReceived.incrementAndGet();
        this.onMessage(src, msg);
    }

    @Override
    protected void sendMessage(String msg) throws IOException {
        Object dst = this.getActiveTransportChannel();
        if (dst == null) {
            this.logger.warn((Object)"No available transport channel, can't send a message");
        } else {
            this.sendMessage(dst, msg);
        }
    }

    private Object getActiveTransportChannel() {
        SctpConnection sctpConnection = this.getSctpConnection();
        ColibriWebSocket webSocket = this.webSocket;
        String endpointId = this.endpoint.getID();
        Object dst = null;
        if (this.webSocketLastActive) {
            dst = webSocket;
        }
        if (dst == null) {
            if (sctpConnection != null && sctpConnection.isReady()) {
                dst = this.writableWebRtcDataStream;
                if (dst == null) {
                    this.logger.warn((Object)("SCTP ready, but WebRtc data channel with " + endpointId + " not opened yet."));
                }
            } else {
                this.logger.warn((Object)("SCTP connection with " + endpointId + " not ready yet."));
            }
        }
        if (dst == null && webSocket != null) {
            dst = webSocket;
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWebSocketConnect(ColibriWebSocket ws) {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            if (this.webSocket != null) {
                this.webSocket.getSession().close(200, "replaced");
            }
            this.webSocket = ws;
            this.webSocketLastActive = true;
            this.sendMessage(ws, EndpointMessageBuilder.createServerHelloEvent(), "initial ServerHello");
        }
        this.notifyTransportChannelConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(ColibriWebSocket ws, int statusCode, String reason) {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            if (ws != null && ((Object)((Object)ws)).equals((Object)this.webSocket)) {
                this.webSocket = null;
                this.webSocketLastActive = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Web socket closed for endpoint " + this.endpoint.getID() + ": " + statusCode + " " + reason));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            if (this.webSocket != null) {
                this.webSocket.getSession().close(410, "replaced");
                this.webSocket = null;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Endpoint expired, closed colibri web-socket.");
                }
            }
        }
    }

    public void onWebSocketText(ColibriWebSocket ws, String message) {
        if (ws == null || !((Object)((Object)ws)).equals((Object)this.webSocket)) {
            this.logger.warn((Object)("Received text from an unknown web socket (endpoint=" + this.endpoint.getID() + ")."));
            return;
        }
        this.endpoint.getConference().getVideobridge().getStatistics().totalColibriWebSocketMessagesReceived.incrementAndGet();
        this.webSocketLastActive = true;
        this.onMessage((Object)ws, message);
    }

    SctpConnection getSctpConnection() {
        return (SctpConnection)this.sctpConnection.get();
    }

    void setSctpConnection(SctpConnection sctpConnection) {
        SctpConnection oldValue = this.getSctpConnection();
        if (!Objects.equals(oldValue, sctpConnection)) {
            if (oldValue != null && sctpConnection != null) {
                this.logger.warn((Object)"Replacing an Endpoint's SctpConnection.");
            }
            this.sctpConnection = new WeakReference<SctpConnection>(sctpConnection);
            if (sctpConnection != null) {
                this.hookUpDefaultWebRtcDataChannel(sctpConnection);
                sctpConnection.addChannelListener(this.webRtcDataStreamListener);
            }
            if (oldValue != null) {
                oldValue.forEachDataStream(stream -> {
                    if (stream.getDataCallback() == this) {
                        stream.setDataCallback(null);
                    }
                });
                if (this.writableWebRtcDataStream != null && this.writableWebRtcDataStream.getSctpConnection() == oldValue) {
                    this.writableWebRtcDataStream = null;
                }
                oldValue.removeChannelListener(this.webRtcDataStreamListener);
            }
        }
    }
}

