/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.concurrent.ExecutorUtils;
import org.jitsi.utils.dsi.ActiveSpeakerChangedListener;
import org.jitsi.utils.dsi.ActiveSpeakerDetector;
import org.jitsi.utils.dsi.DominantSpeakerIdentification;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.event.WeakReferencePropertyChangeListener;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConferenceSpeechActivity
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String DOMINANT_ENDPOINT_PROPERTY_NAME = ConferenceSpeechActivity.class.getName() + ".dominantEndpoint";
    public static final String ENDPOINTS_PROPERTY_NAME = ConferenceSpeechActivity.class.getName() + ".endpoints";
    private static final ExecutorService executorService = ExecutorUtils.newCachedThreadPool((boolean)true, (String)"ConferenceSpeechActivity");
    private static final Logger logger = Logger.getLogger(ConferenceSpeechActivity.class);
    private final ActiveSpeakerChangedListener activeSpeakerChangedListener = this::activeSpeakerChanged;
    private final Object activeSpeakerDetectorSyncRoot = new Object();
    private Conference conference;
    private AbstractEndpoint dominantEndpoint;
    private boolean dominantEndpointChanged = false;
    private DominantSpeakerIdentification dominantSpeakerIdentification;
    private List<AbstractEndpoint> endpoints;
    private boolean endpointsChanged = false;
    private EventDispatcher eventDispatcher;
    private long eventDispatcherTime;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    private final Object syncRoot = new Object();

    private static long parseSSRC(Object obj) {
        long l;
        if (obj == null) {
            l = -1L;
        } else if (obj instanceof Number) {
            l = ((Number)obj).longValue();
        } else {
            String s = obj.toString();
            if (s == null) {
                l = -1L;
            } else {
                try {
                    l = Long.parseLong(s);
                }
                catch (NumberFormatException ex) {
                    l = -1L;
                }
            }
        }
        return l;
    }

    private static void resolveSSRCAsEndpoint(JSONObject jsonObject, String ssrcKey, Conference conference, String endpointKey) {
        AbstractEndpoint endpoint;
        long ssrc = ConferenceSpeechActivity.parseSSRC(jsonObject.get((Object)ssrcKey));
        if (ssrc != -1L && (endpoint = conference.findEndpointByReceiveSSRC(ssrc, MediaType.AUDIO)) != null) {
            jsonObject.put((Object)endpointKey, (Object)endpoint.getID());
        }
    }

    public ConferenceSpeechActivity(Conference conference) {
        this.conference = Objects.requireNonNull(conference, "conference");
        conference.addPropertyChangeListener(this.propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeSpeakerChanged(long ssrc) {
        Conference conference = this.getConference();
        if (conference != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("The dominant speaker in conference " + conference.getID() + " is now the SSRC " + ssrc + "."));
            }
            AbstractEndpoint endpoint = conference.findEndpointByReceiveSSRC(ssrc, MediaType.AUDIO);
            boolean maybeStartEventDispatcher = false;
            Object object = this.syncRoot;
            synchronized (object) {
                if (endpoint == null) {
                    maybeStartEventDispatcher = true;
                } else {
                    AbstractEndpoint dominantEndpoint = this.getDominantEndpoint();
                    if (!((Object)((Object)endpoint)).equals((Object)dominantEndpoint)) {
                        this.dominantEndpoint = endpoint;
                        maybeStartEventDispatcher = true;
                    }
                }
                if (maybeStartEventDispatcher) {
                    this.dominantEndpointChanged = true;
                    this.maybeStartEventDispatcher();
                }
            }
        }
    }

    public JSONObject doGetDominantSpeakerIdentificationJSON() {
        JSONObject jsonObject;
        block7: {
            Conference conference;
            DominantSpeakerIdentification dominantSpeakerIdentification;
            block8: {
                block6: {
                    dominantSpeakerIdentification = this.getDominantSpeakerIdentification();
                    if (dominantSpeakerIdentification != null) break block6;
                    jsonObject = null;
                    break block7;
                }
                conference = this.getConference();
                if (conference != null) break block8;
                jsonObject = null;
                break block7;
            }
            jsonObject = dominantSpeakerIdentification.doGetJSON();
            if (jsonObject == null) break block7;
            ConferenceSpeechActivity.resolveSSRCAsEndpoint(jsonObject, "dominantSpeaker", conference, "dominantEndpoint");
            Object speakers = jsonObject.get((Object)"speakers");
            if (speakers != null) {
                if (speakers instanceof JSONObject[]) {
                    for (JSONObject speaker : (JSONObject[])speakers) {
                        ConferenceSpeechActivity.resolveSSRCAsEndpoint(speaker, "ssrc", conference, "endpoint");
                    }
                } else if (speakers instanceof JSONArray) {
                    for (Object speaker : (JSONArray)speakers) {
                        if (!(speaker instanceof JSONObject)) continue;
                        ConferenceSpeechActivity.resolveSSRCAsEndpoint((JSONObject)speaker, "ssrc", conference, "endpoint");
                    }
                }
            }
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventDispatcherExited(EventDispatcher eventDispatcher) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.eventDispatcher == eventDispatcher) {
                this.eventDispatcher = eventDispatcher;
                this.eventDispatcherTime = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveSpeakerDetector getActiveSpeakerDetector() {
        Conference conference;
        DominantSpeakerIdentification dominantSpeakerIdentification;
        boolean addActiveSpeakerChangedListener = false;
        Object object = this.activeSpeakerDetectorSyncRoot;
        synchronized (object) {
            dominantSpeakerIdentification = this.dominantSpeakerIdentification;
            if (dominantSpeakerIdentification == null) {
                DominantSpeakerIdentification dsi = new DominantSpeakerIdentification();
                addActiveSpeakerChangedListener = true;
                this.dominantSpeakerIdentification = dominantSpeakerIdentification = dsi;
            }
        }
        if (addActiveSpeakerChangedListener && (conference = this.getConference()) != null) {
            dominantSpeakerIdentification.addActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
            dominantSpeakerIdentification.addPropertyChangeListener(this.propertyChangeListener);
        }
        return dominantSpeakerIdentification;
    }

    private Conference getConference() {
        Conference conference = this.conference;
        if (conference != null && conference.isExpired()) {
            conference = null;
            this.conference = null;
            DominantSpeakerIdentification dominantSpeakerIdentification = this.dominantSpeakerIdentification;
            if (dominantSpeakerIdentification != null) {
                dominantSpeakerIdentification.removeActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
                dominantSpeakerIdentification.removePropertyChangeListener(this.propertyChangeListener);
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEndpoint getDominantEndpoint() {
        AbstractEndpoint dominantEndpoint;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.dominantEndpoint == null) {
                dominantEndpoint = null;
            } else {
                dominantEndpoint = this.dominantEndpoint;
                if (dominantEndpoint.isExpired()) {
                    this.dominantEndpoint = null;
                }
            }
        }
        return dominantEndpoint;
    }

    private DominantSpeakerIdentification getDominantSpeakerIdentification() {
        this.getActiveSpeakerDetector();
        return this.dominantSpeakerIdentification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractEndpoint> getEndpoints() {
        ArrayList<AbstractEndpoint> ret;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.endpoints == null) {
                Conference conference = this.getConference();
                if (conference == null) {
                    this.endpoints = new ArrayList<AbstractEndpoint>();
                } else {
                    List<AbstractEndpoint> conferenceEndpoints = conference.getEndpoints();
                    this.endpoints = new ArrayList<AbstractEndpoint>(conferenceEndpoints);
                }
            }
            ret = new ArrayList<AbstractEndpoint>(this.endpoints);
            ret.removeIf(Objects::isNull);
        }
        return ret;
    }

    public void levelChanged(Channel channel, long ssrc, int level) {
        ActiveSpeakerDetector activeSpeakerDetector = this.getActiveSpeakerDetector();
        if (activeSpeakerDetector != null) {
            activeSpeakerDetector.levelChanged(ssrc, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartEventDispatcher() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.eventDispatcher == null) {
                EventDispatcher eventDispatcher = new EventDispatcher(this);
                boolean scheduled = false;
                this.eventDispatcher = eventDispatcher;
                this.eventDispatcherTime = 0L;
                try {
                    executorService.execute(eventDispatcher);
                    scheduled = true;
                }
                finally {
                    if (!scheduled && this.eventDispatcher == eventDispatcher) {
                        this.eventDispatcher = null;
                        this.eventDispatcherTime = 0L;
                    }
                }
            } else {
                this.syncRoot.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Conference conference = this.getConference();
        if (conference == null) {
            return;
        }
        String propertyName = ev.getPropertyName();
        if (Conference.ENDPOINTS_PROPERTY_NAME.equals(propertyName) && conference.equals(ev.getSource())) {
            Object object = this.syncRoot;
            synchronized (object) {
                this.endpointsChanged = true;
                this.maybeStartEventDispatcher();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInEventDispatcher(EventDispatcher eventDispatcher) {
        boolean endpointsChanged = false;
        boolean dominantEndpointChanged = false;
        Object object = this.syncRoot;
        synchronized (object) {
            long wait;
            if (this.eventDispatcher != eventDispatcher) {
                return false;
            }
            Conference conference = this.getConference();
            if (conference == null) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (!this.dominantEndpointChanged && !this.endpointsChanged && (wait = 100L - (now - this.eventDispatcherTime)) > 0L) {
                try {
                    this.syncRoot.wait(wait);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            this.eventDispatcherTime = now;
            List<AbstractEndpoint> conferenceEndpoints = conference.getEndpoints();
            if (this.endpoints == null) {
                this.endpoints = new ArrayList<AbstractEndpoint>(conferenceEndpoints);
                endpointsChanged = true;
            } else {
                endpointsChanged = this.endpoints.removeIf(e -> e.isExpired() || !conferenceEndpoints.contains(e));
                conferenceEndpoints.removeAll(this.endpoints);
                endpointsChanged |= this.endpoints.addAll(conferenceEndpoints);
            }
            this.endpointsChanged = false;
            AbstractEndpoint dominantEndpoint = this.getDominantEndpoint();
            if (dominantEndpoint != null) {
                this.endpoints.remove((Object)dominantEndpoint);
                this.endpoints.add(0, dominantEndpoint);
            }
            if (this.dominantEndpointChanged) {
                dominantEndpointChanged = true;
                this.dominantEndpointChanged = false;
            }
        }
        if (endpointsChanged) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        if (dominantEndpointChanged) {
            this.firePropertyChange(DOMINANT_ENDPOINT_PROPERTY_NAME, null, null);
        }
        return true;
    }

    private static class EventDispatcher
    implements Runnable {
        private final WeakReference<ConferenceSpeechActivity> owner;

        public EventDispatcher(ConferenceSpeechActivity owner) {
            this.owner = new WeakReference<ConferenceSpeechActivity>(owner);
        }

        @Override
        public void run() {
            ConferenceSpeechActivity owner;
            try {
                while ((owner = (ConferenceSpeechActivity)this.owner.get()) != null) {
                    if (owner.runInEventDispatcher(this)) continue;
                    break;
                }
            }
            finally {
                owner = (ConferenceSpeechActivity)this.owner.get();
                if (owner != null) {
                    owner.eventDispatcherExited(this);
                }
            }
        }
    }
}

